/*
 * Decompiled with CFR 0.152.
 */
package Pandora.NDRules;

import Pandora.LogicParser.Formula.Formula;
import Pandora.LogicParser.Formula.Unknown;
import Pandora.NDRules.NDRule;
import Pandora.ProofBox;
import Pandora.ProofItem;
import Pandora.ProofLine;
import Pandora.ProofWindow;

public class Instantiate
extends NDRule {
    private ProofWindow window = null;

    public Instantiate(ProofBox proofBox) {
        super(proofBox);
        this.window = proofBox.getParentWindow();
    }

    @Override
    public void addLine(ProofLine proofLine) throws Exception {
    }

    @Override
    public boolean haveAll() {
        return true;
    }

    @Override
    public void check() throws Exception {
    }

    @Override
    public void apply() throws Exception {
        if (!(this.firstLine.getFormula() instanceof Unknown)) {
            this.proof.deselectAll();
            throw new Exception("The instantiate rule can only be applied to an Unknown formula.");
        }
        Formula formula = this.getNewFormula("", "Enter the formula you would like the unknown formula to be instantiated with.");
        if (formula != null) {
            Formula formula2 = this.firstLine.getFormula();
            String string = formula2.display();
            ProofBox proofBox = this.window.mainProofBox;
            this.unify(string, formula, proofBox);
            this.window.commitSaveState();
        }
    }

    private void unify(String string, Formula formula, ProofBox proofBox) {
        Object object;
        if (proofBox.hasNextBox()) {
            object = proofBox.getNextBox();
            this.unify(string, formula, (ProofBox)object);
        }
        object = proofBox.getProofItems().listIterator(0);
        while (object.hasNext()) {
            ProofItem proofItem;
            ProofItem proofItem2 = (ProofItem)object.next();
            if (proofItem2 instanceof ProofLine) {
                proofItem = (ProofLine)proofItem2;
                if (((ProofLine)proofItem).getJustification().getSymbol().equals("")) continue;
                if (((ProofLine)proofItem).getFormula().display().equals(string)) {
                    ((ProofLine)proofItem).setFormula(formula);
                    continue;
                }
                this.checkFormula(string, formula, ((ProofLine)proofItem).getFormula());
                continue;
            }
            if (!(proofItem2 instanceof ProofBox)) continue;
            proofItem = (ProofBox)proofItem2;
            this.unify(string, formula, (ProofBox)proofItem);
        }
    }

    private void checkFormula(String string, Formula formula, Formula formula2) {
        try {
            Formula formula3 = formula2.getLeft();
            if (formula3.display().equals(string)) {
                formula2.setLeft(formula);
            } else {
                this.checkFormula(string, formula, formula3);
            }
            Formula formula4 = formula2.getRight();
            if (formula4.display().equals(string)) {
                formula2.setRight(formula);
            } else {
                this.checkFormula(string, formula, formula4);
            }
        }
        catch (Exception exception) {
            this.proof.deselectAll();
        }
    }
}

