/*
 * Decompiled with CFR 0.152.
 */
package Pandora.NDRules;

import Pandora.LogicParser.Formula.Formula;
import Pandora.LogicParser.ParseController;
import Pandora.PanSignature;
import Pandora.ProofBox;
import Pandora.ProofLine;
import Pandora.ProofWindow;
import javax.swing.JOptionPane;

public abstract class NDRule {
    boolean isForwards;
    public ProofLine firstLine;
    ProofBox proof;
    PanSignature newSignature = new PanSignature();
    String check = "";
    String error = "\u2718";

    public NDRule(ProofBox proofBox) {
        this.proof = proofBox;
    }

    public void addInputLine(ProofLine proofLine) throws Exception {
        this.firstLine = proofLine;
        if (proofLine.getJustification().getSymbol().equals("<goal>")) {
            this.isForwards = false;
        } else if (proofLine.getJustification().getSymbol().equals("")) {
            this.isForwards = true;
        } else {
            this.proof.deselectAll();
            throw new Exception("The first line selected must be a goal line or an empty line.");
        }
    }

    public abstract boolean haveAll();

    public abstract void addLine(ProofLine var1) throws Exception;

    public abstract void check() throws Exception;

    public abstract void apply() throws Exception;

    public boolean checkSignature(Formula formula) {
        PanSignature panSignature = this.proof.getSignature();
        PanSignature panSignature2 = panSignature.clone();
        this.check = formula.clashes(panSignature2);
        if (this.check.contains(this.error)) {
            return false;
        }
        this.newSignature = panSignature.compare(panSignature2);
        return this.newSignature.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Formula getNewFormula(String string, String string2) throws Exception {
        ProofWindow proofWindow = this.proof.getParentWindow();
        PanSignature panSignature = this.proof.getSignature();
        Formula formula = null;
        boolean bl = false;
        String string3 = null;
        Object[] objectArray = null;
        String string4 = (String)JOptionPane.showInputDialog(proofWindow.view, string2, "Input Required", 3, null, objectArray, string);
        if (string4 == null) {
            bl = true;
        } else {
            string3 = string4;
        }
        if (bl) return formula;
        ParseController parseController = new ParseController(string3);
        Formula formula2 = parseController.parseLine();
        if (formula2 == null) {
            throw new Exception("The formula you entered could not be parsed.");
        }
        if (formula2 == null) return formula;
        boolean bl2 = this.checkSignature(formula2);
        if (bl2) return formula2;
        if (this.check.contains(this.error)) {
            Object[] objectArray2 = new Object[]{"Edit Formula", "Cancel"};
            int n = JOptionPane.showOptionDialog(proofWindow.view, "Input Formula : " + formula2.display() + "\n" + this.check + "\nWhat would you like to do? \n\n", "Error", 0, 3, null, objectArray2, objectArray2[0]);
            if (n == 0) {
                return this.getNewFormula(string3, string2);
            }
            if (n != 1) return formula;
        }
        Object[] objectArray3 = new Object[]{"Edit Formula", "Cancel"};
        int n = JOptionPane.showOptionDialog(proofWindow.view, "Input Formula : " + formula2.display() + "\nThe Following are not in the signature! What would you like to do? \n\n" + this.newSignature.show(), "Input Required", 0, 3, null, objectArray3, objectArray3[0]);
        if (n == 0) {
            return this.getNewFormula(string3, string2);
        }
        if (n != 2) return formula;
        return formula;
    }
}

