/*
 * Decompiled with CFR 0.152.
 */
package Pandora.NDRules;

import Pandora.Help.ErrorFrame;
import Pandora.Help.ErrorMessages;
import Pandora.Justification;
import Pandora.LogicParser.Formula.False;
import Pandora.LogicParser.Formula.Formula;
import Pandora.LogicParser.Formula.Not;
import Pandora.NDRules.NDRule;
import Pandora.ProofBox;
import Pandora.ProofLine;
import Pandora.ProofWindow;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class NotElim
extends NDRule {
    private ProofLine notLine = null;
    private ProofLine forwardLine = null;

    public NotElim(ProofBox proofBox) {
        super(proofBox);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void addLine(ProofLine proofLine) throws Exception {
        if (this.isForwards) {
            if (this.notLine == null) {
                this.notLine = proofLine;
                return;
            }
            if (this.forwardLine == null) {
                this.forwardLine = proofLine;
                return;
            }
            this.proof.deselectAll();
            throw new Exception("The correct number of lines have already been selected for this method.");
        }
        if (this.notLine == null) {
            this.notLine = proofLine;
            return;
        }
        this.proof.deselectAll();
        throw new Exception("The correct number of lines have already been selected for this method.");
    }

    @Override
    public boolean haveAll() {
        return this.firstLine != null && this.notLine != null && (!this.isForwards || this.isForwards && this.forwardLine != null);
    }

    @Override
    public void check() throws Exception {
        if (this.isForwards) {
            Formula formula;
            Formula formula2 = this.notLine.getFormula();
            if (!NotElim.contradictory(formula2, formula = this.forwardLine.getFormula())) {
                this.proof.deselectAll();
                throw new Exception(ErrorMessages.not);
            }
        } else {
            Formula formula = this.firstLine.getFormula();
            if (!(formula instanceof False)) {
                this.proof.deselectAll();
                throw new Exception(ErrorMessages.not_bottom);
            }
        }
    }

    public static boolean contradictory(Formula formula, Formula formula2) {
        if (formula instanceof Not && !(formula2 instanceof Not)) {
            Formula formula3 = ((Not)formula).getFormula();
            return formula3.display().equals(formula2.display());
        }
        if (formula2 instanceof Not && !(formula instanceof Not)) {
            Formula formula4 = ((Not)formula2).getFormula();
            return formula4.display().equals(formula.display());
        }
        if (formula instanceof Not && formula2 instanceof Not) {
            Formula formula5 = ((Not)formula).getFormula();
            Formula formula6 = ((Not)formula2).getFormula();
            return NotElim.contradictory(formula5, formula6);
        }
        return false;
    }

    @Override
    public void apply() throws Exception {
        if (this.isForwards) {
            this.applyForwards();
        } else {
            this.applyBackwards();
        }
    }

    private void applyBackwards() throws Exception {
        ProofWindow proofWindow = this.proof.getParentWindow();
        Formula formula = this.notLine.getFormula();
        if (formula instanceof Not) {
            Formula formula2 = this.converse(this.notLine.getFormula());
            ProofLine proofLine = new ProofLine(formula2, "<goal>", proofWindow, this.proof);
            int n = this.proof.getIndex(this.firstLine);
            this.proof.addItem(n, proofLine);
            List<ProofLine> list = Collections.synchronizedList(new LinkedList());
            list.add(this.notLine);
            list.add(proofLine);
            Justification justification = new Justification("\u00acE", list);
            ProofLine proofLine2 = this.firstLine;
            proofLine2.setJustification(justification);
            proofWindow.commitSaveState();
        } else {
            this.proof.deselectAll();
            ErrorFrame.launch(ErrorMessages.notElim_backwards, "A goal \u22a5 could be derived from previous goal (Eg X) using \u00acE, \n if \u00acX had already been given or derived. \u00acE backwards \nallows you to select back a previous derived or given formula \n\u00acX and generates X as the new goal.");
        }
    }

    public Formula converse(Formula formula) {
        if (formula instanceof Not) {
            return ((Not)formula).getFormula();
        }
        return new Not(formula);
    }

    private void applyForwards() {
        int n;
        ProofWindow proofWindow = this.proof.getParentWindow();
        List<ProofLine> list = Collections.synchronizedList(new LinkedList());
        int n2 = this.proof.getIndex(this.notLine);
        if (n2 < (n = this.proof.getIndex(this.forwardLine))) {
            list.add(this.notLine);
            list.add(this.forwardLine);
        } else {
            list.add(this.forwardLine);
            list.add(this.notLine);
        }
        Justification justification = new Justification("\u00acE", list);
        ProofLine proofLine = new ProofLine((Formula)new False(), justification, proofWindow, this.proof);
        int n3 = this.proof.getIndex(this.firstLine);
        this.proof.addItem(n3, proofLine);
        proofWindow.commitSaveState();
    }
}

