/*
 * Decompiled with CFR 0.152.
 */
package Pandora.NDRules;

import Pandora.Help.ErrorMessages;
import Pandora.Justification;
import Pandora.LogicParser.Formula.Formula;
import Pandora.LogicParser.Formula.Not;
import Pandora.NDRules.NDRule;
import Pandora.ProofBox;
import Pandora.ProofLine;
import Pandora.ProofWindow;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class NotNot
extends NDRule {
    ProofLine forwardLine = null;

    public NotNot(ProofBox proofBox) {
        super(proofBox);
    }

    @Override
    public void addLine(ProofLine proofLine) throws Exception {
        if (this.isForwards) {
            if (this.forwardLine != null) {
                this.proof.deselectAll();
                throw new Exception("The correct number of lines has already been entered for this rule!");
            }
        } else {
            this.proof.deselectAll();
            throw new Exception("The correct number of lines has already been entered for this rule!");
        }
        this.forwardLine = proofLine;
    }

    @Override
    public boolean haveAll() {
        return this.firstLine != null && (!this.isForwards || this.isForwards && this.forwardLine != null);
    }

    @Override
    public void check() throws Exception {
    }

    @Override
    public void apply() throws Exception {
        if (this.isForwards) {
            try {
                this.applyForwards();
            }
            catch (Exception exception) {
                this.proof.deselectAll();
                throw exception;
            }
        } else {
            this.applyBackwards();
        }
    }

    private void applyForwards() throws Exception {
        Formula formula;
        ProofWindow proofWindow = this.proof.getParentWindow();
        Formula formula2 = this.forwardLine.getFormula();
        if (formula2 instanceof Not) {
            formula = ((Not)formula2).getFormula();
            if (!(formula instanceof Not)) {
                this.proof.deselectAll();
                throw new Exception(ErrorMessages.notnot);
            }
        } else {
            this.proof.deselectAll();
            throw new Exception(ErrorMessages.notnot);
        }
        Formula formula3 = ((Not)formula).getFormula();
        ProofLine proofLine = new ProofLine(formula3, "\u00ac\u00ac", proofWindow, this.proof);
        List<ProofLine> list = Collections.synchronizedList(new LinkedList());
        list.add(this.forwardLine);
        Justification justification = new Justification("\u00ac\u00acE", list);
        proofLine.setJustification(justification);
        int n = this.proof.getIndex(this.firstLine);
        this.proof.addItem(n, proofLine);
        proofWindow.commitSaveState();
    }

    private void applyBackwards() throws Exception {
        ProofWindow proofWindow = this.proof.getParentWindow();
        Formula formula = this.firstLine.getFormula();
        Not not = new Not(new Not(formula));
        ProofLine proofLine = new ProofLine((Formula)not, "<goal>", proofWindow, this.proof);
        int n = this.proof.getIndex(this.firstLine);
        this.proof.addItem(n, proofLine);
        List<ProofLine> list = Collections.synchronizedList(new LinkedList());
        list.add(proofLine);
        Justification justification = new Justification("\u00ac\u00acE", list);
        this.firstLine.setJustification(justification);
        proofWindow.commitSaveState();
    }
}

