/*
 * Decompiled with CFR 0.152.
 */
package Pandora.NDRules;

import Pandora.Help.ErrorMessages;
import Pandora.Help.HelpMessages;
import Pandora.Justification;
import Pandora.LogicParser.Formula.Formula;
import Pandora.LogicParser.Formula.Or;
import Pandora.NDRules.NDRule;
import Pandora.ProofBox;
import Pandora.ProofLine;
import Pandora.ProofWindow;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class OrElim
extends NDRule {
    private ProofLine orLine = null;

    public OrElim(ProofBox proofBox) {
        super(proofBox);
        this.isForwards = false;
    }

    @Override
    public void addLine(ProofLine proofLine) throws Exception {
        if (this.orLine != null) {
            this.proof.deselectAll();
            throw new Exception("The correct number of lines have already been selected for this method.");
        }
        this.orLine = proofLine;
    }

    @Override
    public boolean haveAll() {
        return this.firstLine != null && this.orLine != null;
    }

    @Override
    public void check() throws Exception {
        if (this.haveAll()) {
            Formula formula = this.orLine.getFormula();
            if (!(formula instanceof Or)) {
                this.proof.deselectAll();
                throw new Exception(ErrorMessages.or_selected);
            }
        } else {
            this.proof.deselectAll();
            throw new Exception(" The correct number of line has not been input to apply this rule! ");
        }
    }

    @Override
    public void apply() throws Exception {
        if (this.isForwards) {
            this.applyForwards();
        } else {
            this.applyBackwards();
        }
    }

    private void applyBackwards() {
        ProofWindow proofWindow = this.proof.getParentWindow();
        Formula formula = ((Or)this.orLine.getFormula()).getLeft();
        Formula formula2 = ((Or)this.orLine.getFormula()).getRight();
        ProofBox proofBox = new ProofBox(proofWindow, this.proof);
        ProofLine proofLine = new ProofLine(formula, "ass", proofWindow, proofBox);
        ProofLine proofLine2 = new ProofLine(null, "", proofWindow, proofBox);
        ProofLine proofLine3 = new ProofLine(this.firstLine.getFormula(), "<goal>", proofWindow, proofBox);
        proofBox.addItem(proofLine);
        proofBox.addItem(proofLine2);
        proofBox.addItem(proofLine3);
        ProofBox proofBox2 = proofBox.setNextBox();
        ProofLine proofLine4 = new ProofLine(formula2, "ass", proofWindow, proofBox2);
        ProofLine proofLine5 = new ProofLine(null, "", proofWindow, proofBox2);
        ProofLine proofLine6 = new ProofLine(this.firstLine.getFormula(), "<goal>", proofWindow, proofBox2);
        proofBox2.addItem(proofLine4);
        proofBox2.addItem(proofLine5);
        proofBox2.addItem(proofLine6);
        int n = this.proof.getIndex(this.firstLine);
        this.proof.addItem(n, proofBox);
        List<ProofLine> list = Collections.synchronizedList(new LinkedList());
        list.add(this.orLine);
        list.add(proofLine);
        list.add(proofLine3);
        list.add(proofLine4);
        list.add(proofLine6);
        Justification justification = new Justification("\u2228E", list);
        this.firstLine.setJustification(justification);
        proofWindow.commitSaveState();
    }

    private void applyForwards() {
        Serializable serializable;
        HelpMessages helpMessages = new HelpMessages(this.orLine.getFormula());
        ProofWindow proofWindow = this.proof.getParentWindow();
        Formula formula = null;
        try {
            formula = this.getNewFormula("", helpMessages.or_elimination_forwards);
        }
        catch (Exception exception) {
            this.proof.deselectAll();
            serializable = new Exception("oh noes! something went wrong with getting your input");
        }
        if (formula != null) {
            serializable = ((Or)this.orLine.getFormula()).getLeft();
            Formula formula2 = ((Or)this.orLine.getFormula()).getRight();
            ProofBox proofBox = new ProofBox(proofWindow, this.proof);
            ProofLine proofLine = new ProofLine((Formula)serializable, "ass", proofWindow, proofBox);
            ProofLine proofLine2 = new ProofLine(null, "", proofWindow, proofBox);
            ProofLine proofLine3 = new ProofLine(formula, "<goal>", proofWindow, proofBox);
            proofBox.addItem(proofLine);
            proofBox.addItem(proofLine2);
            proofBox.addItem(proofLine3);
            ProofBox proofBox2 = proofBox.setNextBox();
            ProofLine proofLine4 = new ProofLine(formula2, "ass", proofWindow, proofBox2);
            ProofLine proofLine5 = new ProofLine(null, "", proofWindow, proofBox2);
            ProofLine proofLine6 = new ProofLine(formula, "<goal>", proofWindow, proofBox2);
            proofBox2.addItem(proofLine4);
            proofBox2.addItem(proofLine5);
            proofBox2.addItem(proofLine6);
            List<ProofLine> list = Collections.synchronizedList(new LinkedList());
            list.add(this.orLine);
            list.add(proofLine);
            list.add(proofLine3);
            list.add(proofLine4);
            list.add(proofLine6);
            Justification justification = new Justification("\u2228E", list);
            ProofLine proofLine7 = new ProofLine(formula, "\u2228E", proofWindow, this.proof);
            proofLine7.setJustification(justification);
            int n = this.proof.getIndex(this.firstLine);
            this.proof.addItem(n, proofLine7);
            this.proof.addItem(n, proofBox);
            ProofLine proofLine8 = new ProofLine(null, "", proofWindow, this.proof);
            this.proof.addItem(n, proofLine8);
            proofWindow.commitSaveState();
        }
    }
}

