/*
 * Decompiled with CFR 0.152.
 */
package Pandora.NDRules;

import Pandora.Help.ErrorMessages;
import Pandora.Help.HelpFrame;
import Pandora.Help.HelpMessages;
import Pandora.Justification;
import Pandora.LogicParser.Formula.Formula;
import Pandora.LogicParser.Formula.Or;
import Pandora.NDRules.NDRule;
import Pandora.ProofBox;
import Pandora.ProofLine;
import Pandora.ProofWindow;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;

public class OrIntro
extends NDRule {
    private ProofLine forwardLine = null;

    public OrIntro(ProofBox proofBox) {
        super(proofBox);
    }

    @Override
    public void addLine(ProofLine proofLine) throws Exception {
        if (this.isForwards) {
            if (this.forwardLine != null) {
                this.proof.deselectAll();
                throw new Exception("The correct number of lines have already been selected for this method.");
            }
        } else {
            this.proof.deselectAll();
            throw new Exception("The correct number of lines have already been selected for this method.");
        }
        this.forwardLine = proofLine;
    }

    @Override
    public boolean haveAll() {
        return this.firstLine != null && (!this.isForwards || this.isForwards && this.forwardLine != null);
    }

    @Override
    public void check() throws Exception {
        try {
            if (this.haveAll() && !this.isForwards) {
                this.checkBackwards();
            }
        }
        catch (Exception exception) {
            this.proof.deselectAll();
            throw exception;
        }
    }

    private void checkBackwards() throws Exception {
        ProofLine proofLine = this.firstLine;
        Formula formula = proofLine.getFormula();
        if (!(formula instanceof Or)) {
            this.proof.deselectAll();
            throw new Exception(ErrorMessages.or);
        }
    }

    @Override
    public void apply() throws Exception {
        if (this.isForwards) {
            this.applyForwards();
        } else {
            this.applyBackwards();
        }
    }

    private void applyBackwards() {
        Formula formula = ((Or)this.firstLine.getFormula()).getLeft();
        Formula formula2 = ((Or)this.firstLine.getFormula()).getRight();
        boolean bl = true;
        boolean bl2 = false;
        String string = "\u2228";
        ProofWindow proofWindow = this.proof.getParentWindow();
        Object[] objectArray = new Object[]{"<html><center>Left<br>" + formula.display() + "</center></html>", "<html><center>Right<br>" + formula2.display() + "</center></html>"};
        Object[] objectArray2 = new Object[]{"<html><center>Left<br>" + formula.display() + "</center></html>", "<html><center>Right<br>" + formula2.display() + "</center></html>", "Help"};
        int n = JOptionPane.showOptionDialog(proofWindow.view, "which side of the disjunction should be the new goal?", "Input Required", 1, 3, null, objectArray2, objectArray2[0]);
        if (n == 0) {
            bl = true;
        } else if (n == 1) {
            bl = false;
        } else if (n == 2) {
            HelpFrame.launch("Since you have a disjunction as a goal, you can\nassume that one of the sides is true and therefore\nuse it as your new goal, pressing either left or\nright will display the corresponding formula as\nyour new goal.");
            n = JOptionPane.showOptionDialog(proofWindow.view, "which side of the disjunction should be the new goal?", "Input Required", 0, 3, null, objectArray, objectArray[0]);
            if (n == 0) {
                bl = true;
            } else if (n == 1) {
                bl = false;
            }
        } else {
            bl2 = true;
        }
        if (!bl2) {
            Formula formula3 = this.firstLine.getFormula();
            Formula formula4 = bl ? formula : formula2;
            ProofLine proofLine = new ProofLine(formula4, "<goal>", proofWindow, this.proof);
            int n2 = this.proof.getIndex(this.firstLine);
            this.proof.addItem(n2, proofLine);
            List<ProofLine> list = Collections.synchronizedList(new LinkedList());
            list.add(proofLine);
            Justification justification = new Justification("\u2228I", list);
            this.firstLine.setJustification(justification);
            proofWindow.commitSaveState();
        }
    }

    private void applyForwards() throws Exception {
        boolean bl = true;
        boolean bl2 = false;
        String string = "\u2228";
        String string2 = this.forwardLine.getFormula().display();
        ProofWindow proofWindow = this.proof.getParentWindow();
        Object[] objectArray = new Object[]{"<html>Left<br>" + string2 + " " + string + " ?</html>", "<html>Right<br> ? " + string + " " + string2 + " </html>"};
        Object[] objectArray2 = new Object[]{"<html>Left<br>" + string2 + " " + string + " ?</html>", "<html>Right<br> ? " + string + " " + string2 + " </html>", "Help"};
        int n = JOptionPane.showOptionDialog(proofWindow.view, "On which side of the disjunction should " + string2 + " appear?", "Input Required", 1, 3, null, objectArray2, objectArray2[0]);
        if (n == 0) {
            bl = true;
        } else if (n == 1) {
            bl = false;
        } else if (n == 2) {
            HelpFrame.launch("On which side of the disjunction should the current\ngoal appear?\n__________________________________________\n\nIn effect, you are specifying the formula from which\nyour current goal can be derived by \u2228 introduction.\nThis step is not often used, refer to the heuristics.\n\n");
            n = JOptionPane.showOptionDialog(proofWindow.view, "On which side of the disjunction should " + this.forwardLine.getFormula().display() + " appear?", "Input Required", 0, 3, null, objectArray, objectArray[0]);
            if (n == 0) {
                bl = true;
            } else if (n == 1) {
                bl = false;
            }
        } else {
            bl2 = true;
        }
        if (!bl2) {
            HelpMessages helpMessages = new HelpMessages(this.forwardLine.getFormula());
            if (bl) {
                Formula formula = this.getNewFormula("", helpMessages.or_introduction_forwards_input_left);
                if (formula != null) {
                    this.actualApplyForwards(formula, bl);
                }
            } else {
                Formula formula = this.getNewFormula("", helpMessages.or_introduction_forwards_input_right);
                if (formula != null) {
                    this.actualApplyForwards(formula, bl);
                }
            }
        }
    }

    private void actualApplyForwards(Formula formula, boolean bl) {
        ProofWindow proofWindow = this.proof.getParentWindow();
        Formula formula2 = this.forwardLine.getFormula();
        Or or = bl ? new Or(formula2, formula) : new Or(formula, formula2);
        ProofLine proofLine = new ProofLine((Formula)or, "\u2228I", proofWindow, this.proof);
        int n = this.proof.getIndex(this.firstLine);
        this.proof.addItem(n, proofLine);
        List<ProofLine> list = Collections.synchronizedList(new LinkedList());
        list.add(this.forwardLine);
        Justification justification = new Justification("\u2228I", list);
        proofLine.setJustification(justification);
        proofWindow.commitSaveState();
    }
}

