/*
 * Decompiled with CFR 0.152.
 */
package Pandora.NDRules;

import Pandora.Justification;
import Pandora.LogicParser.Formula.Atom;
import Pandora.LogicParser.Formula.Equals;
import Pandora.LogicParser.Formula.Formula;
import Pandora.LogicParser.Formula.Function;
import Pandora.LogicParser.Formula.Predicate;
import Pandora.LogicParser.Formula.SimpleTerm;
import Pandora.LogicParser.Formula.Term;
import Pandora.LogicParser.ParseController;
import Pandora.NDRules.NDRule;
import Pandora.PanSignature;
import Pandora.ProofBox;
import Pandora.ProofLine;
import Pandora.ProofWindow;
import java.util.Vector;
import javax.swing.JOptionPane;

public class Reflexivity
extends NDRule {
    String check = "";

    public Reflexivity(ProofBox proofBox) {
        super(proofBox);
    }

    @Override
    public void addLine(ProofLine proofLine) throws Exception {
        this.proof.deselectAll();
        throw new Exception("The correct number of lines have already been selected for this method.");
    }

    @Override
    public boolean haveAll() {
        return this.firstLine != null;
    }

    @Override
    public void check() throws Exception {
        if (this.haveAll() && !this.isForwards) {
            Formula formula = this.firstLine.getFormula();
            if (!(formula instanceof Equals)) {
                this.proof.deselectAll();
                throw new Exception("An Equality goal formula of the form x=x for some x must be selected to apply the reflex rule backwards.");
            }
            Equals equals = (Equals)formula;
            if (!this.identical(equals)) {
                this.proof.deselectAll();
                throw new Exception("The two sides of the goal equality must be identical to apply the reflex rule backwards!");
            }
        }
    }

    private boolean identical(Equals equals) {
        return equals.getLeftTerm().equals(equals.getRightTerm());
    }

    @Override
    public void apply() throws Exception {
        if (this.isForwards) {
            this.applyForwards();
        } else {
            this.applyBackwards();
        }
    }

    private void applyForwards() throws Exception {
        Object object;
        Cloneable cloneable;
        ProofWindow proofWindow = this.proof.getParentWindow();
        Term term = null;
        try {
            cloneable = this.proof.getSignature();
            object = "";
            object = ((PanSignature)cloneable).getConstants().isEmpty() ? "Input the term you would like to apply reflexivity to\n_____________________________________________________\n\nHint: Provided a constant exists in your signature,\napplying reflexivity to it will produce a new goal\nline of the form a = a or with function symbols such\nas P(a) = P(a)\n\nIt appears that you do not have a constant in your\nsignature, to add a constant click on the Options\nmenu > add to signature > constants\n\nAt the top of the rules pane a text field will appear\nin which you can add a constant of your choice\n\n" : "Input the term you would like to apply reflexivity to\n_____________________________________________________\n\nHint: Provided a constant exists in your signature,\napplying reflexivity to it will produce a new goal\nline of the form a = a or with function symbols such\nas P(a) = P(a)\n\n";
            term = this.getNewTerm("", (String)object);
        }
        catch (Exception exception) {
            this.proof.deselectAll();
            throw exception;
        }
        if (term != null) {
            cloneable = new Vector();
            ((Vector)cloneable).add(term);
            ((Vector)cloneable).add(term);
            object = new Equals((Vector<Term>)cloneable);
            ProofLine proofLine = new ProofLine((Formula)object, "Reflexivity", proofWindow, this.proof);
            int n = this.proof.getIndex(this.firstLine);
            this.proof.addItem(n, proofLine);
            proofWindow.commitSaveState();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Term getNewTerm(String string, String string2) throws Exception {
        ProofWindow proofWindow = this.proof.getParentWindow();
        PanSignature panSignature = this.proof.getSignature();
        Term term = null;
        boolean bl = false;
        String string3 = null;
        Object[] objectArray = null;
        String string4 = (String)JOptionPane.showInputDialog(proofWindow.view, string2, "Input Required", 3, null, objectArray, string);
        if (string4 == null) {
            bl = true;
        } else {
            string3 = string4;
        }
        if (bl) return term;
        ParseController parseController = new ParseController(string3);
        Formula formula = parseController.parseLine();
        if (formula == null) {
            this.proof.deselectAll();
            throw new Exception("Term not valid: Couldn't repair and continue parse");
        }
        Term term2 = this.toTerm(formula);
        if (term2 != null) {
            boolean bl2 = this.checkSignature(term2);
            if (bl2) return term2;
            if (this.check.contains(this.error)) {
                Object[] objectArray2 = new Object[]{"Edit Term", "Cancel"};
                int n = JOptionPane.showOptionDialog(proofWindow.view, "Input Term : " + term2.display() + "\n" + this.check + "\nWhat would you like to do? \n\n", "Error", 0, 3, null, objectArray2, objectArray2[0]);
                if (n == 0) {
                    try {
                        return this.getNewTerm(string3, string2);
                    }
                    catch (Exception exception) {
                        this.proof.deselectAll();
                        throw exception;
                    }
                }
                if (n != 1) return term;
            }
            Object[] objectArray3 = new Object[]{"Edit Formula", "Cancel"};
            int n = JOptionPane.showOptionDialog(proofWindow.view, "Input Formula : " + formula.display() + "\nThe Following are not in the signature! What would you like to do? \n\n" + this.newSignature.show(), "Input Required", 0, 3, null, objectArray3, objectArray3[0]);
            if (n == 0) {
                try {
                    return this.getNewTerm(string3, string2);
                }
                catch (Exception exception) {
                    this.proof.deselectAll();
                    throw exception;
                }
            }
            if (n != 1) return term;
        }
        this.proof.deselectAll();
        throw new Exception("Term not valid: Couldn't repair and continue parse");
        return term;
    }

    private Term toTerm(Formula formula) {
        if (formula instanceof Predicate && !(formula instanceof Equals)) {
            Predicate predicate = (Predicate)formula;
            return new Function(predicate.getName(), predicate.getParams());
        }
        if (formula instanceof Atom && formula.getAtoms().size() == 1) {
            Atom atom = (Atom)formula;
            return new SimpleTerm(atom.getName());
        }
        return null;
    }

    public boolean checkSignature(Term term) {
        boolean bl = true;
        PanSignature panSignature = this.proof.getSignature();
        PanSignature panSignature2 = panSignature.clone();
        this.check = term.clashes(panSignature2);
        if (this.check.contains(this.error)) {
            return false;
        }
        this.newSignature = panSignature.compare(panSignature2);
        return bl && this.newSignature.isEmpty();
    }

    private void applyBackwards() {
        ProofWindow proofWindow = this.proof.getParentWindow();
        Justification justification = new Justification("Reflexivity", null);
        this.firstLine.setJustification(justification);
        proofWindow.commitSaveState();
    }
}

