/*
 * Decompiled with CFR 0.152.
 */
package Pandora.NDRules;

import Pandora.Help.ErrorFrame;
import Pandora.Help.ErrorMessages;
import Pandora.Justification;
import Pandora.LogicParser.Formula.And;
import Pandora.LogicParser.Formula.Atom;
import Pandora.LogicParser.Formula.Equals;
import Pandora.LogicParser.Formula.Forall;
import Pandora.LogicParser.Formula.Formula;
import Pandora.LogicParser.Formula.Function;
import Pandora.LogicParser.Formula.Iff;
import Pandora.LogicParser.Formula.Implies;
import Pandora.LogicParser.Formula.Not;
import Pandora.LogicParser.Formula.Or;
import Pandora.LogicParser.Formula.Predicate;
import Pandora.LogicParser.Formula.Term;
import Pandora.LogicParser.ParseController;
import Pandora.NDRules.NDRule;
import Pandora.NDRules.Pair;
import Pandora.ProofBox;
import Pandora.ProofLine;
import Pandora.ProofWindow;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;

public class Substitution
extends NDRule {
    private ProofLine equLine;
    private ProofLine forwardLine;
    LinkedList<Pair> matches = new LinkedList();
    private boolean replaceAll = false;

    public Substitution(ProofBox proofBox) {
        super(proofBox);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void addLine(ProofLine proofLine) throws Exception {
        if (this.isForwards) {
            if (this.equLine == null) {
                this.equLine = proofLine;
                return;
            } else {
                if (this.forwardLine != null) throw new Exception("The correct number of lines have already been selected for this method.");
                this.forwardLine = proofLine;
            }
            return;
        } else {
            if (this.equLine != null) throw new Exception("The correct number of lines have already been selected for this method.");
            this.equLine = proofLine;
        }
    }

    @Override
    public boolean haveAll() {
        return this.firstLine != null && this.equLine != null && (!this.isForwards || this.isForwards && this.forwardLine != null);
    }

    @Override
    public void check() throws Exception {
        if (this.haveAll()) {
            this.correctLines();
            if (this.isForwards) {
                Formula formula = this.equLine.getFormula();
                if (!(formula instanceof Equals)) {
                    System.out.println("Not equals in check()");
                    System.out.println(formula);
                    ErrorFrame.launch(ErrorMessages.subs_forwards, "For equality susbstition forwards two equations need to be selected.\nThe first of the equations needs to be an equality, say s1=s2. When\nsubstituting the first equation into the second you will be given an\noption to replace all occurences of s1 in the second equation by s2 \nor vice versa and you will also be given an option to replace only the\nyou require to be replaced.");
                }
            } else {
                Formula formula = this.equLine.getFormula();
                if (!(formula instanceof Equals)) {
                    ErrorFrame.launch(ErrorMessages.subs_backwards, "For equality substitution backwards the goalline needs to be selected \nfirst then the equality say s1=s2, which is used to substitute the either\nthe occurences of s1 in the goal by s2 or vice versa. There will also be \nan option to replace all or enter the formula that must be the new goal,\nif there are multiple occurences of s1 or s2 in the goal.");
                }
            }
        }
    }

    @Override
    public void apply() throws Exception {
        if (this.isForwards) {
            this.applyForwards();
        } else {
            this.applyBackwards();
        }
    }

    public void findMatch(Formula formula, Equals equals, ProofLine proofLine) {
        if (formula instanceof Equals) {
            System.out.println(formula);
            this.findMatch(((Equals)formula).getLeftTerm(), equals, proofLine);
            this.findMatch(((Equals)formula).getRightTerm(), equals, proofLine);
        } else if (formula instanceof And) {
            this.findMatch(((And)formula).getLeft(), equals, proofLine);
            this.findMatch(((And)formula).getRight(), equals, proofLine);
        } else if (formula instanceof Predicate) {
            System.out.println("Predicate");
            System.out.println(formula);
            Iterator<Term> iterator = ((Predicate)formula).getTerms().iterator();
            while (iterator.hasNext()) {
                this.findMatch(iterator.next(), equals, proofLine);
            }
        } else if (formula instanceof Or) {
            this.findMatch(((Or)formula).getLeft(), equals, proofLine);
            this.findMatch(((Or)formula).getRight(), equals, proofLine);
        } else if (formula instanceof Implies) {
            this.findMatch(((Implies)formula).getLeft(), equals, proofLine);
            this.findMatch(((Implies)formula).getRight(), equals, proofLine);
        } else if (formula instanceof Iff) {
            this.findMatch(((Iff)formula).getLeft(), equals, proofLine);
            this.findMatch(((Iff)formula).getRight(), equals, proofLine);
        } else if (formula instanceof Not) {
            this.findMatch(((Not)formula).getFormula(), equals, proofLine);
        } else {
            System.out.println("else case");
        }
    }

    public void findMatch(Term term, Equals equals, ProofLine proofLine) {
        Object object;
        Term term2 = equals.getLeftTerm();
        Term term3 = equals.getRightTerm();
        if (term.equals(term2)) {
            object = new Pair(term, term3, proofLine, 1);
            if (!((Pair)object).isIn(this.matches)) {
                this.matches.add((Pair)object);
            }
        } else if (term.equals(term3) && !((Pair)(object = new Pair(term, term2, proofLine, 1))).isIn(this.matches)) {
            this.matches.add((Pair)object);
        }
        if (term instanceof Function) {
            for (Term term4 : ((Function)term).getParams()) {
                this.findMatch(term4, equals, proofLine);
            }
        }
    }

    public void findAll(ProofLine proofLine, ProofLine proofLine2) throws Exception {
        Serializable serializable;
        Iterator<Term> iterator;
        Object object2;
        Formula formula = proofLine2.getFormula();
        Equals equals = (Equals)proofLine.getFormula();
        if (formula instanceof Equals) {
            this.findMatch(((Equals)formula).getLeftTerm(), equals, proofLine2);
            this.findMatch(((Equals)formula).getRightTerm(), equals, proofLine2);
        } else if (formula instanceof Forall) {
            this.findMatch(((Forall)formula).getFormula(), equals, proofLine2);
        } else if (formula instanceof Predicate) {
            object2 = (Predicate)formula;
            iterator = ((Predicate)object2).getParams();
            Iterator<Term> object3 = ((Vector)((Object)iterator)).iterator();
            while (object3.hasNext()) {
                serializable = object3.next();
                this.findMatch((Term)serializable, equals, proofLine2);
            }
            System.out.println("Predicate");
        } else if (formula instanceof Formula) {
            this.findMatch(formula.getLeft(), equals, proofLine2);
            System.out.println("findall - after get left");
            System.out.println(formula.display());
            this.findMatch(formula.getRight(), equals, proofLine2);
            System.out.println("findall - after get right");
        } else {
            System.out.println("findall 4");
            object2 = formula.getAtoms();
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                Atom atom = (Atom)iterator.next();
                if (!(atom instanceof Predicate)) continue;
                serializable = (Predicate)atom;
                for (Term term : ((Predicate)serializable).getParams()) {
                    this.findMatch(term, equals, proofLine2);
                }
            }
        }
        if (this.isForwards && formula instanceof Equals) {
            object2 = (Equals)formula;
            for (Term term : equals.getParams()) {
                this.findMatch(term, (Equals)object2, proofLine);
            }
        }
        this.showMatch();
    }

    public void showMatch() {
        Iterator iterator = this.matches.iterator();
        System.out.println("Matches : " + this.matches.size());
        while (iterator.hasNext()) {
            Pair pair = (Pair)iterator.next();
            System.out.println(pair.display());
        }
    }

    private void applyForwards() throws Exception {
        ProofWindow proofWindow = this.proof.getParentWindow();
        this.findAll(this.equLine, this.forwardLine);
        System.out.println("apply forwards 1");
        this.showMatch();
        Formula formula = this.options(true);
        if (formula != null) {
            ProofLine proofLine = new ProofLine(formula, "<goal>", proofWindow, this.proof);
            List<ProofLine> list = Collections.synchronizedList(new LinkedList());
            if (this.proof.getIndex(this.forwardLine) > this.proof.getIndex(this.equLine)) {
                list.add(this.equLine);
                list.add(this.forwardLine);
            } else {
                list.add(this.forwardLine);
                list.add(this.equLine);
            }
            Justification justification = new Justification("=Sub", list);
            proofLine.setJustification(justification);
            int n = this.proof.getIndex(this.firstLine);
            this.proof.addItem(n, proofLine);
            proofWindow.commitSaveState();
        }
    }

    private void correctLines() throws Exception {
        Formula formula = this.equLine.getFormula();
        if (this.isForwards) {
            Formula formula2 = this.forwardLine.getFormula();
            if (!(formula instanceof Equals) && formula2 instanceof Equals) {
                ProofLine proofLine = this.equLine;
                this.equLine = this.forwardLine;
                this.forwardLine = proofLine;
            }
        }
    }

    private void applyBackwards() throws Exception {
        ProofWindow proofWindow = this.proof.getParentWindow();
        Equals equals = (Equals)this.equLine.getFormula();
        this.findAll(this.equLine, this.firstLine);
        this.showMatch();
        Formula formula = this.options(false);
        if (formula != null) {
            ProofLine proofLine = new ProofLine(formula, "<goal>", proofWindow, this.proof);
            int n = this.proof.getIndex(this.firstLine);
            this.proof.addItem(n, proofLine);
            List<ProofLine> list = Collections.synchronizedList(new LinkedList());
            list.add(this.equLine);
            list.add(proofLine);
            Justification justification = new Justification("=Sub", list);
            this.firstLine.setJustification(justification);
            proofWindow.commitSaveState();
        }
    }

    private Formula options(Boolean bl) throws Exception {
        ProofWindow proofWindow = this.proof.getParentWindow();
        Formula formula = null;
        int n = this.matches.size();
        Pair pair = null;
        try {
            Object[] objectArray;
            if (n == 1) {
                pair = this.matches.get(0);
            } else {
                objectArray = new String[n];
                for (Pair pair2 : this.matches) {
                    objectArray[this.matches.indexOf((Object)pair2)] = "<html>Replace occurrences of " + pair2.getFirst().display() + "<br> with occurrences of " + pair2.getSecond().display() + " <br>in the formula <br>" + pair2.getLine().getFormula().display() + "</html>";
                }
                int n2 = JOptionPane.showOptionDialog(proofWindow.view, "Please select from the following possible substitutions:", "Input Required", 0, 3, null, objectArray, objectArray[0]);
                if (n2 != -1) {
                    pair = this.matches.get(n2);
                }
            }
            if (pair != null) {
                objectArray = this.getInput("", pair);
                Formula formula2 = pair.getLine().getFormula();
                if (this.replaceAll || objectArray != null) {
                    formula = formula2.sub(pair.getFirst(), pair.getSecond(), (Formula)objectArray);
                    System.out.println("substitued : " + formula.display());
                }
            }
            return formula;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new Exception("The line you chose to perform the substitution on does not contain " + ((Equals)this.equLine.getFormula()).getLeftTerm().display() + " OR " + ((Equals)this.equLine.getFormula()).getRightTerm().display());
        }
    }

    private Formula getInput(String string, Pair pair) throws Exception {
        int n = pair.getOccurrences();
        Formula formula = null;
        ProofWindow proofWindow = this.proof.getParentWindow();
        if (n > 1) {
            String string2 = (String)JOptionPane.showInputDialog(proofWindow.view, "\nChosen Option: Replace the Occurrences of " + pair.getFirst().display() + " with the occurrences of " + pair.getSecond().display() + " in the formula " + pair.getLine().getFormula().display() + "\nPress Ok to replace all the occurrences\n(Optionally) Please Enter the outcome formula you wish the substitution to give: ", "Input required", 3, null, null, string);
            if (string2 != null) {
                if (string2.equals("")) {
                    this.replaceAll = true;
                } else {
                    ParseController parseController = new ParseController(string2);
                    formula = parseController.parseLine();
                    if (formula == null) {
                        throw new Exception("The formula you entered could not be parsed!");
                    }
                }
            }
        } else {
            Object[] objectArray = new String[]{"OK", "Cancel"};
            int n2 = JOptionPane.showOptionDialog(proofWindow.view, "\nChosen Option: Replace the only occurrence of " + pair.getFirst().display() + " with " + pair.getSecond().display() + " in the formula " + pair.getLine().getFormula().display() + "\nPress Ok to proceed", "Confirm", 0, 3, null, objectArray, objectArray[0]);
            if (n2 == 0) {
                this.replaceAll = true;
            }
        }
        return formula;
    }
}

