/*
 * Decompiled with CFR 0.152.
 */
package Pandora.NDRules;

import Pandora.Justification;
import Pandora.LogicParser.Formula.Formula;
import Pandora.LogicParser.Formula.Unknown;
import Pandora.NDRules.NDRule;
import Pandora.ProofBox;
import Pandora.ProofItem;
import Pandora.ProofLine;
import Pandora.ProofWindow;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Tick
extends NDRule {
    private ProofLine secondLine = null;
    private boolean unknown1st = false;
    private boolean unknown2nd;

    public Tick(ProofBox proofBox) {
        super(proofBox);
    }

    @Override
    public void addLine(ProofLine proofLine) throws Exception {
        if (this.isForwards && proofLine.getFormula() instanceof Unknown) {
            this.proof.deselectAll();
            throw new Exception("An unknown formula cannont be used in the tick rule forwards, it must have been unified first.");
        }
        if (this.secondLine == null) {
            this.secondLine = proofLine;
            this.unknown2nd = this.secondLine.getFormula() instanceof Unknown;
        } else {
            this.proof.deselectAll();
            throw new Exception("The correct number of lines have already been selected for this method.");
        }
    }

    @Override
    public boolean haveAll() {
        return this.firstLine != null && this.secondLine != null;
    }

    @Override
    public void check() throws Exception {
        if (!this.isForwards && !this.unknown2nd) {
            if (this.firstLine.getFormula() instanceof Unknown) {
                this.unknown1st = true;
            } else {
                Formula formula = this.firstLine.getFormula();
                Formula formula2 = this.secondLine.getFormula();
                if (!formula.display().equals(formula2.display())) {
                    this.proof.deselectAll();
                    throw new Exception("The two lines selected for Tick rule backwards must have the same formula, or be an unknown to be unified.");
                }
            }
        }
    }

    @Override
    public void apply() throws Exception {
        if (this.isForwards) {
            this.applyForwards();
        } else {
            this.applyBackwards();
        }
    }

    private void applyForwards() {
        ProofWindow proofWindow = this.proof.getParentWindow();
        Formula formula = this.secondLine.getFormula();
        ProofLine proofLine = new ProofLine(formula, proofWindow, this.proof);
        List<ProofLine> list = Collections.synchronizedList(new LinkedList());
        list.add(this.secondLine);
        Justification justification = new Justification("\u221a", list);
        proofLine.setJustification(justification);
        int n = this.proof.getIndex(this.firstLine);
        this.proof.addItem(n, proofLine);
        proofWindow.commitSaveState();
    }

    private void applyBackwards() {
        ProofWindow proofWindow = this.proof.getParentWindow();
        if (this.unknown2nd) {
            if (this.unknown1st) {
                Formula formula = this.firstLine.getFormula();
                Formula formula2 = this.secondLine.getFormula();
                String string = formula2.display();
                ProofBox proofBox = proofWindow.mainProofBox;
                this.unify(string, formula, proofBox);
                List<ProofLine> list = Collections.synchronizedList(new LinkedList());
                list.add(this.secondLine);
                Justification justification = new Justification("\u221a", list);
                List<ProofItem> list2 = this.proof.getProofItems();
                if (list2.contains(this.secondLine)) {
                    int n;
                    int n2 = this.proof.getIndex(this.firstLine);
                    if (n2 - (n = this.proof.getIndex(this.secondLine)) == 2) {
                        Justification justification2 = this.secondLine.getJustification();
                        this.firstLine.setJustification(justification2);
                        this.replaceLines(this.secondLine, this.firstLine, proofBox);
                        int n3 = this.proof.getIndex(this.secondLine);
                        this.proof.removeItem(n3);
                    } else {
                        this.firstLine.setJustification(justification);
                    }
                } else {
                    this.firstLine.setJustification(justification);
                }
            } else {
                Formula formula = this.firstLine.getFormula();
                Formula formula3 = this.secondLine.getFormula();
                String string = formula3.display();
                ProofBox proofBox = proofWindow.mainProofBox;
                this.unify(string, formula, proofBox);
                List<ProofLine> list = Collections.synchronizedList(new LinkedList());
                list.add(this.secondLine);
                Justification justification = new Justification("\u221a", list);
                List<ProofItem> list3 = this.proof.getProofItems();
                if (list3.contains(this.secondLine)) {
                    int n;
                    int n4 = this.proof.getIndex(this.firstLine);
                    if (n4 - (n = this.proof.getIndex(this.secondLine)) == 2) {
                        this.replaceLines(this.secondLine, this.firstLine, proofBox);
                        Justification justification3 = this.secondLine.getJustification();
                        this.firstLine.setJustification(justification3);
                        int n5 = this.proof.getIndex(this.secondLine);
                        this.proof.removeItem(n5);
                    } else {
                        this.firstLine.setJustification(justification);
                    }
                } else {
                    this.firstLine.setJustification(justification);
                }
            }
        } else if (this.unknown1st) {
            Formula formula = this.secondLine.getFormula();
            Formula formula4 = this.firstLine.getFormula();
            String string = formula4.display();
            ProofBox proofBox = proofWindow.mainProofBox;
            this.unify(string, formula, proofBox);
            List<ProofLine> list = Collections.synchronizedList(new LinkedList());
            list.add(this.secondLine);
            Justification justification = new Justification("\u221a", list);
            List<ProofItem> list4 = this.proof.getProofItems();
            if (list4.contains(this.secondLine)) {
                int n;
                int n6 = this.proof.getIndex(this.firstLine);
                if (n6 - (n = this.proof.getIndex(this.secondLine)) == 2) {
                    this.replaceLines(this.secondLine, this.firstLine, proofBox);
                    Justification justification4 = this.secondLine.getJustification();
                    this.firstLine.setJustification(justification4);
                    int n7 = this.proof.getIndex(this.secondLine);
                    this.proof.removeItem(n7);
                } else {
                    this.firstLine.setJustification(justification);
                }
            } else {
                this.firstLine.setJustification(justification);
            }
        } else {
            List<ProofLine> list = Collections.synchronizedList(new LinkedList());
            list.add(this.secondLine);
            Justification justification = new Justification("\u221a", list);
            List<ProofItem> list5 = this.proof.getProofItems();
            if (list5.contains(this.secondLine)) {
                int n;
                int n8 = this.proof.getIndex(this.firstLine);
                if (n8 - (n = this.proof.getIndex(this.secondLine)) == 2) {
                    if (!this.secondLine.getJustification().getSymbol().equals("given") && !this.secondLine.getJustification().getSymbol().equals("ass")) {
                        Justification justification5 = this.secondLine.getJustification();
                        this.firstLine.setJustification(justification5);
                        ProofBox proofBox = proofWindow.mainProofBox;
                        this.replaceLines(this.secondLine, this.firstLine, proofBox);
                        int n9 = this.proof.getIndex(this.secondLine);
                        this.proof.removeItem(n9);
                    } else {
                        this.firstLine.setJustification(justification);
                    }
                } else {
                    this.firstLine.setJustification(justification);
                }
            } else {
                this.firstLine.setJustification(justification);
            }
        }
        proofWindow.commitSaveState();
    }

    private void replaceLines(ProofLine proofLine, ProofLine proofLine2, ProofBox proofBox) {
        Object object;
        int n = proofLine.getLineNum();
        if (proofBox.hasNextBox()) {
            object = proofBox.getNextBox();
            this.replaceLines(proofLine, proofLine2, (ProofBox)object);
        }
        object = proofBox.getProofItems().listIterator(0);
        while (object.hasNext()) {
            ProofItem proofItem;
            ProofItem proofItem2 = (ProofItem)object.next();
            if (proofItem2 instanceof ProofLine) {
                Object object2;
                Object object3;
                proofItem = (ProofLine)proofItem2;
                List<ProofLine> list = ((ProofLine)proofItem).getJustification().getLines();
                if (list != null) {
                    object3 = list.listIterator(0);
                    while (object3.hasNext()) {
                        object2 = (ProofLine)object3.next();
                        if (((ProofLine)object2).getLineNum() != n) continue;
                        int n2 = list.indexOf(proofLine);
                        list.set(n2, proofLine2);
                        ((ProofLine)proofItem).getJustification().setLines(list);
                    }
                }
                if ((object3 = ((ProofLine)proofItem).getJustification().getExtraLines()) == null) continue;
                object2 = object3.listIterator(0);
                while (object2.hasNext()) {
                    ProofLine proofLine3 = (ProofLine)object2.next();
                    if (proofLine3.getLineNum() != n) continue;
                    int n3 = object3.indexOf(proofLine);
                    object3.set(n3, proofLine2);
                    ((ProofLine)proofItem).getJustification().setExtraLines((List<ProofLine>)object3);
                }
                continue;
            }
            if (!(proofItem2 instanceof ProofBox)) continue;
            proofItem = (ProofBox)proofItem2;
            this.replaceLines(proofLine, proofLine2, (ProofBox)proofItem);
        }
    }

    private void unify(String string, Formula formula, ProofBox proofBox) {
        Object object;
        if (proofBox.hasNextBox()) {
            object = proofBox.getNextBox();
            this.unify(string, formula, (ProofBox)object);
        }
        object = proofBox.getProofItems().listIterator(0);
        while (object.hasNext()) {
            ProofItem proofItem;
            ProofItem proofItem2 = (ProofItem)object.next();
            if (proofItem2 instanceof ProofLine) {
                proofItem = (ProofLine)proofItem2;
                if (((ProofLine)proofItem).getJustification().getSymbol().equals("")) continue;
                if (((ProofLine)proofItem).getFormula().display().equals(string)) {
                    ((ProofLine)proofItem).setFormula(formula);
                    continue;
                }
                this.checkFormula(string, formula, ((ProofLine)proofItem).getFormula());
                continue;
            }
            if (!(proofItem2 instanceof ProofBox)) continue;
            proofItem = (ProofBox)proofItem2;
            this.unify(string, formula, (ProofBox)proofItem);
        }
    }

    private void checkFormula(String string, Formula formula, Formula formula2) {
        try {
            Formula formula3 = formula2.getLeft();
            if (formula3.display().equals(string)) {
                formula2.setLeft(formula);
            } else {
                this.checkFormula(string, formula, formula3);
            }
            Formula formula4 = formula2.getRight();
            if (formula4.display().equals(string)) {
                formula2.setRight(formula);
            } else {
                this.checkFormula(string, formula, formula4);
            }
        }
        catch (Exception exception) {
            this.proof.deselectAll();
        }
    }
}

