/*
 * Decompiled with CFR 0.152.
 */
package Pandora;

import Pandora.LogicParser.Formula.Atom;
import Pandora.LogicParser.Formula.Function;
import Pandora.LogicParser.Formula.Predicate;
import Pandora.LogicParser.Formula.SVar;
import Pandora.LogicParser.Formula.SimpleTerm;
import Pandora.LogicParser.Formula.Term;
import Pandora.LogicParser.Formula.Var;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class PanSignature
implements Cloneable,
Serializable {
    private List<Atom> predicates;
    private List<SimpleTerm> constants;
    private List<Function> functions;
    private List<Var> variables;
    private List<SVar> svars;
    private List<SimpleTerm> skolems;

    public PanSignature(List<Atom> list, List<SimpleTerm> list2, List<Function> list3, List<Var> list4, List<SimpleTerm> list5) {
        this.predicates = list;
        this.constants = list2;
        this.functions = list3;
        this.variables = list4;
        this.skolems = list5;
    }

    public PanSignature() {
        this.predicates = Collections.synchronizedList(new LinkedList());
        this.constants = Collections.synchronizedList(new LinkedList());
        this.functions = Collections.synchronizedList(new LinkedList());
        this.variables = Collections.synchronizedList(new LinkedList());
        this.skolems = Collections.synchronizedList(new LinkedList());
    }

    public List<Atom> getPredicates() {
        return this.predicates;
    }

    public List<SimpleTerm> getConstants() {
        return this.constants;
    }

    public List<Function> getFunctions() {
        return this.functions;
    }

    public List<Var> getVariables() {
        return this.variables;
    }

    public List<SimpleTerm> getSkolems() {
        return this.skolems;
    }

    public List<SVar> getSVars() {
        return this.svars;
    }

    public void setSignature(PanSignature panSignature) {
        this.predicates = panSignature.getPredicates();
        this.constants = panSignature.getConstants();
        this.functions = panSignature.getFunctions();
        this.variables = panSignature.getVariables();
        this.skolems = panSignature.getSkolems();
    }

    public void addToSignature(PanSignature panSignature) {
        List<Atom> list = panSignature.getPredicates();
        List<SimpleTerm> list2 = panSignature.getConstants();
        List<Function> list3 = panSignature.getFunctions();
        List<Var> list4 = panSignature.getVariables();
        List<SimpleTerm> list5 = panSignature.getSkolems();
        this.addToSignature(list);
        this.addConstsToSignature(list2);
        this.addFuncsToSignature(list3);
        this.addVarsToSignature(list4);
        this.addConstsToSignature(list5);
    }

    public void addToSignature(List<Atom> list) {
        for (Atom atom : list) {
            if (!atom.isIn(this)) {
                this.predicates.add(atom);
            }
            if (!(atom instanceof Predicate)) continue;
            Vector<Term> vector = ((Predicate)atom).getParams();
            this.addTermsToSignature(vector);
        }
    }

    public void addConstsToSignature(List<SimpleTerm> list) {
        for (SimpleTerm simpleTerm : list) {
            if (simpleTerm.isIn(this)) continue;
            this.constants.add(simpleTerm);
        }
    }

    public void addVarToSignature(Var var) {
        if (!var.isIn(this)) {
            this.variables.add(var);
        }
    }

    public void addVarsToSignature(List<Var> list) {
        for (Var var : list) {
            if (var.isIn(this)) continue;
            this.variables.add(var);
        }
    }

    public void addFuncsToSignature(List<Function> list) {
        for (Function function : list) {
            if (!function.isIn(this)) {
                this.functions.add(function);
            }
            Vector<Term> vector = function.getParams();
            this.addTermsToSignature(vector);
        }
    }

    public void addTermsToSignature(List<Term> list) {
        for (Term term : list) {
            Term term2;
            if (term instanceof SimpleTerm) {
                term2 = (SimpleTerm)term;
                if (((SimpleTerm)term2).isIn(this)) continue;
                this.constants.add((SimpleTerm)term2);
                continue;
            }
            term2 = (Function)term;
            if (!((Function)term2).isIn(this)) {
                this.functions.add((Function)term2);
            }
            Vector<Term> vector = ((Function)term2).getParams();
            this.addTermsToSignature(vector);
        }
    }

    public PanSignature clone() {
        List<Atom> list = Collections.synchronizedList(new LinkedList());
        for (Atom object42 : this.predicates) {
            list.add(object42);
        }
        List<SimpleTerm> list2 = Collections.synchronizedList(new LinkedList());
        for (SimpleTerm simpleTerm : this.constants) {
            list2.add(simpleTerm);
        }
        List<Function> list3 = Collections.synchronizedList(new LinkedList());
        for (Function function : this.functions) {
            list3.add(function);
        }
        List<Var> list4 = Collections.synchronizedList(new LinkedList());
        for (Var var : this.variables) {
            list4.add(var);
        }
        List<SimpleTerm> list5 = Collections.synchronizedList(new LinkedList());
        for (SimpleTerm simpleTerm : this.skolems) {
            list5.add(simpleTerm);
        }
        return new PanSignature(list, list2, list3, list4, list5);
    }

    public String show() {
        Serializable serializable;
        String string = "";
        Iterator<Serializable> iterator = this.predicates.iterator();
        if (iterator.hasNext()) {
            string = string + "Predicates : \n";
        }
        while (iterator.hasNext()) {
            serializable = iterator.next();
            string = string + ((Atom)serializable).getName() + "/" + ((Atom)serializable).getArity() + "\n";
        }
        iterator = this.constants.iterator();
        if (iterator.hasNext()) {
            string = string + "Constants : \n";
        }
        while (iterator.hasNext()) {
            serializable = (SimpleTerm)iterator.next();
            string = string + ((SimpleTerm)serializable).display() + "\n";
        }
        iterator = this.functions.iterator();
        if (iterator.hasNext()) {
            string = string + "Functions : \n";
        }
        while (iterator.hasNext()) {
            serializable = (Function)iterator.next();
            string = string + ((Function)serializable).getName() + "/" + ((Function)serializable).getArity() + "\n";
        }
        iterator = this.variables.iterator();
        if (iterator.hasNext()) {
            string = string + "Variables : \n";
        }
        while (iterator.hasNext()) {
            serializable = (Var)iterator.next();
            string = string + ((Var)serializable).getName() + "\n";
        }
        return string;
    }

    public void display() {
        Serializable serializable;
        Iterator<Serializable> iterator = this.predicates.iterator();
        if (iterator.hasNext()) {
            System.out.println("Predicates : ");
        }
        while (iterator.hasNext()) {
            serializable = iterator.next();
            System.out.println(((Atom)serializable).getName() + "/" + ((Atom)serializable).getArity());
        }
        iterator = this.constants.iterator();
        if (iterator.hasNext()) {
            System.out.println("Constants : ");
        }
        while (iterator.hasNext()) {
            serializable = (SimpleTerm)iterator.next();
            System.out.println(((SimpleTerm)serializable).display());
        }
        iterator = this.functions.iterator();
        if (iterator.hasNext()) {
            System.out.println("Functions : ");
        }
        while (iterator.hasNext()) {
            serializable = (Function)iterator.next();
            System.out.println(((Function)serializable).getName() + "() of Arity " + ((Function)serializable).getArity());
        }
        iterator = this.variables.iterator();
        if (iterator.hasNext()) {
            System.out.println("Variables : ");
        }
        while (iterator.hasNext()) {
            serializable = (Var)iterator.next();
            System.out.println(((Var)serializable).getName());
        }
        iterator = this.skolems.iterator();
        if (iterator.hasNext()) {
            System.out.println("Skolems : ");
        }
        while (iterator.hasNext()) {
            serializable = (SimpleTerm)iterator.next();
            System.out.println(((SimpleTerm)serializable).getName());
        }
    }

    public PanSignature compare(PanSignature panSignature) {
        Object object;
        Object object22;
        List<Atom> list = panSignature.getPredicates();
        List<Atom> list2 = Collections.synchronizedList(new LinkedList());
        for (Atom object32 : list) {
            if (object32.isIn(this)) continue;
            list2.add(object32);
        }
        List<SimpleTerm> list3 = panSignature.getConstants();
        List<SimpleTerm> list4 = Collections.synchronizedList(new LinkedList());
        for (Object object22 : list3) {
            if (((SimpleTerm)object22).isIn(this)) continue;
            list4.add((SimpleTerm)object22);
        }
        object22 = panSignature.getFunctions();
        List<Function> list5 = Collections.synchronizedList(new LinkedList());
        Iterator<Serializable> iterator = object22.iterator();
        while (iterator.hasNext()) {
            object = (Function)iterator.next();
            if (((Function)object).isIn(this)) continue;
            list5.add((Function)object);
        }
        object = Collections.synchronizedList(new LinkedList());
        return new PanSignature(list2, list4, list5, (List<Var>)object, new LinkedList<SimpleTerm>());
    }

    public boolean isEmpty() {
        return this.predicates.size() == 0 && this.constants.size() == 0 && this.functions.size() == 0 && this.variables.size() == 0 && this.skolems.size() == 0;
    }

    public void addFunction(String string, int n) throws Exception {
        Vector<Term> vector = new Vector<Term>();
        for (int i = 0; i < n; ++i) {
            vector.add(null);
        }
        System.out.println("Function Size: " + vector.size());
        Function function = new Function(string, vector);
        String string2 = function.clashes(this);
        if (string2.contains("\u2718")) {
            throw new Exception(string2);
        }
    }

    public void addPredicate(String string, int n) throws Exception {
        Vector<Term> vector = new Vector<Term>();
        for (int i = 0; i < n; ++i) {
            vector.add(null);
        }
        System.out.println("Predicate Size: " + vector.size());
        Predicate predicate = new Predicate(string, vector);
        String string2 = predicate.clashes(this);
        if (string2.contains("\u2718")) {
            throw new Exception(string2);
        }
    }

    public void addConstant(String string) throws Exception {
        SimpleTerm simpleTerm = new SimpleTerm(string);
        String string2 = simpleTerm.clashes(this);
        if (string2.contains("\u2718")) {
            throw new Exception(string2);
        }
    }
}

