/*
 * Decompiled with CFR 0.152.
 */
package Pandora;

import Pandora.LogicParser.Formula.Atom;
import Pandora.LogicParser.Formula.Formula;
import Pandora.LogicParser.Formula.Function;
import Pandora.LogicParser.Formula.SimpleTerm;
import Pandora.LogicParser.Formula.Var;
import Pandora.LogicParser.ParseController;
import Pandora.PanSignature;
import Pandora.ProofWindow;
import Pandora.View;
import java.io.BufferedReader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ParseInputController
implements Serializable {
    View pandoraView = new View(this);
    String error = "\u2718";

    public View getView() {
        return this.pandoraView;
    }

    public boolean parseInput(String string, ProofWindow proofWindow) {
        boolean bl = this.checkInput(string, proofWindow);
        if (bl) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
                String string2 = bufferedReader.readLine();
                while (string2 != null && !string2.equals("\n")) {
                    ParseController parseController = new ParseController(string2);
                    Formula formula = parseController.parseLine();
                    proofWindow.addLineToProof(formula, "given");
                    string2 = bufferedReader.readLine();
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                System.out.println("parse unsuccessful");
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public boolean checkInput(String string, ProofWindow proofWindow) {
        PanSignature panSignature = proofWindow.getSignature();
        PanSignature panSignature2 = new PanSignature();
        boolean bl = true;
        boolean bl2 = true;
        proofWindow.removeAllGiven();
        try {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            String string2 = "no lines parsed";
            String string3 = bufferedReader.readLine();
            while (string3 != null && !string3.equals("\n")) {
                bl2 = true;
                int n = string3.length();
                String string4 = n > 1 ? string3.substring(0, 2) : "not comment";
                if (string4.equals("//")) {
                    proofWindow.addToGiven(string3);
                } else {
                    ParseController parseController;
                    Formula formula;
                    int n2;
                    if (n > 1 && (n2 = string3.indexOf(this.error)) != -1) {
                        string3 = string3.substring(0, n2);
                    }
                    if ((formula = (parseController = new ParseController(string3)).parseLine()) == null) {
                        string2 = string3 + this.error + "Syntax Error!(Please use the input guide on the left)";
                        proofWindow.addToGiven(string2);
                        System.out.println("null tree");
                        bl2 = false;
                    } else {
                        String string5 = formula.clashes(panSignature2);
                        if (string5.contains(this.error)) {
                            string2 = string3 + string5;
                            proofWindow.addToGiven(string2);
                            bl2 = false;
                        }
                        if (bl2) {
                            string2 = string3;
                            proofWindow.addToGiven(string2);
                        }
                    }
                }
                bl = bl2 && bl;
                string3 = bufferedReader.readLine();
            }
            bufferedReader.close();
            if (bl) {
                panSignature.setSignature(panSignature2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public boolean parseGoal(String string, ProofWindow proofWindow) {
        boolean bl = this.checkGoal(string, proofWindow);
        if (bl) {
            try {
                ParseController parseController = new ParseController(string);
                Formula formula = parseController.parseLine();
                proofWindow.addLineToProof(formula, "<goal>");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public boolean checkGoal(String string, ProofWindow proofWindow) {
        PanSignature panSignature = proofWindow.getSignature();
        List<Atom> list = panSignature.getPredicates();
        List<SimpleTerm> list2 = panSignature.getConstants();
        List<Function> list3 = panSignature.getFunctions();
        List<Var> list4 = panSignature.getVariables();
        List<SimpleTerm> list5 = Collections.synchronizedList(new LinkedList());
        PanSignature panSignature2 = new PanSignature(list, list2, list3, list4, list5);
        boolean bl = true;
        proofWindow.removeAllGoal();
        try {
            ParseController parseController;
            Formula formula;
            int n;
            String string2 = "no lines parsed";
            String string3 = string;
            int n2 = string3.length();
            if (n2 > 1 && (n = string3.indexOf(this.error)) != -1) {
                string3 = string3.substring(0, n);
            }
            if ((formula = (parseController = new ParseController(string3)).parseLine()) == null) {
                string2 = string3 + this.error + "Syntax Error!(Please use the input guide on the left)";
                proofWindow.addToGoal(string2);
                bl = false;
            } else {
                String string4 = formula.clashes(panSignature2);
                if (string4.contains(this.error)) {
                    string2 = string3 + string4;
                    proofWindow.addToGoal(string2);
                    bl = false;
                }
                if (bl) {
                    string2 = string3;
                    proofWindow.addToGoal(string2);
                    panSignature.setSignature(panSignature2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }
}

