/*
 * Decompiled with CFR 0.152.
 */
package Pandora;

import Pandora.Justification;
import Pandora.LogicParser.Formula.Atom;
import Pandora.LogicParser.Formula.Formula;
import Pandora.LogicParser.Formula.SimpleTerm;
import Pandora.PanSignature;
import Pandora.ProofItem;
import Pandora.ProofLine;
import Pandora.ProofWindow;
import Pandora.xGui.Colour;
import Pandora.xGui.DashedBorder;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ProofBox
extends ProofItem
implements MouseListener {
    List<ProofItem> proofItems = Collections.synchronizedList(new LinkedList());
    ProofBox nextBox;
    ProofBox olderSiblingBox = null;
    boolean boxStarted = false;
    boolean proved = false;
    boolean displayItems = true;
    boolean displayBorder = true;
    boolean dashedBox = false;
    int firstLine;
    int lastLine;
    PanSignature signature = new PanSignature();
    public int skolem = 1;

    public ProofBox(ProofWindow proofWindow) {
        super(proofWindow);
        this.signature = proofWindow.getSignature();
    }

    public ProofBox(ProofWindow proofWindow, ProofBox proofBox) {
        super(proofWindow, proofBox);
        PanSignature panSignature = proofBox.getSignature();
        List<SimpleTerm> list = Collections.synchronizedList(new LinkedList());
        this.signature = new PanSignature(panSignature.getPredicates(), panSignature.getConstants(), panSignature.getFunctions(), panSignature.getVariables(), list);
    }

    public ProofBox(ProofLine proofLine, ProofWindow proofWindow, ProofBox proofBox) {
        super(proofWindow, proofBox);
        ProofLine proofLine2 = new ProofLine(null, "", proofWindow, this);
        this.addItem(proofLine2);
        this.addItem(proofLine);
        this.lastLine = proofLine.getLineNum();
        PanSignature panSignature = proofBox.getSignature();
        List<SimpleTerm> list = Collections.synchronizedList(new LinkedList());
        this.signature = new PanSignature(panSignature.getPredicates(), panSignature.getConstants(), panSignature.getFunctions(), panSignature.getVariables(), list);
    }

    public ProofBox getNextBox() {
        return this.nextBox;
    }

    public ProofBox setNextBox() {
        this.nextBox = new ProofBox(this.parentWindow, this.parentBox);
        this.nextBox.setOlderSiblingBox(this);
        return this.nextBox;
    }

    public boolean hasNextBox() {
        return null != this.nextBox;
    }

    public ProofBox getOlderSiblingBox() {
        return this.olderSiblingBox;
    }

    public void setOlderSiblingBox(ProofBox proofBox) {
        this.olderSiblingBox = proofBox;
    }

    public void setBoxStarted(boolean bl) {
        this.boxStarted = bl;
    }

    public boolean isProved() {
        return this.proved;
    }

    public boolean getDisplayBorder() {
        return this.displayBorder;
    }

    public void setDisplayBorder(boolean bl) {
        this.displayBorder = bl;
    }

    public boolean getDisplayItems() {
        return this.displayItems;
    }

    public void setDisplayItems(boolean bl) {
        this.displayItems = bl;
    }

    public void setDashedBox(boolean bl) {
        this.dashedBox = bl;
    }

    public List<ProofItem> getProofItems() {
        return this.proofItems;
    }

    @Override
    public int recalculateLineNum(int n) {
        this.firstLine = n;
        ListIterator<ProofItem> listIterator = this.proofItems.listIterator(0);
        while (listIterator.hasNext()) {
            ProofItem proofItem;
            ProofItem proofItem2 = listIterator.next();
            if (proofItem2 instanceof ProofLine) {
                proofItem = (ProofLine)proofItem2;
                n = ((ProofLine)proofItem).recalculateLineNum(n);
                continue;
            }
            if (!(proofItem2 instanceof ProofBox)) continue;
            proofItem = (ProofBox)proofItem2;
            do {
                n = ((ProofBox)proofItem).recalculateLineNum(n);
            } while ((proofItem = ((ProofBox)proofItem).getNextBox()) != null);
        }
        this.lastLine = n - 1;
        return n;
    }

    public ProofItem next(ProofItem proofItem) {
        int n = this.proofItems.indexOf(proofItem) + 1;
        return this.proofItems.get(n);
    }

    public int getIndex(ProofItem proofItem) {
        return this.proofItems.indexOf(proofItem);
    }

    public void addItem(ProofItem proofItem) {
        ProofLine proofLine;
        proofItem.setParentBox(this);
        this.proofItems.add(proofItem);
        this.parentWindow.displayAllSignature();
        if (proofItem instanceof ProofLine && (proofLine = (ProofLine)proofItem).getJustification().getSymbol().equals("<goal>")) {
            this.boxStarted = true;
        }
    }

    public void addItem(int n, ProofItem proofItem) {
        ProofLine proofLine;
        proofItem.setParentBox(this);
        this.proofItems.add(n, proofItem);
        this.parentWindow.displayAllSignature();
        if (proofItem instanceof ProofLine && (proofLine = (ProofLine)proofItem).getJustification().getSymbol().equals("<goal>")) {
            this.boxStarted = true;
        }
    }

    public void removeItem(int n) {
        this.proofItems.remove(n);
        this.parentWindow.displayAllSignature();
    }

    private void setSignature(PanSignature panSignature) {
        ProofBox proofBox = this.parentBox;
        while (proofBox != null) {
            this.addSkolems(proofBox, panSignature);
            proofBox = proofBox.parentBox;
        }
    }

    public void addSkolems(ProofBox proofBox, PanSignature panSignature) {
        List<SimpleTerm> list = proofBox.getSignature().getSkolems();
        for (SimpleTerm simpleTerm : list) {
            if (simpleTerm.isIn(panSignature)) continue;
            panSignature.getSkolems().add(simpleTerm);
        }
    }

    public void addToSignature(List<Atom> list) {
        this.signature.addToSignature(list);
    }

    public PanSignature getSignature() {
        PanSignature panSignature = this.signature.clone();
        this.setSignature(panSignature);
        return panSignature;
    }

    public PanSignature getMainSignature() {
        return this.signature;
    }

    public void deselectAll() {
        ListIterator<ProofItem> listIterator = this.proofItems.listIterator(0);
        while (listIterator.hasNext()) {
            ProofItem proofItem;
            ProofItem proofItem2 = listIterator.next();
            if (proofItem2 instanceof ProofLine) {
                proofItem = (ProofLine)proofItem2;
                ((ProofLine)proofItem).deselectLine();
                continue;
            }
            if (!(proofItem2 instanceof ProofBox)) continue;
            proofItem = (ProofBox)proofItem2;
            do {
                ((ProofBox)proofItem).deselectAll();
            } while ((proofItem = ((ProofBox)proofItem).getNextBox()) != null);
        }
    }

    @Override
    public JPanel display() {
        Serializable serializable;
        Object object;
        JPanel jPanel = new JPanel(new FlowLayout(3));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        if (this.displayBorder) {
            jPanel2.addMouseListener(this);
            jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.firstLine + " - " + this.lastLine), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        }
        if (this.dashedBox) {
            jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(new DashedBorder(Colour.borderBlue, 12, 12), this.firstLine + " - " + this.lastLine), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        }
        if (this.provedBoxCheck()) {
            jPanel.setBackground(Colour.artisticSlightlyMoreGreenThanTennisBallYellowGreen);
            jPanel2.setBackground(Colour.artisticSlightlyMoreGreenThanTennisBallYellowGreen);
            this.cleanupBox();
        } else {
            jPanel.setBackground(Colour.white);
            jPanel2.setBackground(Colour.white);
        }
        int n = 0;
        if (this.displayItems) {
            object = this.proofItems.listIterator(0);
            while (object.hasNext()) {
                ProofItem proofItem;
                serializable = object.next();
                if (serializable instanceof ProofLine) {
                    proofItem = (ProofLine)serializable;
                    jPanel2.add(((ProofLine)proofItem).display());
                    n = (int)((double)n + ((ProofLine)proofItem).display().getPreferredSize().getHeight());
                    continue;
                }
                if (!(serializable instanceof ProofBox)) continue;
                proofItem = (ProofBox)serializable;
                JPanel jPanel3 = new JPanel();
                jPanel3.setLayout(new BoxLayout(jPanel3, 0));
                jPanel3.setBackground(Colour.white);
                do {
                    JPanel jPanel4 = ((ProofBox)proofItem).display();
                    jPanel4.setAlignmentX(0.0f);
                    jPanel4.setAlignmentY(0.0f);
                    jPanel3.add(jPanel4);
                    n = (int)((double)n + ((ProofBox)proofItem).display().getPreferredSize().getHeight());
                } while ((proofItem = ((ProofBox)proofItem).getNextBox()) != null);
                jPanel2.add(jPanel3);
            }
        }
        object = new JLabel(this.firstLine + " - " + this.lastLine);
        serializable = Double.valueOf(((JComponent)object).getPreferredSize().getWidth());
        if (jPanel2.getPreferredSize().getWidth() < 50.0) {
            jPanel2.setPreferredSize(new Dimension(((Double)serializable).intValue() + 16, 20));
        }
        jPanel.add(jPanel2);
        return jPanel;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (this.displayBorder) {
                this.displayItems = !this.displayItems;
                this.parentWindow.reloadProofBox();
                this.parentWindow.validate();
                this.parentWindow.repaint();
            }
        } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.parentWindow.showLocalSignature(this.getSignature());
        }
    }

    private boolean provedBoxCheck() {
        this.proved = this.boxStarted;
        ListIterator<ProofItem> listIterator = this.proofItems.listIterator(0);
        while (listIterator.hasNext()) {
            ProofItem proofItem;
            ProofItem proofItem2 = listIterator.next();
            if (proofItem2 instanceof ProofLine) {
                proofItem = (ProofLine)proofItem2;
                if (!((ProofLine)proofItem).getJustification().getSymbol().equals("<goal>")) continue;
                this.proved = false;
                continue;
            }
            if (!(proofItem2 instanceof ProofBox)) continue;
            proofItem = (ProofBox)proofItem2;
            do {
                if (super.provedBoxCheck()) continue;
                this.proved = false;
            } while ((proofItem = ((ProofBox)proofItem).getNextBox()) != null);
        }
        if (!this.displayBorder && !this.proved) {
            this.parentWindow.validate();
            this.parentWindow.repaint();
        }
        return this.proved;
    }

    private void cleanupBox() {
        ListIterator<ProofItem> listIterator = this.proofItems.listIterator(0);
        while (listIterator.hasNext()) {
            ProofLine proofLine;
            ProofItem proofItem = listIterator.next();
            if (!(proofItem instanceof ProofLine) || !(proofLine = (ProofLine)proofItem).getJustification().getSymbol().equals("")) continue;
            listIterator.remove();
        }
    }

    public void cleanup() {
        ListIterator<ProofItem> listIterator = this.proofItems.listIterator(0);
        while (listIterator.hasNext()) {
            ProofItem proofItem;
            ProofItem proofItem2;
            ProofItem proofItem3 = listIterator.next();
            if (proofItem3 instanceof ProofBox) {
                proofItem2 = (ProofBox)proofItem3;
                do {
                    ((ProofBox)proofItem2).cleanup();
                } while ((proofItem2 = ((ProofBox)proofItem2).getNextBox()) != null);
                continue;
            }
            proofItem2 = (ProofLine)proofItem3;
            if (!((ProofLine)proofItem2).getJustification().getSymbol().equals("") || !listIterator.hasNext()) continue;
            ProofItem proofItem4 = listIterator.next();
            if (proofItem4 instanceof ProofLine) {
                proofItem = (ProofLine)proofItem4;
                if (((ProofLine)proofItem).getJustification().getSymbol().equals("<goal>")) continue;
                listIterator.previous();
                listIterator.previous();
                listIterator.remove();
                this.parentWindow.reloadProofBox();
                continue;
            }
            if (!(proofItem4 instanceof ProofBox)) continue;
            proofItem = (ProofBox)proofItem4;
            do {
                ((ProofBox)proofItem).cleanup();
            } while ((proofItem = ((ProofBox)proofItem).getNextBox()) != null);
        }
    }

    public void regenerate(ProofBox proofBox, ProofWindow proofWindow) {
        proofBox.setBoxStarted(this.boxStarted);
        proofBox.setDisplayBorder(this.getDisplayBorder());
        proofBox.setDisplayItems(this.getDisplayItems());
        proofBox.setDashedBox(this.dashedBox);
        proofBox.getMainSignature().setSignature(this.getMainSignature());
        proofBox.skolem = this.skolem;
        ListIterator<ProofItem> listIterator = this.proofItems.listIterator(0);
        while (listIterator.hasNext()) {
            Serializable serializable;
            Serializable serializable2;
            Serializable serializable3;
            ProofItem proofItem;
            ProofItem proofItem2 = listIterator.next();
            if (proofItem2 instanceof ProofLine) {
                Object object;
                proofItem = (ProofLine)proofItem2;
                if (((ProofLine)proofItem).getJustification().getSymbol().equals("")) {
                    serializable3 = new ProofLine(null, "", proofWindow, proofBox);
                    ((ProofLine)serializable3).setLineComment(((ProofLine)proofItem).getLineComment());
                    proofBox.addItem((ProofItem)serializable3);
                    proofWindow.tempProofLines.add((ProofLine)serializable3);
                    continue;
                }
                int n = ((ProofLine)proofItem).getLineNum();
                serializable2 = ((ProofLine)proofItem).getFormula().regenerate();
                serializable = null;
                String string = ((ProofLine)proofItem).getJustification().getSymbol();
                List<ProofLine> list = ((ProofLine)proofItem).getJustification().getLines();
                List<ProofLine> list2 = null;
                if (list != null) {
                    list2 = Collections.synchronizedList(new LinkedList());
                    object = list.listIterator(0);
                    while (object.hasNext()) {
                        ProofLine proofLine = object.next();
                        list2.add(proofWindow.tempProofLines.get(proofLine.getLineNum() - 1));
                    }
                }
                serializable = new Justification(string, list2);
                object = new ProofLine((Formula)serializable2, (Justification)serializable, n, proofWindow, proofBox);
                ((ProofLine)object).setLineComment(((ProofLine)proofItem).getLineComment());
                proofBox.addItem((ProofItem)object);
                proofWindow.tempProofLines.add((ProofLine)object);
                continue;
            }
            if (!(proofItem2 instanceof ProofBox)) continue;
            proofItem = (ProofBox)proofItem2;
            serializable3 = new ProofBox(proofWindow, proofBox);
            serializable2 = null;
            proofBox.addItem((ProofItem)serializable3);
            do {
                serializable2 = (serializable = ((ProofBox)proofItem).getNextBox()) != null ? serializable3.setNextBox() : null;
                ((ProofBox)proofItem).regenerate((ProofBox)serializable3, proofWindow);
                if (serializable2 == null) continue;
                serializable3 = serializable2;
            } while ((proofItem = serializable) != null);
        }
    }
}

