/*
 * Decompiled with CFR 0.152.
 */
package Pandora;

import Pandora.Justification;
import Pandora.LogicParser.Formula.Formula;
import Pandora.ProofBox;
import Pandora.ProofItem;
import Pandora.ProofWindow;
import Pandora.xGui.Colour;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ProofLine
extends ProofItem
implements Comparable<ProofLine> {
    int lineNum;
    Formula formula;
    Justification justification;
    String lineComment;
    JLabel lineLabel;
    JLabel formulaLabel;
    JLabel justLabel;

    public ProofLine(Formula formula, ProofWindow proofWindow, ProofBox proofBox) {
        super(proofWindow, proofBox);
        this.formula = formula;
    }

    public ProofLine(Formula formula, String string, ProofWindow proofWindow, ProofBox proofBox) {
        super(proofWindow, proofBox);
        this.formula = formula;
        this.justification = new Justification(string);
    }

    public ProofLine(Formula formula, Justification justification, ProofWindow proofWindow, ProofBox proofBox) {
        super(proofWindow, proofBox);
        this.formula = formula;
        this.justification = justification;
    }

    public ProofLine(Formula formula, Justification justification, int n, ProofWindow proofWindow, ProofBox proofBox) {
        super(proofWindow, proofBox);
        this.formula = formula;
        this.justification = justification;
        this.lineNum = n;
    }

    public int getLineNum() {
        return this.lineNum;
    }

    public void setLineNum(int n) {
        this.lineNum = n;
    }

    @Override
    public int recalculateLineNum(int n) {
        this.setLineNum(n);
        return n + 1;
    }

    public Formula getFormula() {
        return this.formula;
    }

    public void setFormula(Formula formula) {
        this.formula = formula;
    }

    public Justification getJustification() {
        return this.justification;
    }

    public void setJustification(Justification justification) {
        this.justification = justification;
    }

    public String getLineComment() {
        return this.lineComment;
    }

    public void setLineComment(String string) {
        this.lineComment = string;
    }

    public void selectLine() {
        if (this.parentWindow.isDone()) {
            this.selected = true;
            this.displayColour();
            this.parentWindow.reloadProofBox();
            this.parentWindow.setLastSelectedLine(this);
        } else {
            if (this.parentWindow.firstTMLine instanceof ProofLine) {
                ProofLine proofLine = (ProofLine)this.parentWindow.firstTMLine;
                if (this.lineNum > proofLine.getLineNum()) {
                    JOptionPane.showMessageDialog(this.parentWindow, "Line " + this.lineNum + " is not in scope of the target line", "Not In Scope", 0);
                } else if (this.getJustification().symbol.equals("")) {
                    JOptionPane.showMessageDialog(this.parentWindow, "An empty line cannot be selected as justification", "Error", 0);
                } else if (!this.parentWindow.TMProofLines.contains(this)) {
                    this.selected = true;
                    this.displayColour();
                    this.parentWindow.TMProofLines.add(this);
                }
            }
            this.parentWindow.reloadProofBox();
        }
    }

    public void deselectLine() {
        if (this.parentWindow.isDone()) {
            this.selected = false;
            this.displayColour();
            this.parentWindow.clearLastSelectedLine();
        } else {
            this.parentWindow.TMProofLines.remove(this);
            this.selected = false;
            this.displayColour();
        }
    }

    public void deselectLineNoClear() {
        this.selected = false;
        this.displayColour();
        this.parentWindow.reloadProofBox();
        this.parentWindow.validate();
    }

    @Override
    public JPanel display() {
        Object object;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBackground(Colour.seeThrough);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.lineLabel = new JLabel(Integer.toString(this.lineNum));
        this.lineLabel.setAlignmentY(1.0f);
        this.lineLabel.setSize(new Dimension(50, 100));
        this.parentWindow.view.applyFont(this.lineLabel, "medium");
        this.justLabel = new JLabel(this.justification.display());
        this.justLabel.setAlignmentY(1.0f);
        this.parentWindow.view.applyFont(this.justLabel, "medium");
        if (this.justification.display().equals("")) {
            this.formulaLabel = new JLabel("<empty>");
            jPanel2.add(Box.createRigidArea(new Dimension(0, 30)));
        } else {
            object = this.formula.display();
            String string = ((String)object).substring(0, 1);
            this.formulaLabel = new JLabel((String)object);
        }
        this.formulaLabel.setAlignmentY(1.0f);
        if (this.formulaLabel.getPreferredSize().getWidth() < 100.0) {
            // empty if block
        }
        this.parentWindow.view.applyFont(this.formulaLabel, "medium");
        if (this.justification.display().equals("<goal>")) {
            jPanel2.add(Box.createRigidArea(new Dimension(0, 30)));
            this.lineLabel.setAlignmentY(0.0f);
            this.justLabel.setAlignmentY(0.0f);
            this.formulaLabel.setAlignmentY(0.0f);
        }
        jPanel2.add(this.lineLabel);
        jPanel2.add(Box.createRigidArea(new Dimension(50, 0)));
        jPanel2.add(this.formulaLabel);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(Box.createRigidArea(new Dimension(50, 0)));
        jPanel2.add(this.justLabel);
        jPanel2.addMouseListener(this);
        jPanel2.setBackground(Colour.seeThrough);
        this.formulaLabel.setBackground(Colour.seeThrough);
        this.justLabel.setBackground(Colour.seeThrough);
        this.displayColour();
        jPanel.add(jPanel2);
        if (this.lineComment != null) {
            object = new JLabel(this.lineComment);
            this.parentWindow.view.applyFont((JComponent)object, "medium");
            ((JComponent)object).setAlignmentX(0.5f);
            ((JComponent)object).setBackground(Colour.seeThrough);
            ((JComponent)object).setForeground(Colour.comment);
            jPanel.add((Component)object);
        }
        return jPanel;
    }

    @Override
    public void displayColour() {
        if (this.selected) {
            this.lineLabel.setForeground(Colour.lineGreen);
            this.formulaLabel.setForeground(Colour.lineGreen);
            this.justLabel.setForeground(Colour.lineGreen);
            this.parentWindow.validate();
            this.parentWindow.repaint();
        } else {
            this.lineLabel.setForeground(Colour.black);
            this.formulaLabel.setForeground(Colour.black);
            this.justLabel.setForeground(Colour.black);
            this.parentWindow.validate();
            this.parentWindow.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && !this.parentBox.isProved()) {
            if (this.selected) {
                this.deselectLine();
                this.parentWindow.reloadProofBox();
            } else {
                this.selectLine();
            }
        } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.parentWindow.showLocalSignature(this.parentBox.getSignature());
        }
    }

    @Override
    public int compareTo(ProofLine proofLine) {
        if (this.lineNum < proofLine.lineNum) {
            return -1;
        }
        return 1;
    }
}

