/*
 * Decompiled with CFR 0.152.
 */
package Pandora;

import Pandora.Help.HelpFrame;
import Pandora.LogicParser.Formula.Atom;
import Pandora.LogicParser.Formula.Formula;
import Pandora.LogicParser.Formula.Function;
import Pandora.LogicParser.Formula.SimpleTerm;
import Pandora.LogicParser.Formula.Var;
import Pandora.PanSignature;
import Pandora.ProofBox;
import Pandora.ProofItem;
import Pandora.ProofLine;
import Pandora.RuleController;
import Pandora.View;
import Pandora.xGui.Colour;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class ProofWindow
extends JPanel
implements ActionListener,
KeyListener,
FocusListener {
    public static final long serialVersionUID = 1L;
    static final String undoSymbol = "\u21b6";
    static final String redoSymbol = "\u21b7";
    public View view;
    public boolean inProof = false;
    public List<ProofLine> tempProofLines = Collections.synchronizedList(new LinkedList());
    public List<ProofLine> TMProofLines = Collections.synchronizedList(new LinkedList());
    public List<ProofBox> undoList = Collections.synchronizedList(new LinkedList());
    public List<ProofBox> redoList = Collections.synchronizedList(new LinkedList());
    ProofBox savedBox;
    JPanel sidebar;
    JPanel proofArea = new JPanel();
    JPanel mainBoxDisplayer;
    JPanel eb;
    JPanel func;
    JPanel ie;
    JPanel qie;
    JButton rule;
    JScrollPane boxScroll;
    JButton tempSource;
    int tempV;
    boolean tempVLock = false;
    int tempH;
    boolean tempHLock = false;
    JTextPane given = new JTextPane();
    JTextField goal = new JTextField();
    boolean sigShow = false;
    JToolBar sigToolbar = null;
    JTextPane pred;
    JTextPane constant;
    JTextPane function;
    JTextPane variable;
    JTextPane skolem;
    JToolBar addPredTB = null;
    JTextField addPredTBName;
    JTextField addPredTBArity;
    JToolBar addConstTB = null;
    JTextField addConstTBName;
    JToolBar addFuncTB = null;
    JTextField addFuncTBName;
    JTextField addFuncTBArity;
    PanSignature signature = new PanSignature();
    ProofLine lastSelectedLine;
    JButton lastRuleSelected;
    public RuleController ruleCtrl;
    boolean inRule = false;
    boolean isTM = false;
    boolean isTMT = false;
    boolean isDone = true;
    boolean hasError = true;
    public ProofBox mainProofBox = new ProofBox(this);
    public ProofItem firstTMLine;

    public ProofWindow(View view) {
        this.view = view;
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(3, 0, 0));
        this.sidebar = new JPanel();
        this.sidebar.setLayout(new BoxLayout(this.sidebar, 1));
        jPanel.add(this.sidebar);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jPanel);
        JScrollPane jScrollPane = new JScrollPane(jPanel, 22, 31);
        jScrollPane.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.inputProofMode();
        this.add((Component)jScrollPane, "West");
    }

    public void inputProofMode() {
        this.sidebar.removeAll();
        JToolBar jToolBar = new JToolBar("Pandora Help Box");
        JPanel jPanel = new JPanel(new GridLayout());
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        jEditorPane.setBackground(Color.WHITE);
        URL uRL = ProofWindow.class.getResource("/InputGuide.html");
        try {
            jEditorPane.setPage(uRL);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        jPanel.add(jEditorPane);
        jToolBar.add(jPanel);
        this.sidebar.add(jToolBar);
        this.showSignature();
        this.proofArea.removeAll();
        this.proofArea.setLayout(new BoxLayout(this.proofArea, 1));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.proofArea.add(jPanel2);
        JTextField jTextField = new JTextField("Givens:");
        jTextField.setEditable(false);
        this.view.applyFont(jTextField, "large");
        jPanel2.add(jTextField);
        JButton jButton = new JButton("Check Proof");
        jButton.addKeyListener(this);
        jButton.addActionListener(this);
        this.view.applyFont(jButton, "large");
        jPanel2.add((Component)jButton, "East");
        this.given.addKeyListener(this);
        this.view.applyFont(this.given, "large");
        JScrollPane jScrollPane = new JScrollPane(this.given);
        jScrollPane.setPreferredSize(new Dimension(0, 1280));
        jScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.proofArea.add(jScrollPane);
        JTextField jTextField2 = new JTextField("Goal:");
        jTextField2.setEditable(false);
        this.view.applyFont(jTextField2, "large");
        this.proofArea.add(jTextField2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.proofArea.add(jPanel3);
        this.view.applyFont(this.goal, "large");
        jPanel3.add(this.goal);
        JPanel jPanel4 = new JPanel(new FlowLayout(2, 0, 0));
        jPanel3.add((Component)jPanel4, "East");
        JButton jButton2 = new JButton("Start Proof");
        jButton2.addActionListener(this);
        this.view.applyFont(jButton2, "large");
        jPanel4.add(jButton2);
        JButton jButton3 = new JButton(redoSymbol);
        jButton3.setToolTipText("Solve Proof Mode");
        jButton3.addActionListener(this);
        this.view.applyFont(jButton3, "large");
        jPanel4.add(jButton3);
        this.add(this.proofArea);
        this.validate();
        this.repaint();
        this.inProof = false;
    }

    public void solveProofMode() {
        this.sidebar.removeAll();
        this.sidebar.add(this.getPandoraProofToolbar());
        this.sidebar.add(this.signatureToolbar());
        this.proofArea.removeAll();
        if (this.addPredTB != null) {
            this.sidebar.add((Component)this.addPredTB, 0);
        }
        if (this.addConstTB != null) {
            this.sidebar.add((Component)this.addConstTB, 0);
        }
        if (this.addFuncTB != null) {
            this.sidebar.add((Component)this.addFuncTB, 0);
        }
        this.validate();
        this.repaint();
        this.inProof = true;
    }

    public PanSignature getSignature() {
        return this.signature;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        AbstractButton abstractButton;
        String string = null;
        String string2 = null;
        if (actionEvent.getSource() instanceof JButton) {
            abstractButton = (JButton)actionEvent.getSource();
            string = abstractButton.getText();
            string2 = abstractButton.getToolTipText();
        } else if (actionEvent.getSource() instanceof JMenuItem) {
            abstractButton = (JMenuItem)actionEvent.getSource();
            string = abstractButton.getText();
            string2 = abstractButton.getToolTipText();
        }
        String string3 = string2 == null ? string : string2;
        if (string3.equals("New Proof") || string3.equals("New")) {
            this.view.addProofWindow();
        } else if (string3.equals("Close")) {
            this.view.removeProofWindow();
        } else if (string3.equals("Start Proof")) {
            if (this.checkGiven() && this.checkGoal()) {
                this.mainProofBox = new ProofBox(this);
                this.solveProofMode();
                this.parseGiven();
                this.parseGoal();
                this.redoList.clear();
            } else if (actionEvent.getSource() instanceof JButton) {
                this.parseFeedback((JButton)actionEvent.getSource(), false);
            }
        } else if (string3.equals("Check Proof")) {
            boolean bl = true;
            bl = bl && this.checkGiven();
            bl = bl && this.checkGoal();
            this.displayAllSignature();
            if (actionEvent.getSource() instanceof JButton) {
                this.parseFeedback((JButton)actionEvent.getSource(), bl);
            }
        } else if (string3.equals("Solve Proof Mode")) {
            if (this.mainProofBox.getProofItems().size() > 0) {
                this.solveProofMode();
                this.setupMainProofBox();
            }
        } else if (string3.equals("Undo")) {
            this.undo();
        } else if (string3.equals("Redo")) {
            this.redo();
        } else if (string3.equals("Reset")) {
            if (this.ruleCtrl != null) {
                this.finishedRule();
            } else {
                this.clearLastRuleSelected();
                this.clearLastSelectedLine();
                this.mainProofBox.deselectAll();
                this.mainProofBox.cleanup();
                this.reloadProofBox();
            }
        } else if (string3.equals("\u2192E") || string3.equals("\u2192I") || string3.equals("\u2227I") || string3.equals("\u221a") || string3.equals("\u2227E") || string3.equals("Lemma") || string3.equals("\u2228E") || string3.equals("\u2228I") || string3.equals("\u2194E") || string3.equals("\u2194I") || string3.equals("\u00acE") || string3.equals("\u00acI") || string3.equals("\u22a5E") || string3.equals("\u22a5I") || string3.equals("PC") || string3.equals("EM") || string3.equals("\u00ac\u00ac") || string3.equals("\u22a5E") || string3.equals("\u2194I2") || string3.equals("\u2194E2") || string3.equals("Reflexivity") || string3.equals("=Sub") || string3.equals("\u2203E") || string3.equals("\u2203I") || string3.equals("\u2200E") || string3.equals("\u2200I") || string3.equals("\u2200E\u221a") || string3.equals("\u2200\u2192E") || string3.equals("\u2200\u2192I") || string3.equals("\u22a4I")) {
            abstractButton = (JButton)actionEvent.getSource();
            if (this.getLastRuleSelected() == abstractButton) {
                this.deselectRule((JButton)abstractButton);
            } else {
                this.selectRule((JButton)abstractButton);
            }
        } else if (string3.equals("TM\u221a") || string3.equals("TM")) {
            if (string3.equals("TM")) {
                this.isTM = true;
                this.isTMT = false;
            } else {
                this.isTM = false;
                this.isTMT = true;
            }
            this.rule = (JButton)actionEvent.getSource();
            this.isDone = false;
            if (this.getLastRuleSelected() == this.rule) {
                this.deselectRule(this.rule);
            } else {
                this.selectRule(this.rule);
            }
            if (this.lastSelectedLine != null) {
                this.firstTMLine = this.lastSelectedLine;
                this.TMProofLines.add(this.lastSelectedLine);
                if (this.firstTMLine instanceof ProofLine) {
                    if (((ProofLine)this.firstTMLine).getJustification().symbol.equals("")) {
                        this.TMProofLines.remove(this.lastSelectedLine);
                        HelpFrame.launch("TrustMe rule:\n\nYou are using this rule forwards:\n1. You may now select the lines that you have used for\nthe justification of inserting a new formula\n2. Type the formula you would like to add to the proof");
                    }
                    if (((ProofLine)this.firstTMLine).getJustification().symbol.equals("<goal>") && this.isTM) {
                        HelpFrame.launch("TrustMe rule:\n\nYou are using this rule backwards:\n1. You may now select the lines that you have used for\nthe justification of inserting a new goal\n2. Type the formula you would like to add to the proof\nas the new goal, the formula will then appear along with\nthe line numbers which were used as justification.\n\nFor other uses click the help button");
                    } else if (((ProofLine)this.firstTMLine).getJustification().symbol.equals("<goal>") && this.isTMT) {
                        HelpFrame.launch("TrustMe-Tick rule:\n\n1. You may now select the lines of the proof that you\nhave used to justify or deduce that the goal line selected\nin step 1 follows on from the last proof line above it.\n2. The proof step and it's corresponding sub-proofs are\ncompleted, i.e. the empty line is removed and \"something\"\nwill turn green.");
                    }
                }
                this.disableButtons();
            } else {
                this.isDone = true;
                if (!this.hasError) {
                    JOptionPane.showMessageDialog(this.view, "Must select a line to apply the rule to first", "Error", 0);
                }
                this.hasError = false;
                this.deselectRule(this.rule);
            }
        } else if (string3.equals("Done")) {
            if (this.TMProofLines.size() >= 0 && !this.isTM || this.TMProofLines.size() >= 0 && this.isTM) {
                this.isDone = true;
                this.selectRule(this.rule);
                this.TMProofLines = Collections.synchronizedList(new LinkedList());
                this.enableButtons();
                this.rule = null;
            } else {
                JOptionPane.showMessageDialog(this.view, "Must select at least one line as justification.", "Warning", 2);
            }
        } else if (string3.equals("Cancel")) {
            this.isDone = true;
            this.finishedRule();
            this.enableButtons();
            this.rule = null;
            this.TMProofLines = Collections.synchronizedList(new LinkedList());
        } else if (string3.equals("Help")) {
            if (this.isTM) {
                HelpFrame.launch("TrustMe rule:\n\nForwards:\n1. Select an empty line and click TM\n2. You may now select the lines that you have used for\nthe justification of inserting a new formula\n3. Type the formula you would like to add to the proof\n\nBackwards:\n1. Select a goal line and click TM\n2. You may now select the lines that you have used for\nthe justification of inserting a new goal\n3. Type the formula you would like to add to the proof\nas the new goal, the formula will then appear along with\nthe line numbers which were used as justification.");
            } else {
                HelpFrame.launch("TrustMe-Tick rule:\n\nForwards:\nTM-Tick cannot be applied forwards\n\nBackwards:\n1. Select a goal line and click TM\u221a\n2. You may now select the lines of the proof that you\nhave used to justify or deduce that the goal line selected\nin step 1 follows on from the last proof line above it.\n3. The proof step and it's corresponding sub-proofs are\ncompleted, i.e. the empty line is removed and \"something\"\nwill turn green.");
            }
        } else if (string3.equals("Add Predicate")) {
            try {
                this.mainProofBox.getMainSignature().addPredicate(this.addPredTBName.getText(), Integer.parseInt(this.addPredTBArity.getText()));
                this.sidebar.remove(this.addPredTB);
                this.addPredTB = null;
                this.displayAllSignature();
                this.sidebar.validate();
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this.view, "Arity must be an integer", "Number Format Error", 2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (string3.equals("Cancel Add Predicate")) {
            this.sidebar.remove(this.addPredTB);
            this.addPredTB = null;
            this.sidebar.validate();
        } else if (string3.equals("Add Constant")) {
            try {
                this.mainProofBox.getMainSignature().addConstant(this.addConstTBName.getText());
                this.sidebar.remove(this.addConstTB);
                this.addConstTB = null;
                this.displayAllSignature();
                this.sidebar.validate();
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this.view, "Arity must be an integer", "Number Format Error", 2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (string3.equals("Cancel Add Constant")) {
            this.sidebar.remove(this.addConstTB);
            this.addConstTB = null;
            this.sidebar.validate();
        } else if (string3.equals("Add Function")) {
            try {
                this.mainProofBox.getMainSignature().addFunction(this.addFuncTBName.getText(), Integer.parseInt(this.addFuncTBArity.getText()));
                this.sidebar.remove(this.addFuncTB);
                this.addFuncTB = null;
                this.displayAllSignature();
                this.sidebar.validate();
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (string3.equals("Cancel Add Function")) {
            this.sidebar.remove(this.addFuncTB);
            this.addFuncTB = null;
            this.sidebar.validate();
        } else if (string3.equals("Show Signature") || string3.equals("Hide Signature")) {
            boolean bl = this.sigShow = !this.sigShow;
            if (this.sigToolbar != null) {
                this.signatureToolbarContent();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        JTextField jTextField = (JTextField)focusEvent.getSource();
        if (jTextField.getText().equals("Pred Name") || jTextField.getText().equals("Const Name") || jTextField.getText().equals("Func Name") || jTextField.getText().equals("Arity")) {
            jTextField.setText("");
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        JTextField jTextField = (JTextField)focusEvent.getSource();
        if (jTextField.getText().equals("")) {
            if (jTextField == this.addPredTBName) {
                jTextField.setText("Pred Name");
            }
            if (jTextField == this.addConstTBName) {
                jTextField.setText("Const Name");
            }
            if (jTextField == this.addFuncTBName) {
                jTextField.setText("Func Name");
            } else if (jTextField == this.addPredTBArity || jTextField == this.addFuncTBArity) {
                jTextField.setText("Arity");
            }
        }
    }

    private void parseFeedback(JButton jButton, boolean bl) {
        this.tempSource = jButton;
        final String string = this.tempSource.getText();
        final Timer timer = new Timer();
        if (bl) {
            this.tempSource.setBackground(Colour.artisticSlightlyMoreGreenThanTennisBallYellowGreen);
            this.tempSource.setText("       :-)       ");
        } else {
            this.tempSource.setText("       :-(       ");
            timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    ProofWindow.this.tempSource.setBackground(Colour.errorRed);
                }
            }, 0L, 800L);
            timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    ProofWindow.this.tempSource.setBackground(Colour.defaultButtonBackground);
                }
            }, 400L, 800L);
        }
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                ProofWindow.this.tempSource.setBackground(Colour.defaultButtonBackground);
                ProofWindow.this.tempSource.setText(string);
                timer.cancel();
            }
        }, 2000L);
    }

    public void openProof(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            this.inProof = objectInputStream.readBoolean();
            this.given.setText(objectInputStream.readUTF());
            this.goal.setText(objectInputStream.readUTF());
            if (this.inProof) {
                this.solveProofMode();
                ProofBox proofBox = (ProofBox)objectInputStream.readObject();
                this.mainProofBox = new ProofBox(this);
                this.tempProofLines.removeAll(this.tempProofLines);
                proofBox.regenerate(this.mainProofBox, this);
                this.setupMainProofBox();
                this.undoList = (List)objectInputStream.readObject();
                this.redoList = (List)objectInputStream.readObject();
            }
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println("read error");
            exception.printStackTrace();
        }
    }

    public void saveProof(String string) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string));
            objectOutputStream.writeBoolean(this.inProof);
            objectOutputStream.writeUTF(this.given.getText());
            objectOutputStream.writeUTF(this.goal.getText());
            if (this.inProof) {
                objectOutputStream.writeObject(this.mainProofBox);
                objectOutputStream.writeObject(this.undoList);
                objectOutputStream.writeObject(this.redoList);
            }
            objectOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    public void undo() {
        if (this.undoList.size() > 0) {
            this.redoList.add(this.mainProofBox);
            this.mainProofBox = this.undoList.remove(this.undoList.size() - 1);
            this.reloadProofBox();
            if (this.lastRuleSelected != null) {
                this.deselectRule(this.lastRuleSelected);
            }
        } else {
            if (this.lastRuleSelected != null) {
                this.deselectRule(this.lastRuleSelected);
            }
            this.inputProofMode();
        }
    }

    public void redo() {
        if (this.redoList.size() > 0) {
            this.undoList.add(this.mainProofBox);
            this.mainProofBox = this.redoList.remove(this.redoList.size() - 1);
            this.reloadProofBox();
        } else {
            System.out.println("redo disabled");
        }
    }

    private void saveState() {
        ProofBox proofBox = new ProofBox(this);
        this.tempProofLines.removeAll(this.tempProofLines);
        this.mainProofBox.regenerate(proofBox, this);
        this.savedBox = proofBox;
    }

    public void commitSaveState() {
        this.undoList.add(this.savedBox);
        this.redoList.clear();
    }

    public void reloadProofBox() {
        this.storeVBar(this.boxScroll.getVerticalScrollBar().getValue());
        this.storeHBar(this.boxScroll.getHorizontalScrollBar().getValue());
        this.mainBoxDisplayer.removeAll();
        this.mainProofBox.recalculateLineNum(1);
        this.mainBoxDisplayer.add(this.mainProofBox.display());
        this.mainBoxDisplayer.validate();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProofWindow.this.boxScroll.getVerticalScrollBar().setValue(ProofWindow.this.getVBar());
                ProofWindow.this.boxScroll.getHorizontalScrollBar().setValue(ProofWindow.this.getHBar());
                ProofWindow.this.mainBoxDisplayer.validate();
                ProofWindow.this.mainBoxDisplayer.repaint();
            }
        });
    }

    public void setupMainProofBox() {
        this.mainProofBox.setDisplayBorder(false);
        this.mainBoxDisplayer = this.mainProofBox.display();
        this.boxScroll = new JScrollPane(this.mainBoxDisplayer);
        this.boxScroll.getVerticalScrollBar().setUnitIncrement(10);
        this.boxScroll.getHorizontalScrollBar().setUnitIncrement(10);
        this.proofArea.add(this.boxScroll);
        this.reloadProofBox();
        this.mainBoxDisplayer.repaint();
    }

    private void storeVBar(int n) {
        if (!this.tempVLock) {
            this.tempV = n;
            this.tempVLock = true;
        }
    }

    private int getVBar() {
        this.tempVLock = false;
        return this.tempV;
    }

    private void storeHBar(int n) {
        if (!this.tempHLock) {
            this.tempH = n;
            this.tempHLock = true;
        }
    }

    private int getHBar() {
        this.tempHLock = false;
        return this.tempH;
    }

    public void setLastSelectedLine(ProofLine proofLine) {
        if (!this.inRule) {
            if (this.lastSelectedLine != proofLine) {
                if (this.lastSelectedLine != null) {
                    this.lastSelectedLine.deselectLine();
                }
                this.lastSelectedLine = proofLine;
                this.processRule();
            }
        } else {
            try {
                this.inRule = this.ruleCtrl.lineSelected(proofLine);
            }
            catch (Exception exception) {
                String string = exception.toString();
                int n = string.length();
                string = string.substring(21, n);
                JOptionPane.showMessageDialog(this.view, string, "Error", 2);
                exception.printStackTrace();
                this.inRule = false;
            }
            if (!this.inRule) {
                this.finishedRule();
            }
        }
    }

    public void clearLastSelectedLine() {
        if (this.lastSelectedLine != null) {
            this.lastSelectedLine.deselectLineNoClear();
        }
        this.lastSelectedLine = null;
        System.out.println("in Line deselected");
    }

    public JButton getLastRuleSelected() {
        return this.lastRuleSelected;
    }

    private void setLastRuleSelected(JButton jButton) {
        if (this.lastRuleSelected != null) {
            this.deselectRule(this.lastRuleSelected);
        }
        this.lastRuleSelected = jButton;
        this.processRule();
    }

    public void clearLastRuleSelected() {
        if (this.getLastRuleSelected() != null) {
            this.lastRuleSelected.setUI(View.defaultButtonUI);
            this.lastRuleSelected.setBackground(View.defaultButtonBackground);
            this.lastRuleSelected = null;
            this.mainBoxDisplayer.validate();
            this.mainBoxDisplayer.repaint();
            System.out.println("in Rule deselected");
        }
    }

    public void selectRule(JButton jButton) {
        if (this.lastRuleSelected != jButton) {
            jButton.setBackground(Colour.selectedButton);
            this.setLastRuleSelected(jButton);
        } else if (this.rule.getText().equals("TM\u221a") || this.rule.getText().equals("TM")) {
            jButton.setBackground(Colour.selectedButton);
            this.setLastRuleSelected(jButton);
        }
    }

    public void deselectRule(JButton jButton) {
        if (this.getLastRuleSelected() == jButton) {
            this.clearLastRuleSelected();
            this.ruleCtrl = null;
        }
    }

    public void finishedRule() {
        this.ruleCtrl.exitRule();
        this.deselectRule(this.rule);
        this.ruleCtrl = null;
        this.inRule = false;
        this.clearLastRuleSelected();
        this.clearLastSelectedLine();
        this.mainProofBox.deselectAll();
        this.mainProofBox.cleanup();
        this.reloadProofBox();
    }

    private void processRule() {
        if (this.getLastRuleSelected() != null && this.lastSelectedLine != null) {
            this.ruleCtrl = new RuleController();
            this.ruleCtrl.addFirstLine(this.lastSelectedLine);
            try {
                this.ruleCtrl.addRule(this.getLastRuleSelected().getText());
                this.saveState();
                this.inRule = this.ruleCtrl.apply();
            }
            catch (Exception exception) {
                String string = exception.toString();
                int n = string.length();
                string = string.substring(21, n);
                JOptionPane.showMessageDialog(this.view, string, "Error", 0);
                exception.printStackTrace();
                if ((this.rule.getText().equals("TM\u221a") || this.rule.getText().equals("TM")) && !this.isDone()) {
                    this.hasError = true;
                    this.isDone = true;
                }
                this.inRule = false;
            }
            if (!this.inRule) {
                if (this.rule != null && (!this.rule.getText().equals("TM\u221a") && !this.rule.getText().equals("TM") || this.isDone())) {
                    this.finishedRule();
                    this.isTM = false;
                } else if (!this.isTM && this.isDone()) {
                    this.finishedRule();
                }
            }
        }
    }

    private boolean checkGiven() {
        int n = this.given.getDocument().getStartPosition().getOffset();
        int n2 = this.given.getDocument().getLength();
        try {
            return this.view.pandoraControl.checkInput(this.given.getDocument().getText(n, n2), this);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean checkGoal() {
        int n = this.goal.getDocument().getStartPosition().getOffset();
        int n2 = this.goal.getDocument().getLength();
        if (n2 > 0) {
            try {
                return this.view.pandoraControl.checkGoal(this.goal.getDocument().getText(n, n2), this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean parseGiven() {
        int n = this.given.getDocument().getStartPosition().getOffset();
        int n2 = this.given.getDocument().getLength();
        try {
            return this.view.pandoraControl.parseInput(this.given.getDocument().getText(n, n2), this);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean parseGoal() {
        int n = this.goal.getDocument().getStartPosition().getOffset();
        int n2 = this.goal.getDocument().getLength();
        try {
            return this.view.pandoraControl.parseGoal(this.goal.getDocument().getText(n, n2), this);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void displayAllSignature() {
        this.displayPredicate();
        this.displayConstant();
        this.displayFunction();
        this.displayVariable();
        this.displaySkolem();
    }

    private void displayPredicate() {
        this.clearDisplayPredicate();
        try {
            this.pred.getDocument().insertString(0, "Predicates:", this.pred.getStyledDocument().getStyle("bold"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<Atom> list = this.signature.getPredicates();
        ListIterator<Atom> listIterator = list.listIterator(0);
        while (listIterator.hasNext()) {
            Atom atom = listIterator.next();
            try {
                this.pred.getDocument().insertString(this.pred.getDocument().getLength(), "\n" + atom.getName() + " of arity " + atom.getArity(), null);
            }
            catch (Exception exception) {}
        }
    }

    private void clearDisplayPredicate() {
        try {
            this.pred.getDocument().remove(0, this.pred.getDocument().getLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addPredicate() {
        if (this.addPredTB == null) {
            this.addPredTB = new JToolBar("Add Predicate");
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.setBackground(Colour.artisticGreen);
            jPanel.add((Component)jPanel2, "North");
            this.addPredTBName = new JTextField("Pred Name");
            this.addPredTBName.setPreferredSize(new Dimension(100, 30));
            this.addPredTBName.setBackground(Colour.artisticGreen);
            this.addPredTBName.setToolTipText("Name of new Predicate");
            this.addPredTBName.addFocusListener(this);
            this.view.applyFont(this.addPredTBName, "medium");
            jPanel2.add(this.addPredTBName);
            this.addPredTBArity = new JTextField("Arity");
            this.addPredTBArity.setPreferredSize(new Dimension(40, 30));
            this.addPredTBArity.setBackground(Colour.artisticGreen);
            this.addPredTBArity.setToolTipText("Arity of new Predicate");
            this.addPredTBArity.addFocusListener(this);
            this.view.applyFont(this.addPredTBArity, "medium");
            jPanel2.add(this.addPredTBArity);
            JPanel jPanel3 = new JPanel(new FlowLayout(2, 0, 0));
            jPanel.add((Component)jPanel3, "Center");
            JButton jButton = new JButton("Add");
            jButton.setToolTipText("Add Predicate");
            jButton.addActionListener(this);
            jPanel3.add(jButton);
            JButton jButton2 = new JButton("Cancel");
            jButton2.setToolTipText("Cancel Add Predicate");
            jButton2.addActionListener(this);
            jPanel3.add(jButton2);
            this.addPredTB.add(jPanel);
            this.sidebar.add((Component)this.addPredTB, 0);
        }
    }

    private void displayConstant() {
        this.clearDisplayConstant();
        try {
            this.constant.getDocument().insertString(0, "Constants:", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<SimpleTerm> list = this.signature.getConstants();
        ListIterator<SimpleTerm> listIterator = list.listIterator(0);
        while (listIterator.hasNext()) {
            SimpleTerm simpleTerm = listIterator.next();
            try {
                this.constant.getDocument().insertString(this.constant.getDocument().getLength(), "\n" + simpleTerm.getName(), null);
            }
            catch (Exception exception) {}
        }
    }

    private void clearDisplayConstant() {
        try {
            this.constant.getDocument().remove(0, this.constant.getDocument().getLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addConstant() {
        if (this.addConstTB == null) {
            this.addConstTB = new JToolBar("Add Constant");
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.setBackground(Colour.artisticGreen);
            jPanel.add((Component)jPanel2, "North");
            this.addConstTBName = new JTextField("Const Name");
            this.addConstTBName.setPreferredSize(new Dimension(100, 30));
            this.addConstTBName.setBackground(Colour.artisticGreen);
            this.addConstTBName.setToolTipText("Name of new Constant");
            this.addConstTBName.addFocusListener(this);
            this.view.applyFont(this.addConstTBName, "medium");
            jPanel2.add(this.addConstTBName);
            JPanel jPanel3 = new JPanel(new FlowLayout(2, 0, 0));
            jPanel.add((Component)jPanel3, "Center");
            JButton jButton = new JButton("Add");
            jButton.setToolTipText("Add Constant");
            jButton.addActionListener(this);
            jPanel3.add(jButton);
            JButton jButton2 = new JButton("Cancel");
            jButton2.setToolTipText("Cancel Add Constant");
            jButton2.addActionListener(this);
            jPanel3.add(jButton2);
            this.addConstTB.add(jPanel);
            this.sidebar.add((Component)this.addConstTB, 0);
        }
    }

    private void displayFunction() {
        this.clearDisplayFunction();
        try {
            this.function.getDocument().insertString(0, "Functions:", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<Function> list = this.signature.getFunctions();
        ListIterator<Function> listIterator = list.listIterator(0);
        while (listIterator.hasNext()) {
            Function function = listIterator.next();
            try {
                this.function.getDocument().insertString(this.function.getDocument().getLength(), "\n" + function.getName() + " of arity " + function.getArity(), null);
            }
            catch (Exception exception) {}
        }
    }

    private void clearDisplayFunction() {
        try {
            this.function.getDocument().remove(0, this.function.getDocument().getLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addFunction() {
        if (this.addFuncTB == null) {
            this.addFuncTB = new JToolBar("Add Function");
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.setBackground(Colour.artisticGreen);
            jPanel.add((Component)jPanel2, "North");
            this.addFuncTBName = new JTextField("Func Name");
            this.addFuncTBName.setPreferredSize(new Dimension(100, 30));
            this.addFuncTBName.setBackground(Colour.artisticGreen);
            this.addFuncTBName.setToolTipText("Name of new Function");
            this.addFuncTBName.addFocusListener(this);
            this.view.applyFont(this.addFuncTBName, "medium");
            jPanel2.add(this.addFuncTBName);
            this.addFuncTBArity = new JTextField("Arity");
            this.addFuncTBArity.setPreferredSize(new Dimension(40, 30));
            this.addFuncTBArity.setBackground(Colour.artisticGreen);
            this.addFuncTBArity.setToolTipText("Arity of new Predicate");
            this.addFuncTBArity.addFocusListener(this);
            this.view.applyFont(this.addFuncTBArity, "medium");
            jPanel2.add(this.addFuncTBArity);
            JPanel jPanel3 = new JPanel(new FlowLayout(2, 0, 0));
            jPanel.add((Component)jPanel3, "Center");
            JButton jButton = new JButton("Add");
            jButton.setToolTipText("Add Function");
            jButton.addActionListener(this);
            jPanel3.add(jButton);
            JButton jButton2 = new JButton("Cancel");
            jButton2.setToolTipText("Cancel Add Function");
            jButton2.addActionListener(this);
            jPanel3.add(jButton2);
            this.addFuncTB.add(jPanel);
            this.sidebar.add((Component)this.addFuncTB, 0);
        }
    }

    private void displayVariable() {
        this.clearDisplayVariable();
        try {
            this.variable.getDocument().insertString(0, "Bound Variables:", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<Var> list = this.signature.getVariables();
        ListIterator<Var> listIterator = list.listIterator(0);
        while (listIterator.hasNext()) {
            Var var = listIterator.next();
            try {
                this.variable.getDocument().insertString(this.variable.getDocument().getLength(), "\n" + var.display(), null);
            }
            catch (Exception exception) {}
        }
    }

    private void clearDisplayVariable() {
        try {
            this.variable.getDocument().remove(0, this.variable.getDocument().getLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void displaySkolem() {
        this.clearDisplaySkolem();
        try {
            this.skolem.getDocument().insertString(0, "Skolem Constants:", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<SimpleTerm> list = this.signature.getSkolems();
        ListIterator<SimpleTerm> listIterator = list.listIterator(0);
        while (listIterator.hasNext()) {
            SimpleTerm simpleTerm = listIterator.next();
            try {
                this.skolem.getDocument().insertString(this.skolem.getDocument().getLength(), "\n" + simpleTerm.display(), null);
            }
            catch (Exception exception) {}
        }
    }

    private void clearDisplaySkolem() {
        try {
            this.skolem.getDocument().remove(0, this.skolem.getDocument().getLength());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeAllGiven() {
        int n = this.given.getDocument().getStartPosition().getOffset();
        int n2 = this.given.getDocument().getLength();
        try {
            this.given.getDocument().remove(n, n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeAllGoal() {
        int n = this.goal.getDocument().getStartPosition().getOffset();
        int n2 = this.goal.getDocument().getLength();
        try {
            this.goal.getDocument().remove(n, n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addToGiven(String string) {
        int n = this.given.getDocument().getLength();
        try {
            this.given.getDocument().insertString(n, string + "\n", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addToGoal(String string) {
        int n = this.goal.getDocument().getLength();
        try {
            this.goal.getDocument().insertString(n, string, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addLineToProof(Formula formula, String string) {
        if (string.equals("<goal>")) {
            ProofLine proofLine = new ProofLine(null, "", this, this.mainProofBox);
            this.mainProofBox.addItem(proofLine);
            ProofLine proofLine2 = new ProofLine(formula, string, this, this.mainProofBox);
            this.mainProofBox.addItem(proofLine2);
            this.setupMainProofBox();
        } else {
            ProofLine proofLine = new ProofLine(formula, string, this, this.mainProofBox);
            this.mainProofBox.addItem(proofLine);
        }
    }

    private JToolBar getPandoraProofToolbar() {
        JToolBar jToolBar = new JToolBar("Toolbox");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JButton jButton = null;
        this.func = new JPanel(new GridLayout(0, 2));
        jButton = new JButton(undoSymbol);
        jButton.setToolTipText("Undo");
        jButton.addActionListener(this);
        this.func.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton(redoSymbol);
        jButton.setToolTipText("Redo");
        jButton.addActionListener(this);
        this.func.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("Reset");
        jButton.setToolTipText("Reset");
        jButton.addActionListener(this);
        this.func.add(jButton);
        this.view.applyFont(jButton, "medium");
        this.ie = new JPanel(new GridLayout(0, 2));
        jButton = new JButton("\u2227I");
        jButton.addActionListener(this);
        this.ie.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("\u2227E");
        jButton.addActionListener(this);
        this.ie.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("\u2228I");
        jButton.addActionListener(this);
        this.ie.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("\u2228E");
        jButton.addActionListener(this);
        this.ie.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("\u2192I");
        jButton.addActionListener(this);
        this.ie.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("\u2192E");
        jButton.addActionListener(this);
        this.ie.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("\u00acI");
        jButton.addActionListener(this);
        this.ie.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("\u00acE");
        jButton.addActionListener(this);
        this.ie.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("\u22a5I");
        jButton.addActionListener(this);
        this.ie.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("\u22a5E");
        jButton.addActionListener(this);
        this.ie.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("\u00ac\u00ac");
        jButton.addActionListener(this);
        this.ie.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("\u22a4I");
        jButton.addActionListener(this);
        this.ie.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("\u2194I");
        jButton.addActionListener(this);
        this.ie.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("\u2194E");
        jButton.addActionListener(this);
        this.ie.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("\u2194I2");
        jButton.addActionListener(this);
        this.ie.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("\u2194E2");
        jButton.addActionListener(this);
        this.ie.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("EM");
        jButton.addActionListener(this);
        this.ie.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("PC");
        jButton.addActionListener(this);
        this.ie.add(jButton);
        this.view.applyFont(jButton, "medium");
        this.qie = new JPanel(new GridLayout(0, 2));
        jButton = new JButton("\u2203I");
        jButton.addActionListener(this);
        this.qie.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("\u2203E");
        jButton.addActionListener(this);
        this.qie.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("\u2200I");
        jButton.addActionListener(this);
        this.qie.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("\u2200E");
        jButton.addActionListener(this);
        this.qie.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("Reflexivity");
        jButton.addActionListener(this);
        this.qie.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("=Sub");
        jButton.addActionListener(this);
        this.qie.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("\u2200\u2192E");
        jButton.addActionListener(this);
        this.qie.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("\u2200\u2192I");
        jButton.addActionListener(this);
        this.qie.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("\u2200E\u221a");
        jButton.addActionListener(this);
        this.qie.add(jButton);
        this.view.applyFont(jButton, "medium");
        this.eb = new JPanel(new GridLayout(0, 2));
        jButton = new JButton("\u221a");
        jButton.addActionListener(this);
        this.eb.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("Lemma");
        jButton.addActionListener(this);
        this.eb.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("TM\u221a");
        jButton.addActionListener(this);
        this.eb.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("TM");
        jButton.addActionListener(this);
        this.eb.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton = new JButton("Done");
        jButton.addActionListener(this);
        this.eb.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton.setEnabled(false);
        jButton.setVisible(false);
        jButton = new JButton("Cancel");
        jButton.addActionListener(this);
        this.eb.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton.setEnabled(false);
        jButton.setVisible(false);
        jButton = new JButton("Help");
        jButton.addActionListener(this);
        this.eb.add(jButton);
        this.view.applyFont(jButton, "medium");
        jButton.setEnabled(false);
        jButton.setVisible(false);
        jPanel.add(this.func);
        jPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        jPanel.add(this.ie);
        jPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        jPanel.add(this.qie);
        jPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        jPanel.add(this.eb);
        jToolBar.add(jPanel);
        jToolBar.setFloatable(true);
        return jToolBar;
    }

    public void showSignature() {
        this.sidebar.add(this.predicateToolbar());
        this.sidebar.add(this.constantToolbar());
        this.sidebar.add(this.functionToolbar());
        this.sidebar.add(this.variableToolbar());
        this.sidebar.add(this.skolemToolbar());
    }

    public void showGlobalSignature() {
        this.signature = this.mainProofBox.getSignature();
        this.displayAllSignature();
    }

    public void showLocalSignature(PanSignature panSignature) {
        this.signature = panSignature;
        this.displayAllSignature();
    }

    private JToolBar signatureToolbar() {
        this.sigToolbar = new JToolBar("Signature");
        this.sigToolbar.setLayout(new BoxLayout(this.sigToolbar, 3));
        this.signatureToolbarContent();
        return this.sigToolbar;
    }

    private void signatureToolbarContent() {
        this.sigToolbar.removeAll();
        JButton jButton = null;
        if (this.sigShow) {
            jButton = new JButton("Hide Signature");
            JPanel jPanel = new JPanel();
            jPanel.setBackground(Colour.white);
            jPanel.add(jButton);
            this.sigToolbar.add(jPanel);
            this.pred = new JTextPane();
            this.pred.setEditable(false);
            this.sigToolbar.add(this.pred);
            this.view.applyFont(this.pred, "medium");
            this.displayPredicate();
            this.constant = new JTextPane();
            this.constant.setEditable(false);
            this.sigToolbar.add(this.constant);
            this.view.applyFont(this.constant, "medium");
            this.displayConstant();
            this.function = new JTextPane();
            this.function.setEditable(false);
            this.sigToolbar.add(this.function);
            this.view.applyFont(this.function, "medium");
            this.displayFunction();
            this.variable = new JTextPane();
            this.variable.setEditable(false);
            this.sigToolbar.add(this.variable);
            this.view.applyFont(this.variable, "medium");
            this.displayVariable();
            this.skolem = new JTextPane();
            this.skolem.setEditable(false);
            this.sigToolbar.add(this.skolem);
            this.view.applyFont(this.skolem, "medium");
            this.displaySkolem();
        } else {
            jButton = new JButton("Show Signature");
            JPanel jPanel = new JPanel();
            jPanel.setBackground(Colour.white);
            jPanel.add(jButton);
            this.sigToolbar.add(jPanel);
        }
        jButton.addActionListener(this);
        jButton.setBackground(Colour.white);
        jButton.setForeground(Colour.lightGreen);
        jButton.setBorder(BorderFactory.createLineBorder(Colour.lightGreen, 2));
        this.view.applyFont(jButton, "medium");
    }

    private JToolBar predicateToolbar() {
        JToolBar jToolBar = new JToolBar("Predicates");
        this.pred = new JTextPane();
        this.pred.setEditable(false);
        jToolBar.add(this.pred);
        this.view.applyFont(this.pred, "medium");
        this.displayPredicate();
        return jToolBar;
    }

    private JToolBar constantToolbar() {
        JToolBar jToolBar = new JToolBar("Constants");
        this.constant = new JTextPane();
        this.constant.setEditable(false);
        jToolBar.add(this.constant);
        this.view.applyFont(this.constant, "medium");
        this.displayConstant();
        return jToolBar;
    }

    private JToolBar functionToolbar() {
        JToolBar jToolBar = new JToolBar("Functions");
        this.function = new JTextPane();
        this.function.setEditable(false);
        jToolBar.add(this.function);
        this.view.applyFont(this.function, "medium");
        this.displayFunction();
        return jToolBar;
    }

    private JToolBar variableToolbar() {
        JToolBar jToolBar = new JToolBar("Variables");
        this.variable = new JTextPane();
        this.variable.setEditable(false);
        jToolBar.add(this.variable);
        this.view.applyFont(this.variable, "medium");
        this.displayVariable();
        return jToolBar;
    }

    private JToolBar skolemToolbar() {
        JToolBar jToolBar = new JToolBar("Skolems");
        this.skolem = new JTextPane();
        this.skolem.setEditable(false);
        jToolBar.add(this.skolem);
        this.view.applyFont(this.skolem, "medium");
        this.displaySkolem();
        return jToolBar;
    }

    public void disableButtons() {
        int n;
        int n2 = this.eb.getComponentCount();
        for (n = 0; n < n2 - 2; ++n) {
            this.eb.getComponent(n).setEnabled(false);
        }
        this.eb.getComponent(n2 - 1).setEnabled(true);
        this.eb.getComponent(n2 - 1).setVisible(true);
        this.eb.getComponent(n2 - 2).setEnabled(true);
        this.eb.getComponent(n2 - 2).setVisible(true);
        this.eb.getComponent(n2 - 3).setEnabled(true);
        this.eb.getComponent(n2 - 3).setVisible(true);
        n2 = this.func.getComponentCount();
        for (n = 0; n < n2; ++n) {
            this.func.getComponent(n).setEnabled(false);
        }
        n2 = this.ie.getComponentCount();
        for (n = 0; n < n2; ++n) {
            this.ie.getComponent(n).setEnabled(false);
        }
        n2 = this.qie.getComponentCount();
        for (n = 0; n < n2; ++n) {
            this.qie.getComponent(n).setEnabled(false);
        }
    }

    public void enableButtons() {
        int n;
        int n2 = this.eb.getComponentCount();
        for (n = 0; n < n2 - 2; ++n) {
            this.eb.getComponent(n).setEnabled(true);
        }
        this.eb.getComponent(n2 - 1).setEnabled(false);
        this.eb.getComponent(n2 - 1).setVisible(false);
        this.eb.getComponent(n2 - 2).setEnabled(false);
        this.eb.getComponent(n2 - 2).setVisible(false);
        this.eb.getComponent(n2 - 3).setEnabled(false);
        this.eb.getComponent(n2 - 3).setVisible(false);
        n2 = this.func.getComponentCount();
        for (n = 0; n < n2; ++n) {
            this.func.getComponent(n).setEnabled(true);
        }
        n2 = this.ie.getComponentCount();
        for (n = 0; n < n2; ++n) {
            this.ie.getComponent(n).setEnabled(true);
        }
        n2 = this.qie.getComponentCount();
        for (n = 0; n < n2; ++n) {
            this.qie.getComponent(n).setEnabled(true);
        }
    }

    public boolean isDone() {
        return this.isDone;
    }

    public ProofBox getProofBox() {
        return this.mainProofBox;
    }
}

