/*
 * Decompiled with CFR 0.152.
 */
package Pandora;

import Pandora.NDRuleController;
import Pandora.ProofBox;
import Pandora.ProofItem;
import Pandora.ProofLine;
import java.util.List;

public class RuleController {
    private ProofLine currentLine = null;
    private ProofBox proof;
    private boolean initialisedRule = false;
    private NDRuleController nrc = null;

    public void addRule(String string) {
        ProofLine proofLine = this.currentLine;
        this.nrc = new NDRuleController(string, proofLine, this.proof);
    }

    public void exitRule() {
        this.nrc = null;
        this.currentLine = null;
        this.initialisedRule = false;
    }

    public void addFirstLine(ProofLine proofLine) {
        this.currentLine = proofLine;
        this.proof = proofLine.getParentBox();
    }

    public boolean apply() throws Exception {
        if (!this.initialisedRule) {
            try {
                this.nrc.initialise();
                this.initialisedRule = true;
            }
            catch (Exception exception) {
                this.exitRule();
                System.out.println(exception);
                throw exception;
            }
        }
        if (this.nrc.haveAll()) {
            try {
                this.nrc.apply();
            }
            catch (Exception exception) {
                this.exitRule();
                System.out.println(exception);
                throw exception;
            }
        }
        boolean bl = !this.nrc.haveAll();
        return bl;
    }

    public boolean lineSelected(ProofLine proofLine) throws Exception {
        boolean bl = true;
        try {
            if (!this.inScope(proofLine)) {
                throw new Exception("The selected line is not in scope.");
            }
            this.nrc.addLine(proofLine);
            bl = this.apply();
        }
        catch (Exception exception) {
            this.exitRule();
            System.out.println(exception);
            throw exception;
        }
        return bl;
    }

    private boolean inScope(ProofLine proofLine) {
        List<ProofItem> list = this.proof.getProofItems();
        boolean bl = list.subList(0, list.indexOf(this.currentLine)).contains(proofLine);
        ProofBox proofBox = this.proof.getParentBox();
        ProofBox proofBox2 = this.proof;
        boolean bl2 = false;
        if (!bl) {
            while (proofBox != null && !bl2) {
                while (proofBox2.getOlderSiblingBox() != null) {
                    proofBox2 = proofBox2.getOlderSiblingBox();
                }
                List<ProofItem> list2 = proofBox.getProofItems();
                bl2 = list2.subList(0, list2.indexOf(proofBox2)).contains(proofLine);
                proofBox2 = proofBox;
                proofBox = proofBox2.getParentBox();
            }
        }
        return bl || bl2;
    }
}

