/*
 * Decompiled with CFR 0.152.
 */
package Pandora;

import Pandora.Help.Help;
import Pandora.ParseInputController;
import Pandora.ProofWindow;
import Pandora.xGui.Colour;
import Pandora.xGui.PandoraFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ButtonUI;

public class View
extends JFrame
implements ActionListener,
MouseListener {
    public static final long serialVersionUID = 1L;
    static final ButtonUI defaultButtonUI = new JButton().getUI();
    static final Color defaultButtonBackground = new JButton().getBackground();
    ParseInputController pandoraControl;
    static JFileChooser fileChooser = new JFileChooser();
    JTabbedPane theTabs = new JTabbedPane(1, 1);
    int originalSize;
    int currentSize = this.originalSize = 28;
    int currentStyle = 0;
    String currentFontFace = "Dialog.plain";
    public static boolean showBrackets = false;

    public View(ParseInputController parseInputController) {
        this.setTitle("Pandora IV");
        this.pandoraControl = parseInputController;
        fileChooser.addChoosableFileFilter(new PandoraFileFilter());
        JPanel jPanel = new JPanel(new BorderLayout());
        this.add(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, "First");
        JMenuBar jMenuBar = this.getPandoraMenuBar();
        jPanel2.add((Component)jMenuBar, "North");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel3, "Center");
        jPanel3.add(this.theTabs);
        this.theTabs.addMouseListener(this);
        Double d = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        Double d2 = Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 100.0;
        this.setSize(d.intValue(), d2.intValue() * 96);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                View.this.exitPandora();
            }
        });
        this.setVisible(true);
        try {
            this.pandoraWelcome();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void exitPandora() {
        int n = JOptionPane.showConfirmDialog(null, "Are you sure you want to exit? \n Note: you will be prompted to save all your open proofs; \n press cancel for any you don't want to save.", "Exit Pandora", 0);
        if (n == 0) {
            for (int i = this.theTabs.getTabCount(); i > 1; --i) {
                this.saveProof();
                this.removeProofWindow();
            }
            System.exit(0);
        }
    }

    private void saveProof() {
        int n = fileChooser.showSaveDialog(null);
        if (0 == n) {
            int n2;
            ProofWindow proofWindow = (ProofWindow)this.theTabs.getSelectedComponent();
            File file = fileChooser.getSelectedFile();
            String string = file.getPath();
            boolean bl = true;
            if (file.exists() && (n2 = JOptionPane.showConfirmDialog(this, "This file already exists, would you like to overwrite it?", "Confirm Delete", 0)) == 1) {
                bl = false;
            }
            if (bl) {
                if (string.endsWith(".pan")) {
                    proofWindow.saveProof(string);
                } else {
                    string = string + "." + "pan";
                    proofWindow.saveProof(string);
                }
                this.theTabs.setTitleAt(this.theTabs.getSelectedIndex(), this.createTabTitle(file.getName()));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        String string = null;
        String string2 = null;
        if (actionEvent.getSource() instanceof JButton) {
            object = (JButton)actionEvent.getSource();
            string = ((AbstractButton)object).getText();
            string2 = ((JComponent)object).getToolTipText();
        } else if (actionEvent.getSource() instanceof JMenuItem) {
            object = (JMenuItem)actionEvent.getSource();
            string = ((AbstractButton)object).getText();
            string2 = ((JComponent)object).getToolTipText();
        }
        String string3 = string2 == null ? string : string2;
        if (string3.equals("New Proof") || string3.equals("New")) {
            this.addProofWindow();
        } else if (string3.equals("Open")) {
            int n = fileChooser.showOpenDialog(null);
            if (0 == n) {
                File file = fileChooser.getSelectedFile();
                this.addProofWindow(file.getName());
                ProofWindow proofWindow = (ProofWindow)this.theTabs.getSelectedComponent();
                proofWindow.openProof(file.getPath());
                if (!proofWindow.redoList.isEmpty()) {
                    proofWindow.redo();
                }
            }
        } else if (string3.equals("Save")) {
            this.saveProof();
        } else if (string3.equals("Close")) {
            object = new Object[]{"Save", "Don't Save"};
            int n = JOptionPane.showOptionDialog(null, "Do you wish to save your proof?", "Save", 0, 3, null, (Object[])object, object[0]);
            if (n == 0) {
                this.saveProof();
                this.removeProofWindow();
            } else if (n == 1) {
                this.removeProofWindow();
            }
        } else if (string3.equals("Exit")) {
            this.exitPandora();
        } else if (string3.equals("Undo")) {
            object = (ProofWindow)this.theTabs.getSelectedComponent();
            ((ProofWindow)object).undo();
        } else if (string3.equals("Redo")) {
            object = (ProofWindow)this.theTabs.getSelectedComponent();
            ((ProofWindow)object).redo();
        } else if (string3.equals("Reset")) {
            object = (ProofWindow)this.theTabs.getSelectedComponent();
            if (((ProofWindow)object).ruleCtrl != null) {
                ((ProofWindow)object).finishedRule();
            } else {
                ((ProofWindow)object).getProofBox().deselectAll();
                ((ProofWindow)object).mainProofBox.cleanup();
                ((ProofWindow)object).reloadProofBox();
            }
        } else if (string3.equals("Huge")) {
            this.resetFontSize();
            this.changeFontSize(20);
        } else if (string3.equals("Large")) {
            this.resetFontSize();
            this.changeFontSize(10);
        } else if (string3.equals("Normal")) {
            this.resetFontSize();
        } else if (string3.equals("Small")) {
            this.resetFontSize();
            this.changeFontSize(-5);
        } else if (string3.equals("Tiny")) {
            this.resetFontSize();
            this.changeFontSize(-12);
        } else if (string3.equals("Increase")) {
            this.changeFontSize(5);
        } else if (string3.equals("Decrease")) {
            this.changeFontSize(-5);
        } else if (string3.equals("Global Signature")) {
            object = (ProofWindow)this.theTabs.getSelectedComponent();
            ((ProofWindow)object).showGlobalSignature();
        } else if (string3.equals("Input Proof Mode")) {
            object = (ProofWindow)this.theTabs.getSelectedComponent();
            ((ProofWindow)object).inputProofMode();
        } else if (string3.equals("Solve Proof Mode")) {
            object = (ProofWindow)this.theTabs.getSelectedComponent();
            ((ProofWindow)object).actionPerformed(actionEvent);
        } else if (string3.equals("Show Minimal Brackets")) {
            showBrackets = false;
            object = (JMenuItem)actionEvent.getSource();
            ((AbstractButton)object).setText("Show All Brackets");
            for (int i = 1; i < this.theTabs.getTabCount(); ++i) {
                ProofWindow proofWindow = (ProofWindow)this.theTabs.getComponentAt(i);
                proofWindow.reloadProofBox();
            }
        } else if (string3.equals("Show All Brackets")) {
            showBrackets = true;
            object = (JMenuItem)actionEvent.getSource();
            ((AbstractButton)object).setText("Show Minimal Brackets");
            for (int i = 1; i < this.theTabs.getTabCount(); ++i) {
                ProofWindow proofWindow = (ProofWindow)this.theTabs.getComponentAt(i);
                proofWindow.reloadProofBox();
            }
        } else if (string3.equals("Predicate")) {
            object = (ProofWindow)this.theTabs.getSelectedComponent();
            if (((ProofWindow)object).inProof) {
                ((ProofWindow)object).addPredicate();
            }
        } else if (string3.equals("Constant")) {
            object = (ProofWindow)this.theTabs.getSelectedComponent();
            if (((ProofWindow)object).inProof) {
                ((ProofWindow)object).addConstant();
            }
        } else if (string3.equals("Function")) {
            object = (ProofWindow)this.theTabs.getSelectedComponent();
            if (((ProofWindow)object).inProof) {
                ((ProofWindow)object).addFunction();
            }
        } else if (string3.equals("Check Proof")) {
            object = (ProofWindow)this.theTabs.getSelectedComponent();
            if (!((ProofWindow)object).inProof) {
                ((ProofWindow)object).actionPerformed(actionEvent);
            }
        } else if (string3.equals("Start Proof")) {
            object = (ProofWindow)this.theTabs.getSelectedComponent();
            if (!((ProofWindow)object).inProof) {
                ((ProofWindow)object).actionPerformed(actionEvent);
            }
        } else if (string3.equals("Manual")) {
            new Help();
        } else if (string3.equals("About")) {
            object = new JFrame("About");
            JEditorPane jEditorPane = new JEditorPane();
            jEditorPane.setEditable(false);
            URL uRL = View.class.getResource("/about.html");
            try {
                jEditorPane.setPage(uRL);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
            ((Frame)object).setBackground(Color.WHITE);
            ((Container)object).add(jEditorPane);
            ((Window)object).pack();
            ((Window)object).setSize(230, 420);
            ((Window)object).setVisible(true);
        } else if (string3.equals("Example Proofs")) {
            object = new Object[]{"Propositional Example", "Predicate Example"};
            int n = JOptionPane.showOptionDialog(null, "Choose your example proof", "Example Proofs", 0, 1, null, (Object[])object, object[0]);
            if (n == 0) {
                JFrame jFrame = new JFrame("Propositional Logic Proof");
                JEditorPane jEditorPane = new JEditorPane();
                JScrollPane jScrollPane = new JScrollPane(jEditorPane, 22, 32);
                jEditorPane.setEditable(false);
                jEditorPane.setBackground(Color.WHITE);
                URL uRL = View.class.getResource("/html/example_proof-1.html");
                try {
                    jEditorPane.setPage(uRL);
                }
                catch (Exception exception) {
                    System.err.println("Attempted to read a bad URL: " + exception);
                }
                jFrame.setBackground(Color.WHITE);
                jFrame.add(jScrollPane);
                jFrame.pack();
                jFrame.setSize(630, 600);
                jFrame.setVisible(true);
            } else if (n == 1) {
                JFrame jFrame = new JFrame("Predicate Logic Proof");
                JEditorPane jEditorPane = new JEditorPane();
                JScrollPane jScrollPane = new JScrollPane(jEditorPane, 22, 32);
                jEditorPane.setEditable(false);
                jEditorPane.setBackground(Color.WHITE);
                URL uRL = View.class.getResource("/html/example_proof-2.html");
                try {
                    jEditorPane.setPage(uRL);
                }
                catch (Exception exception) {
                    System.err.println("Attempted to read a bad URL: " + exception);
                }
                jFrame.setBackground(Color.WHITE);
                jFrame.add(jScrollPane);
                jFrame.pack();
                jFrame.setSize(630, 600);
                jFrame.setVisible(true);
            }
        } else if (string3.equals("Forwards and Backwards Rules")) {
            object = new JFrame("Forwards and Backwards Rules");
            JEditorPane jEditorPane = new JEditorPane();
            JScrollPane jScrollPane = new JScrollPane(jEditorPane, 22, 32);
            jEditorPane.setEditable(false);
            jEditorPane.setBackground(Color.WHITE);
            URL uRL = View.class.getResource("/help/Rules/forwards_backwards_rules.html");
            try {
                jEditorPane.setPage(uRL);
            }
            catch (Exception exception) {
                System.err.println("Attempted to read a bad URL: " + exception);
            }
            ((Frame)object).setBackground(Color.WHITE);
            ((Container)object).add(jScrollPane);
            ((Window)object).pack();
            ((Window)object).setSize(620, 600);
            ((Window)object).setVisible(true);
        } else if (string3.equals("How do I start?")) {
            object = new JFrame("How do I start?");
            JEditorPane jEditorPane = new JEditorPane();
            JScrollPane jScrollPane = new JScrollPane(jEditorPane, 22, 32);
            jEditorPane.setEditable(false);
            jEditorPane.setBackground(Color.WHITE);
            URL uRL = View.class.getResource("/html/How_do_i_start.html");
            try {
                jEditorPane.setPage(uRL);
            }
            catch (Exception exception) {
                System.err.println("Attempted to read a bad URL: " + exception);
            }
            ((Frame)object).setBackground(Color.WHITE);
            ((Container)object).add(jScrollPane);
            ((Window)object).pack();
            ((Window)object).setSize(625, 600);
            ((Window)object).setVisible(true);
        } else if (string3.equals("Heuristic Hints")) {
            object = new JFrame("Heuristic Hints");
            JEditorPane jEditorPane = new JEditorPane();
            JScrollPane jScrollPane = new JScrollPane(jEditorPane, 22, 32);
            jEditorPane.setEditable(false);
            jEditorPane.setBackground(Color.WHITE);
            URL uRL = View.class.getResource("/html/Heuristic_Hints.html");
            try {
                jEditorPane.setPage(uRL);
            }
            catch (Exception exception) {
                System.err.println("Attempted to read a bad URL: " + exception);
            }
            ((Frame)object).setBackground(Color.WHITE);
            ((Container)object).add(jScrollPane);
            ((Window)object).pack();
            ((Window)object).setSize(1025, 1000);
            ((Window)object).setVisible(true);
        } else if (string3.equals("Panic Situations")) {
            object = new JFrame("Panic Situations");
            JEditorPane jEditorPane = new JEditorPane();
            JScrollPane jScrollPane = new JScrollPane(jEditorPane, 22, 32);
            jEditorPane.setEditable(false);
            jEditorPane.setBackground(Color.WHITE);
            URL uRL = View.class.getResource("/html/Panic_Situations.html");
            try {
                jEditorPane.setPage(uRL);
            }
            catch (Exception exception) {
                System.err.println("Attempted to read a bad URL: " + exception);
            }
            ((Frame)object).setBackground(Color.WHITE);
            ((Container)object).add(jScrollPane);
            ((Window)object).pack();
            ((Window)object).setSize(650, 350);
            ((Window)object).setVisible(true);
        } else if (string3.equals("Known Problems")) {
            object = new JFrame("Known Problems");
            JEditorPane jEditorPane = new JEditorPane();
            JScrollPane jScrollPane = new JScrollPane(jEditorPane, 22, 32);
            jEditorPane.setEditable(false);
            jEditorPane.setBackground(Color.WHITE);
            URL uRL = View.class.getResource("/html/Known_Problems.html");
            try {
                jEditorPane.setPage(uRL);
            }
            catch (Exception exception) {
                System.err.println("Attempted to read a bad URL: " + exception);
            }
            ((Frame)object).setBackground(Color.WHITE);
            ((Container)object).add(jScrollPane);
            ((Window)object).pack();
            ((Window)object).setSize(650, 500);
            ((Window)object).setVisible(true);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() > 1) {
            this.addProofWindow("Proof_" + this.theTabs.getTabCount());
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void addProofWindow() {
        this.theTabs.addTab(this.createTabTitle("Proof_" + this.theTabs.getTabCount()), new ProofWindow(this));
        this.theTabs.setSelectedIndex(this.theTabs.getTabCount() - 1);
    }

    public void addProofWindow(String string) {
        this.theTabs.addTab(this.createTabTitle(string), new ProofWindow(this));
        this.theTabs.setSelectedIndex(this.theTabs.getTabCount() - 1);
    }

    public void removeProofWindow() {
        if (this.theTabs.getSelectedIndex() > 0) {
            this.theTabs.remove(this.theTabs.getSelectedIndex());
        }
    }

    private String createTabTitle(String string) {
        String string2 = "<html>";
        string2 = string2 + "<div style=\"margin: 4px 0px 2px 0px\">";
        string2 = string2 + string;
        string2 = string2 + "</div>";
        string2 = string2 + "</html>";
        return string2;
    }

    private void pandoraWelcome() throws Exception {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.WHITE);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel(new FlowLayout(1, 20, 0));
        JButton jButton = null;
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        jEditorPane.setBackground(Color.WHITE);
        URL uRL = View.class.getResource("/html/welcomePage.html");
        if (uRL != null) {
            try {
                jEditorPane.setPage(uRL);
            }
            catch (IOException iOException) {
                System.err.println("Attempted to read a bad URL: " + uRL);
            }
        } else {
            System.err.println("Couldn't find file: welcomePage.html");
        }
        jPanel2.setBackground(Color.WHITE);
        jPanel2.add(jEditorPane);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.2;
        jPanel.add((Component)jEditorPane, gridBagConstraints);
        jButton = new JButton(this.welcomeButton("How<br>Do I<br>Start?"));
        jButton.setToolTipText("How do I start?");
        jButton.addActionListener(this);
        jButton.setBackground(Colour.white);
        jButton.setBorder(BorderFactory.createLineBorder(Colour.borderBlue, 10));
        jPanel3.add(jButton);
        jButton = new JButton(this.welcomeButton("Start<br>New<br>Proof"));
        jButton.setToolTipText("New");
        jButton.addActionListener(this);
        jButton.setBackground(Colour.white);
        jButton.setBorder(BorderFactory.createLineBorder(Colour.borderBlue, 10));
        jPanel3.add(jButton);
        jButton = new JButton(this.welcomeButton("Open<br>Existing<br>Proof"));
        jButton.setToolTipText("Open");
        jButton.addActionListener(this);
        jButton.setBackground(Colour.white);
        jButton.setBorder(BorderFactory.createLineBorder(Colour.borderBlue, 10));
        jPanel3.add(jButton);
        jButton = new JButton(this.welcomeButton("Get<br>Pandora<br>Help"));
        jButton.setToolTipText("Manual");
        jButton.addActionListener(this);
        jButton.setBackground(Colour.white);
        jButton.setBorder(BorderFactory.createLineBorder(Colour.borderBlue, 10));
        jPanel3.add(jButton);
        jButton = new JButton(this.welcomeButton("Some<br>Example<br>Proofs"));
        jButton.setToolTipText("Example Proofs");
        jButton.addActionListener(this);
        jButton.setBackground(Colour.white);
        jButton.setBorder(BorderFactory.createLineBorder(Colour.borderBlue, 10));
        jPanel3.add(jButton);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.8;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        jPanel.setBackground(Colour.white);
        jPanel3.setBackground(Colour.seeThrough);
        this.theTabs.addTab(this.createTabTitle("Welcome"), jPanel);
    }

    private String welcomeButton(String string) {
        String string2 = "<html>";
        string2 = string2 + "<div style=\"height:110px; width:110px;\">";
        string2 = string2 + "<br><h1 style=\"text-align:center\">" + string + "</h1>";
        string2 = string2 + "</div>";
        string2 = string2 + "</html>";
        return string2;
    }

    private JMenuBar getPandoraMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("New");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Open");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Close");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Exit");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu = new JMenu("Edit");
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("Undo");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Redo");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, 3));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Reset");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu = new JMenu("View");
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("Text Size");
        jMenu.add(jMenu2);
        jMenuItem = new JMenuItem("Huge");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(119, 0));
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Large");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(118, 0));
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Normal");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(106, 2));
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Small");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Tiny");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenu2.addSeparator();
        jMenuItem = new JMenuItem("Increase");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(107, 2));
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Decrease");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(109, 2));
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Input Proof Mode");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(155, 0));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Solve Proof Mode");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(155, 1));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        if (showBrackets) {
            jMenuItem = new JMenuItem("Show Minimal Brackets");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
        } else {
            jMenuItem = new JMenuItem("Show All Brackets");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
        }
        jMenu = new JMenu("Options");
        jMenuBar.add(jMenu);
        jMenu2 = new JMenu("Add to Signature");
        jMenu.add(jMenu2);
        jMenuItem = new JMenuItem("Predicate");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Constant");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Function");
        jMenuItem.addActionListener(this);
        jMenu2.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Check Proof");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(32, 3));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Start Proof");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(32, 2));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu = new JMenu("Help");
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("How do I start?");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Panic Situations");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Heuristic Hints");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Forwards and Backwards Rules");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Manual");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Known Problems");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("About");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        return jMenuBar;
    }

    public void resetFontSize() {
        this.currentSize = this.originalSize;
        this.changeFontSize(0);
    }

    public void changeFontSize(int n) {
        this.currentSize += n;
        for (int i = 1; i < this.theTabs.getTabCount(); ++i) {
            ProofWindow proofWindow = (ProofWindow)this.theTabs.getComponentAt(i);
            if (!proofWindow.inProof) {
                proofWindow.inputProofMode();
                continue;
            }
            proofWindow.solveProofMode();
            proofWindow.setupMainProofBox();
            proofWindow.reloadProofBox();
        }
    }

    public void applyFont(JComponent jComponent, String string) {
        int n = this.currentStyle;
        Double d = (double)this.currentSize * 1.0;
        if (string.equals("medium")) {
            d = d * 0.6;
        }
        if (jComponent instanceof JButton) {
            n = 1;
            d = d * 0.8;
        }
        jComponent.setFont(new Font(this.currentFontFace, n, d.intValue()));
    }
}

