# CONFIGURATION PARAMETERS
MAX_LEVEL = -1                          # the maximum level to go to, with 
                                        # level 0 indicating only crawling
                                        # the given page
                                        
OWNER_CONFIG_FILENAME = "owners.cwl"    # the location where the owner
                                        # configuration file resides
                                        
SAFE_LINK_FILENAME = "safe_pages.cwl"   # the location where the file 
                                        # declaring which links are safe 
                                        # resides
                                        
EXTRA_PREF_FILENAME = "extra.cwl"       # the file containing any additional
                                        # prefixes of pages that should be 
                                        # included in the check if stumbled
                                        # upon 
                                        
FEEDBACK_MODE = 2                       # initialise to default value, is
                                        # defined in crawler.py during its
                                        # initialisation stage
                                        
SMTP_SERVER = "smarthost.cc.ic.ac.uk"   # SMTP server to be used for sending
                                        # feedback mails
                                        
SMTP_FROM = "doc-wmproject2013_u@imperial.ac.uk"     # person from which automated mails 
                                        # are sent

CONTACT_MAIL = "doc-wmproject2013_u@imperial.ac.uk"
                                        # e-mail address contained within the
                                        # sent mail for any bugs or issues
                                        # identified
                                        
MOCK_PAGE_LOC = "http://www.doc.ic.ac.uk/project/2012/wmproject2013/Crawler/Crawler/mocking"
                                        # location of the web page that 
                                        # contains mocked pages for a specific
                                        # user, requiring that users e-mail
                                        # to be added to the end

PAGE_LOG = "pagesChecked.log"	   	# name of the file where to store
					# a log of checked pages for 
					# debugging

import datetime
LOG_FOLDER = "Logs"                                      
FEEDBACK_WRITE_FILENAME = "%s/crawl%sResult.log" % (LOG_FOLDER, datetime.datetime.now().strftime("%y%m%d%H%M%S"))
                                        # the name of the file in which to
                                        # write feedback

LOG_FILE = "%s/crawl%sLog.log" % (LOG_FOLDER, datetime.datetime.now().strftime("%y%m%d%H%M%S"))

LOG_ERROR_FILE = "%s/crawl%sErrors.log" % (LOG_FOLDER, datetime.datetime.now().strftime("%y%m%d%H%M%S"))

#---------------------------------------------------------------------------#
# CONSTANT DECLARATIONS

# Mode declarations for feedback detail levels
MODE_STRICT = 1
MODE_SERVER_VERIFIED = 2
MODE_COMPLETE = 3
