<?php
include "query_functions.php";
include "html_functions.php";

function write_main_content($file, $query, $selective, $h1, $p, $years_for_degree){

  $courses_year = get_courses_for_each_year($query);
  $min_max = get_min_max_for_selectives($selective);
  
#######################################################
  maincontent_div($file);

  span_inplace($file);

  fwrite($file, '<div id="doc_info">');

  fwrite($file, $h1);
  fwrite($file, '<p>' . $p . '</p>');

  $year = 0;
  $years_in_table = 4;
  while ($year < $years_in_table){

    if ($year % 2 == 0){
      ug_wrapper($file);
    }
    class_col($file);
    $yr = $year + 1;
    if ($year < $years_for_degree)
      fwrite($file, '<h2>Year '. $yr . '</h2>');
    $required = get_types_of_courses($courses_year[$year]);
    if (!empty($required[0])){
      fwrite($file, '<h3>Compulsory</h3>');
      write_courses($file, $required[0]);
    }
    ##############################
    if (!empty($required[1])){
      $selectives = divide_selective($required[1]);
      get_types_of_selectives($file, $selectives, $min_max[$year], 'Selective');
    }
    ##############################
    if (!empty($required[2])){
      $selectives = divide_selective($required[2]);
      get_types_of_selectives($file, $selectives, $min_max[$year], 'Optional');
    }  
    if (!empty($required[3])){
      fwrite($file, '<h3>Extracurricular</h3>');
      write_courses($file, $required[3]);
    }

    close_div($file);

    if ($year % 2 == 1){
      fwrite($file, '<div class="clear"></div>');
      close_div($file);
      close_div($file);
    }
    $year++;
  }

  close_div($file);

  fwrite($file, '<hr />');
  date_default_timezone_set('Europe/London'); 
  fwrite($file, 'This page was automatically generated on ' .date(DATE_RFC822).'.');

  close_span($file);

  close_div($file);
  close_div($file);

  fclose($file);

}

function write_courses($f, $q){
  ul_link_list($f);
  foreach ($q as $value) {
    $code = str_replace('.', '_', $value[4]);
    $html_text = "<li><a href='http://www3.imperial.ac.uk/computing/teaching/courses/$code' title='$value[3]'>$value[4] $value[3]</a></li>";
    fwrite($f, $html_text);
  } 
  close_ul($f);
}

function get_types_of_selectives($file, $selectives, $min_max, $type){
  foreach ($selectives as $key => $value) {
    fwrite($file, '<h3>'.$type.' - ');
    $row = $min_max[$key];
    if ($row[2] == $row[3]){
      fwrite($file, convertDigit($row[2]). ' from this list'); 
    }else{
      fwrite($file, convertDigit($row[2]). ' to ' . 
      convertDigit($row[3]) . ' from this list'); 
    }
    fwrite($file, '</h3>');
    write_courses($file, $value);
  }
}

?>
