/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.HttpParser;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.util.ArrayValueMap;
import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.Data;
import com.google.api.client.util.FieldInfo;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.Types;
import com.google.api.client.util.escape.CharEscapers;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlEncodedParser
implements HttpParser {
    public static final String CONTENT_TYPE = "application/x-www-form-urlencoded";
    private final boolean disableContentLogging;
    private final String contentType;

    @Override
    public final String getContentType() {
        return this.contentType;
    }

    public UrlEncodedParser() {
        this(CONTENT_TYPE, false);
    }

    protected UrlEncodedParser(String contentType, boolean disableContentLogging) {
        this.contentType = contentType;
        this.disableContentLogging = disableContentLogging;
    }

    @Override
    public <T> T parse(HttpResponse response, Class<T> dataClass) throws IOException {
        if (this.disableContentLogging) {
            response.setDisableContentLogging(true);
        }
        T newInstance = Types.newInstance(dataClass);
        UrlEncodedParser.parse(response.parseAsString(), newInstance);
        return newInstance;
    }

    public final boolean getDisableContentLogging() {
        return this.disableContentLogging;
    }

    public static void parse(String content, Object data) {
        if (content == null) {
            return;
        }
        Class<?> clazz = data.getClass();
        ClassInfo classInfo = ClassInfo.of(clazz);
        List<Type> context = Arrays.asList(clazz);
        GenericData genericData = GenericData.class.isAssignableFrom(clazz) ? (GenericData)data : null;
        Map map = Map.class.isAssignableFrom(clazz) ? (Map)data : null;
        ArrayValueMap arrayValueMap = new ArrayValueMap(data);
        int cur = 0;
        int length = content.length();
        int nextEquals = content.indexOf(61);
        while (cur < length) {
            String stringValue;
            String name;
            int amp = content.indexOf(38, cur);
            if (amp == -1) {
                amp = length;
            }
            if (nextEquals != -1 && nextEquals < amp) {
                name = content.substring(cur, nextEquals);
                stringValue = CharEscapers.decodeUri(content.substring(nextEquals + 1, amp));
                nextEquals = content.indexOf(61, amp + 1);
            } else {
                name = content.substring(cur, amp);
                stringValue = "";
            }
            name = CharEscapers.decodeUri(name);
            FieldInfo fieldInfo = classInfo.getFieldInfo(name);
            if (fieldInfo != null) {
                Type type = Data.resolveWildcardTypeOrTypeVariable(context, fieldInfo.getGenericType());
                if (Types.isArray(type)) {
                    Class<?> rawArrayComponentType = Types.getRawArrayComponentType(context, Types.getArrayComponentType(type));
                    arrayValueMap.put(fieldInfo.getField(), rawArrayComponentType, UrlEncodedParser.parseValue(rawArrayComponentType, context, stringValue));
                } else if (Types.isAssignableToOrFrom(Types.getRawArrayComponentType(context, type), Iterable.class)) {
                    Collection<Object> collection = (Collection<Object>)fieldInfo.getValue(data);
                    if (collection == null) {
                        collection = Data.newCollectionInstance(type);
                        fieldInfo.setValue(data, collection);
                    }
                    Type subFieldType = type == Object.class ? null : Types.getIterableParameter(type);
                    collection.add(UrlEncodedParser.parseValue(subFieldType, context, stringValue));
                } else {
                    fieldInfo.setValue(data, UrlEncodedParser.parseValue(type, context, stringValue));
                }
            } else if (map != null) {
                ArrayList<String> listValue = (ArrayList<String>)map.get(name);
                if (listValue == null) {
                    listValue = new ArrayList<String>();
                    if (genericData != null) {
                        genericData.set(name, listValue);
                    } else {
                        map.put(name, listValue);
                    }
                }
                listValue.add(stringValue);
            }
            cur = amp + 1;
        }
        arrayValueMap.setValues();
    }

    private static Object parseValue(Type valueType, List<Type> context, String value) {
        Type resolved = Data.resolveWildcardTypeOrTypeVariable(context, valueType);
        return Data.parsePrimitiveValue(resolved, value);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean disableContentLogging;
        private String contentType = "application/x-www-form-urlencoded";

        protected Builder() {
        }

        public UrlEncodedParser build() {
            return new UrlEncodedParser(this.contentType, this.disableContentLogging);
        }

        public final String getContentType() {
            return this.contentType;
        }

        public Builder setContentType(String contentType) {
            this.contentType = (String)Preconditions.checkNotNull((Object)contentType);
            return this;
        }

        public final boolean getDisableContentLogging() {
            return this.disableContentLogging;
        }

        public Builder setDisableContentLogging(boolean disableContentLogging) {
            this.disableContentLogging = disableContentLogging;
            return this;
        }
    }
}

