/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.jsontoken;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.security.SignatureException;
import java.util.List;
import java.util.regex.Pattern;
import net.oauth.jsontoken.Checker;
import net.oauth.jsontoken.Clock;
import net.oauth.jsontoken.JsonToken;
import net.oauth.jsontoken.JsonTokenUtil;
import net.oauth.jsontoken.SystemClock;
import net.oauth.jsontoken.crypto.AsciiStringVerifier;
import net.oauth.jsontoken.crypto.SignatureAlgorithm;
import net.oauth.jsontoken.crypto.Verifier;
import net.oauth.jsontoken.discovery.VerifierProviders;
import org.apache.commons.codec.binary.Base64;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public class JsonTokenParser {
    private final Clock clock;
    private final VerifierProviders locators;
    private final Checker[] checkers;

    public JsonTokenParser(VerifierProviders locators, Checker checker) {
        this(new SystemClock(), locators, checker);
    }

    public JsonTokenParser(Clock clock, VerifierProviders locators, Checker ... checkers) {
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
        this.locators = (VerifierProviders)Preconditions.checkNotNull((Object)locators);
        this.checkers = (Checker[])Preconditions.checkNotNull((Object)checkers);
    }

    public JsonToken verifyAndDeserialize(String tokenString) throws SignatureException {
        String[] pieces = tokenString.split(Pattern.quote("."));
        if (pieces.length != 3) {
            throw new IllegalArgumentException("Expected JWT to have 3 segments separated by '.', but it has " + pieces.length + " segments");
        }
        String jwtHeaderSegment = pieces[0];
        String jwtPayloadSegment = pieces[1];
        byte[] signature = Base64.decodeBase64((String)pieces[2]);
        JsonParser parser = new JsonParser();
        JsonObject header = parser.parse(JsonTokenUtil.fromBase64ToJsonString(jwtHeaderSegment)).getAsJsonObject();
        JsonObject payload = parser.parse(JsonTokenUtil.fromBase64ToJsonString(jwtPayloadSegment)).getAsJsonObject();
        JsonElement algorithmName = header.get("alg");
        if (algorithmName == null) {
            throw new SignatureException("JWT header is missing the required 'alg' parameter");
        }
        SignatureAlgorithm sigAlg = SignatureAlgorithm.getFromJsonName(algorithmName.getAsString());
        JsonElement keyIdJson = header.get("kid");
        String keyId = keyIdJson == null ? null : keyIdJson.getAsString();
        String baseString = JsonTokenUtil.toDotFormat(jwtHeaderSegment, jwtPayloadSegment);
        JsonToken jsonToken = new JsonToken(payload, this.clock);
        List<Verifier> verifiers = this.locators.getVerifierProvider(sigAlg).findVerifier(jsonToken.getIssuer(), keyId);
        if (verifiers == null) {
            throw new SignatureException("No valid verifier for issuer: " + jsonToken.getIssuer());
        }
        boolean sigVerified = false;
        for (Verifier verifier : verifiers) {
            AsciiStringVerifier asciiVerifier = new AsciiStringVerifier(verifier);
            try {
                asciiVerifier.verifySignature(baseString, signature);
                sigVerified = true;
                break;
            }
            catch (SignatureException e) {
            }
        }
        if (!sigVerified) {
            throw new SignatureException("Signature verification failed for issuer: " + jsonToken.getIssuer());
        }
        Instant now = this.clock.now();
        Instant expiration = jsonToken.getExpiration();
        if (expiration != null && now.isAfter((ReadableInstant)expiration)) {
            throw new SignatureException("token expired at " + expiration + ", now is " + now);
        }
        Instant issuedAt = jsonToken.getIssuedAt();
        if (issuedAt != null && now.isBefore((ReadableInstant)issuedAt)) {
            throw new SignatureException("token claims it was issued in the future at " + issuedAt + ", now is " + now);
        }
        for (Checker checker : this.checkers) {
            checker.check(payload);
        }
        return jsonToken;
    }
}

