/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.json;

import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.json.JsonHttpParser;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonParser;
import com.google.api.client.json.JsonToken;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonCParser
extends JsonHttpParser {
    public JsonCParser(JsonFactory jsonFactory) {
        super(jsonFactory);
    }

    public <T> T parse(HttpResponse response, Class<T> dataClass) throws IOException {
        return (T)JsonCParser.parserForResponse(this.getJsonFactory(), response).parseAndClose(dataClass, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonParser parserForResponse(JsonFactory jsonFactory, HttpResponse response) throws IOException {
        String contentType = response.getContentType();
        if (contentType == null || !contentType.startsWith("application/json")) {
            throw new IllegalArgumentException("Wrong content type: expected <application/json> but got <" + contentType + ">");
        }
        boolean failed = true;
        JsonParser parser = JsonHttpParser.parserForResponse((JsonFactory)jsonFactory, (HttpResponse)response);
        try {
            parser.skipToKey(response.isSuccessStatusCode() ? "data" : "error");
            if (parser.getCurrentToken() == JsonToken.END_OBJECT) {
                throw new IllegalArgumentException("data key not found");
            }
            failed = false;
            JsonParser jsonParser = parser;
            return jsonParser;
        }
        finally {
            if (failed) {
                parser.close();
            }
        }
    }
}

