/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.servlet.auth;

import com.google.api.client.extensions.auth.helpers.Credential;
import com.google.api.client.extensions.auth.helpers.TwoLeggedFlow;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import java.io.IOException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractTwoLeggedFlowServlet
extends HttpServlet {
    private static final String AUTH_PERSISTENCE_MANAGER = "com.google.api.client.extensions.servlet.auth.persistence_manager";
    private static final long serialVersionUID = 1L;
    private final HttpTransport httpTransport = this.newHttpTransportInstance();
    private final JsonFactory jsonFactory = this.newJsonFactoryInstance();

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PersistenceManager pm = this.getPersistenceManagerFactory().getPersistenceManager();
        req.setAttribute(AUTH_PERSISTENCE_MANAGER, (Object)pm);
        try {
            super.service(req, resp);
        }
        catch (HttpResponseException e) {
            e.getResponse().ignore();
            throw e;
        }
        finally {
            pm.close();
        }
    }

    protected Credential getCredential(HttpServletRequest req) throws IOException {
        PersistenceManager pm = (PersistenceManager)req.getAttribute(AUTH_PERSISTENCE_MANAGER);
        String userId = this.getUserId();
        TwoLeggedFlow oauthFlow = this.newFlow(userId);
        Credential cred = oauthFlow.loadOrCreateCredential(pm);
        return cred;
    }

    protected abstract TwoLeggedFlow newFlow(String var1);

    protected final JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    protected final HttpTransport getHttpTransport() {
        return this.httpTransport;
    }

    protected abstract PersistenceManagerFactory getPersistenceManagerFactory();

    protected abstract HttpTransport newHttpTransportInstance();

    protected abstract JsonFactory newJsonFactoryInstance();

    protected abstract String getUserId();
}

