/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.extensions.appengine.auth.helpers;

import com.google.api.client.auth.oauth2.draft10.AccessProtectedResource;
import com.google.api.client.auth.oauth2.draft10.AccessTokenRequest;
import com.google.api.client.extensions.appengine.auth.SignedTokenGenerator;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import java.io.IOException;
import java.security.SignatureException;
import net.oauth.jsontoken.JsonToken;

public class AccessAppResource
extends AccessProtectedResource {
    private static final String ASSERTION_TYPE = "http://oauth.net/grant_type/jwt/1.0/bearer";
    private final HttpTransport transport;
    private final JsonFactory jsonFactory;
    private final String authorizationServerUrl;
    private final String scope;
    private final String audience;

    public AccessAppResource(String accessToken, AccessProtectedResource.Method method, HttpTransport transport, JsonFactory jsonFactory, String authorizationServerUrl, String scope, String audience) throws IOException {
        super("", method);
        this.transport = transport;
        this.jsonFactory = jsonFactory;
        this.scope = scope;
        this.audience = audience;
        this.authorizationServerUrl = authorizationServerUrl;
        if (accessToken == null) {
            this.refreshToken();
        } else {
            this.setAccessToken(accessToken);
        }
    }

    protected boolean executeRefreshToken() throws IOException {
        String assertion;
        JsonToken jwt = SignedTokenGenerator.createJsonTokenForScopes(this.scope, this.audience);
        try {
            assertion = jwt.serializeAndSign();
        }
        catch (SignatureException exception) {
            IOException rewrite = new IOException("Unable to sign JSON Web Token");
            rewrite.initCause(exception);
            throw rewrite;
        }
        AccessTokenRequest.AssertionGrant tokenRequest = new AccessTokenRequest.AssertionGrant(this.transport, this.jsonFactory, this.authorizationServerUrl, ASSERTION_TYPE, assertion);
        return this.executeAccessTokenRequest((AccessTokenRequest)tokenRequest);
    }
}

