/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.calendar;

import com.google.api.client.googleapis.services.GoogleClient;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpMethod;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpClient;
import com.google.api.client.http.json.JsonHttpRequest;
import com.google.api.client.http.json.JsonHttpRequestInitializer;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.services.calendar.CalendarRequest;
import com.google.api.services.calendar.model.AclRule;
import com.google.api.services.calendar.model.CalendarListEntry;
import com.google.api.services.calendar.model.Event;
import com.google.api.services.calendar.model.FreeBusyRequest;
import com.google.api.services.calendar.model.FreeBusyResponse;
import com.google.api.services.calendar.model.Setting;
import java.io.IOException;

public class Calendar
extends GoogleClient {
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/calendar/v3/";
    @Deprecated
    private String applicationName;
    @Deprecated
    private String baseServer = "https://www.googleapis.com";
    @Deprecated
    private String basePath = "/calendar/v3/";
    @Key
    private Boolean prettyPrint;
    @Key
    private String fields;
    @Key
    private String quotaUser;
    @Key
    private String oauthToken;
    @Key
    private String key;
    @Key
    private String userIp;
    @Key
    private String alt;
    @Deprecated
    public final Freebusy freebusy = new Freebusy();
    @Deprecated
    public final Settings settings = new Settings();
    @Deprecated
    public final CalendarList calendarList = new CalendarList();
    @Deprecated
    public final Calendars calendars = new Calendars();
    @Deprecated
    public final Acl acl = new Acl();
    @Deprecated
    public final Colors colors = new Colors();
    @Deprecated
    public final Events events = new Events();

    @Deprecated
    public Calendar(HttpTransport transport, HttpRequestInitializer requestInitializer, JsonFactory jsonFactory) {
        super(transport, (JsonHttpRequestInitializer)new CalendarRequestInitializer(), requestInitializer, jsonFactory, DEFAULT_BASE_URL, null);
        ((CalendarRequestInitializer)this.getJsonHttpRequestInitializer()).setCalendar(this);
    }

    public Calendar(HttpTransport transport, JsonFactory jsonFactory) {
        this(transport, null, jsonFactory);
    }

    @Deprecated
    public Calendar(String appName, HttpTransport transport, JsonFactory jsonFactory) {
        this(transport, null, jsonFactory);
        this.setApplicationName(appName);
    }

    @Deprecated
    public Boolean getPrettyPrint() {
        return this.prettyPrint;
    }

    @Deprecated
    public Calendar setPrettyPrint(Boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        return this;
    }

    @Deprecated
    public String getFields() {
        return this.fields;
    }

    @Deprecated
    public Calendar setFields(String fields) {
        this.fields = fields;
        return this;
    }

    @Deprecated
    public String getQuotaUser() {
        return this.quotaUser;
    }

    @Deprecated
    public Calendar setQuotaUser(String quotaUser) {
        this.quotaUser = quotaUser;
        return this;
    }

    @Deprecated
    public String getOauthToken() {
        return this.oauthToken;
    }

    @Deprecated
    public Calendar setOauthToken(String oauthToken) {
        this.oauthToken = oauthToken;
        return this;
    }

    @Deprecated
    public String getKey() {
        return this.key;
    }

    @Deprecated
    public Calendar setKey(String key) {
        this.key = key;
        return this;
    }

    @Deprecated
    public String getUserIp() {
        return this.userIp;
    }

    @Deprecated
    public Calendar setUserIp(String userIp) {
        this.userIp = userIp;
        return this;
    }

    @Deprecated
    public String getAlt() {
        return this.alt;
    }

    @Deprecated
    public Calendar setAlt(String alt) {
        this.alt = alt;
        return this;
    }

    Calendar(HttpTransport transport, JsonHttpRequestInitializer jsonHttpRequestInitializer, HttpRequestInitializer httpRequestInitializer, JsonFactory jsonFactory, String baseUrl, String applicationName) {
        super(transport, jsonHttpRequestInitializer, httpRequestInitializer, jsonFactory, baseUrl, applicationName);
    }

    @Deprecated
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        if (this.applicationName == null) {
            return super.getApplicationName();
        }
        return this.applicationName;
    }

    public String getBaseUrl() {
        String baseUrl = this.getBaseServer() + this.getBasePath();
        if (DEFAULT_BASE_URL.equals(baseUrl)) {
            return super.getBaseUrl();
        }
        return baseUrl;
    }

    @Deprecated
    public void setBaseServer(String baseServer) {
        this.baseServer = baseServer;
    }

    @Deprecated
    public String getBaseServer() {
        return this.baseServer;
    }

    @Deprecated
    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    @Deprecated
    public String getBasePath() {
        return this.basePath;
    }

    public static Builder builder(HttpTransport transport, JsonFactory jsonFactory) {
        return new Builder(transport, jsonFactory);
    }

    public Freebusy freebusy() {
        return new Freebusy();
    }

    public Settings settings() {
        return new Settings();
    }

    public CalendarList calendarList() {
        return new CalendarList();
    }

    public Calendars calendars() {
        return new Calendars();
    }

    public Acl acl() {
        return new Acl();
    }

    public Colors colors() {
        return new Colors();
    }

    public Events events() {
        return new Events();
    }

    public static final class Builder
    extends GoogleClient.Builder {
        Builder(HttpTransport transport, JsonFactory jsonFactory) {
            super(transport, jsonFactory, new GenericUrl(Calendar.DEFAULT_BASE_URL));
        }

        public Calendar build() {
            return new Calendar(this.getTransport(), this.getJsonHttpRequestInitializer(), this.getHttpRequestInitializer(), this.getJsonFactory(), this.getBaseUrl().build(), this.getApplicationName());
        }

        public Builder setJsonHttpRequestInitializer(JsonHttpRequestInitializer jsonHttpRequestInitializer) {
            super.setJsonHttpRequestInitializer(jsonHttpRequestInitializer);
            return this;
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            super.setHttpRequestInitializer(httpRequestInitializer);
            return this;
        }

        public Builder setApplicationName(String applicationName) {
            super.setApplicationName(applicationName);
            return this;
        }
    }

    public class Events {
        public Reset reset(String calendarId, String eventId) throws IOException {
            Reset result = new Reset(calendarId, eventId);
            Calendar.this.initialize(result);
            return result;
        }

        public Insert insert(String calendarId, Event content) throws IOException {
            Insert result = new Insert(calendarId, content);
            Calendar.this.initialize(result);
            return result;
        }

        public Get get(String calendarId, String eventId) throws IOException {
            Get result = new Get(calendarId, eventId);
            Calendar.this.initialize(result);
            return result;
        }

        public Move move(String calendarId, String eventId, String destination) throws IOException {
            Move result = new Move(calendarId, eventId, destination);
            Calendar.this.initialize(result);
            return result;
        }

        public List list(String calendarId) throws IOException {
            List result = new List(calendarId);
            Calendar.this.initialize(result);
            return result;
        }

        public Update update(String calendarId, String eventId, Event content) throws IOException {
            Update result = new Update(calendarId, eventId, content);
            Calendar.this.initialize(result);
            return result;
        }

        public Patch patch(String calendarId, String eventId, Event content) throws IOException {
            Patch result = new Patch(calendarId, eventId, content);
            Calendar.this.initialize(result);
            return result;
        }

        public Instances instances(String calendarId, String eventId) throws IOException {
            Instances result = new Instances(calendarId, eventId);
            Calendar.this.initialize(result);
            return result;
        }

        public CalendarImport calendarImport(String calendarId, Event content) throws IOException {
            CalendarImport result = new CalendarImport(calendarId, content);
            Calendar.this.initialize(result);
            return result;
        }

        public QuickAdd quickAdd(String calendarId, String text) throws IOException {
            QuickAdd result = new QuickAdd(calendarId, text);
            Calendar.this.initialize(result);
            return result;
        }

        public Delete delete(String calendarId, String eventId) throws IOException {
            Delete result = new Delete(calendarId, eventId);
            Calendar.this.initialize(result);
            return result;
        }

        public class Delete
        extends CalendarRequest {
            private static final String REST_PATH = "calendars/{calendarId}/events/{eventId}";
            @Key(value="calendarId")
            private String calendarId;
            @Key(value="eventId")
            private String eventId;
            @Key(value="sendNotifications")
            private Boolean sendNotifications;

            private Delete(String calendarId, String eventId) {
                super((JsonHttpClient)Calendar.this, HttpMethod.DELETE, REST_PATH, null);
                this.calendarId = calendarId;
                this.eventId = eventId;
            }

            public void execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                response.ignore();
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Delete setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public String getEventId() {
                return this.eventId;
            }

            public Delete setEventId(String eventId) {
                this.eventId = eventId;
                return this;
            }

            public Boolean getSendNotifications() {
                return this.sendNotifications;
            }

            public Delete setSendNotifications(Boolean sendNotifications) {
                this.sendNotifications = sendNotifications;
                return this;
            }
        }

        public class QuickAdd
        extends CalendarRequest {
            private static final String REST_PATH = "calendars/{calendarId}/events/quickAdd";
            @Key(value="calendarId")
            private String calendarId;
            @Key(value="text")
            private String text;
            @Key(value="sendNotifications")
            private Boolean sendNotifications;

            private QuickAdd(String calendarId, String text) {
                super((JsonHttpClient)Calendar.this, HttpMethod.POST, REST_PATH, null);
                this.calendarId = calendarId;
                this.text = text;
            }

            public Event execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                Event result = (Event)((Object)response.parseAs(Event.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public QuickAdd setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public String getText() {
                return this.text;
            }

            public QuickAdd setText(String text) {
                this.text = text;
                return this;
            }

            public Boolean getSendNotifications() {
                return this.sendNotifications;
            }

            public QuickAdd setSendNotifications(Boolean sendNotifications) {
                this.sendNotifications = sendNotifications;
                return this;
            }
        }

        public class CalendarImport
        extends CalendarRequest {
            private static final String REST_PATH = "calendars/{calendarId}/events/import";
            @Key(value="calendarId")
            private String calendarId;
            private Event content;

            private CalendarImport(String calendarId, Event content) {
                super((JsonHttpClient)Calendar.this, HttpMethod.POST, REST_PATH, (Object)content);
                this.calendarId = calendarId;
                this.content = content;
            }

            public Event execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                Event result = (Event)((Object)response.parseAs(Event.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public CalendarImport setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }
        }

        public class Instances
        extends CalendarRequest {
            private static final String REST_PATH = "calendars/{calendarId}/events/{eventId}/instances";
            @Key(value="calendarId")
            private String calendarId;
            @Key(value="eventId")
            private String eventId;
            @Key(value="showDeleted")
            private Boolean showDeleted;
            @Key(value="maxResults")
            private Integer maxResults;
            @Key(value="pageToken")
            private String pageToken;
            @Key(value="timeZone")
            private String timeZone;
            @Key(value="originalStart")
            private String originalStart;
            @Key(value="maxAttendees")
            private Integer maxAttendees;

            private Instances(String calendarId, String eventId) {
                super((JsonHttpClient)Calendar.this, HttpMethod.GET, REST_PATH, null);
                this.calendarId = calendarId;
                this.eventId = eventId;
            }

            public com.google.api.services.calendar.model.Events execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                com.google.api.services.calendar.model.Events result = (com.google.api.services.calendar.model.Events)((Object)response.parseAs(com.google.api.services.calendar.model.Events.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Instances setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public String getEventId() {
                return this.eventId;
            }

            public Instances setEventId(String eventId) {
                this.eventId = eventId;
                return this;
            }

            public Boolean getShowDeleted() {
                return this.showDeleted;
            }

            public Instances setShowDeleted(Boolean showDeleted) {
                this.showDeleted = showDeleted;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public Instances setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Instances setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getTimeZone() {
                return this.timeZone;
            }

            public Instances setTimeZone(String timeZone) {
                this.timeZone = timeZone;
                return this;
            }

            public String getOriginalStart() {
                return this.originalStart;
            }

            public Instances setOriginalStart(String originalStart) {
                this.originalStart = originalStart;
                return this;
            }

            public Integer getMaxAttendees() {
                return this.maxAttendees;
            }

            public Instances setMaxAttendees(Integer maxAttendees) {
                this.maxAttendees = maxAttendees;
                return this;
            }
        }

        public class Patch
        extends CalendarRequest {
            private static final String REST_PATH = "calendars/{calendarId}/events/{eventId}";
            @Key(value="calendarId")
            private String calendarId;
            @Key(value="eventId")
            private String eventId;
            @Key(value="sendNotifications")
            private Boolean sendNotifications;
            private Event content;

            private Patch(String calendarId, String eventId, Event content) {
                super((JsonHttpClient)Calendar.this, HttpMethod.PATCH, REST_PATH, (Object)content);
                this.calendarId = calendarId;
                this.eventId = eventId;
                this.content = content;
            }

            public Event execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                Event result = (Event)((Object)response.parseAs(Event.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Patch setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public String getEventId() {
                return this.eventId;
            }

            public Patch setEventId(String eventId) {
                this.eventId = eventId;
                return this;
            }

            public Boolean getSendNotifications() {
                return this.sendNotifications;
            }

            public Patch setSendNotifications(Boolean sendNotifications) {
                this.sendNotifications = sendNotifications;
                return this;
            }
        }

        public class Update
        extends CalendarRequest {
            private static final String REST_PATH = "calendars/{calendarId}/events/{eventId}";
            @Key(value="calendarId")
            private String calendarId;
            @Key(value="eventId")
            private String eventId;
            @Key(value="sendNotifications")
            private Boolean sendNotifications;
            private Event content;

            private Update(String calendarId, String eventId, Event content) {
                super((JsonHttpClient)Calendar.this, HttpMethod.PUT, REST_PATH, (Object)content);
                this.calendarId = calendarId;
                this.eventId = eventId;
                this.content = content;
            }

            public Event execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                Event result = (Event)((Object)response.parseAs(Event.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Update setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public String getEventId() {
                return this.eventId;
            }

            public Update setEventId(String eventId) {
                this.eventId = eventId;
                return this;
            }

            public Boolean getSendNotifications() {
                return this.sendNotifications;
            }

            public Update setSendNotifications(Boolean sendNotifications) {
                this.sendNotifications = sendNotifications;
                return this;
            }
        }

        public class List
        extends CalendarRequest {
            private static final String REST_PATH = "calendars/{calendarId}/events";
            @Key(value="calendarId")
            private String calendarId;
            @Key(value="orderBy")
            private String orderBy;
            @Key(value="showHiddenInvitations")
            private Boolean showHiddenInvitations;
            @Key(value="showDeleted")
            private Boolean showDeleted;
            @Key(value="iCalUID")
            private String iCalUID;
            @Key(value="updatedMin")
            private String updatedMin;
            @Key(value="singleEvents")
            private Boolean singleEvents;
            @Key(value="maxResults")
            private Integer maxResults;
            @Key(value="q")
            private String q;
            @Key(value="pageToken")
            private String pageToken;
            @Key(value="timeMin")
            private String timeMin;
            @Key(value="timeZone")
            private String timeZone;
            @Key(value="timeMax")
            private String timeMax;
            @Key(value="maxAttendees")
            private Integer maxAttendees;

            private List(String calendarId) {
                super((JsonHttpClient)Calendar.this, HttpMethod.GET, REST_PATH, null);
                this.calendarId = calendarId;
            }

            public com.google.api.services.calendar.model.Events execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                com.google.api.services.calendar.model.Events result = (com.google.api.services.calendar.model.Events)((Object)response.parseAs(com.google.api.services.calendar.model.Events.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public List setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String orderBy) {
                this.orderBy = orderBy;
                return this;
            }

            public Boolean getShowHiddenInvitations() {
                return this.showHiddenInvitations;
            }

            public List setShowHiddenInvitations(Boolean showHiddenInvitations) {
                this.showHiddenInvitations = showHiddenInvitations;
                return this;
            }

            public Boolean getShowDeleted() {
                return this.showDeleted;
            }

            public List setShowDeleted(Boolean showDeleted) {
                this.showDeleted = showDeleted;
                return this;
            }

            public String getICalUID() {
                return this.iCalUID;
            }

            public List setICalUID(String iCalUID) {
                this.iCalUID = iCalUID;
                return this;
            }

            public String getUpdatedMin() {
                return this.updatedMin;
            }

            public List setUpdatedMin(String updatedMin) {
                this.updatedMin = updatedMin;
                return this;
            }

            public Boolean getSingleEvents() {
                return this.singleEvents;
            }

            public List setSingleEvents(Boolean singleEvents) {
                this.singleEvents = singleEvents;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getQ() {
                return this.q;
            }

            public List setQ(String q) {
                this.q = q;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getTimeMin() {
                return this.timeMin;
            }

            public List setTimeMin(String timeMin) {
                this.timeMin = timeMin;
                return this;
            }

            public String getTimeZone() {
                return this.timeZone;
            }

            public List setTimeZone(String timeZone) {
                this.timeZone = timeZone;
                return this;
            }

            public String getTimeMax() {
                return this.timeMax;
            }

            public List setTimeMax(String timeMax) {
                this.timeMax = timeMax;
                return this;
            }

            public Integer getMaxAttendees() {
                return this.maxAttendees;
            }

            public List setMaxAttendees(Integer maxAttendees) {
                this.maxAttendees = maxAttendees;
                return this;
            }
        }

        public class Move
        extends CalendarRequest {
            private static final String REST_PATH = "calendars/{calendarId}/events/{eventId}/move";
            @Key(value="calendarId")
            private String calendarId;
            @Key(value="eventId")
            private String eventId;
            @Key(value="destination")
            private String destination;
            @Key(value="sendNotifications")
            private Boolean sendNotifications;

            private Move(String calendarId, String eventId, String destination) {
                super((JsonHttpClient)Calendar.this, HttpMethod.POST, REST_PATH, null);
                this.calendarId = calendarId;
                this.eventId = eventId;
                this.destination = destination;
            }

            public Event execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                Event result = (Event)((Object)response.parseAs(Event.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Move setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public String getEventId() {
                return this.eventId;
            }

            public Move setEventId(String eventId) {
                this.eventId = eventId;
                return this;
            }

            public String getDestination() {
                return this.destination;
            }

            public Move setDestination(String destination) {
                this.destination = destination;
                return this;
            }

            public Boolean getSendNotifications() {
                return this.sendNotifications;
            }

            public Move setSendNotifications(Boolean sendNotifications) {
                this.sendNotifications = sendNotifications;
                return this;
            }
        }

        public class Get
        extends CalendarRequest {
            private static final String REST_PATH = "calendars/{calendarId}/events/{eventId}";
            @Key(value="calendarId")
            private String calendarId;
            @Key(value="eventId")
            private String eventId;
            @Key(value="timeZone")
            private String timeZone;
            @Key(value="maxAttendees")
            private Integer maxAttendees;

            private Get(String calendarId, String eventId) {
                super((JsonHttpClient)Calendar.this, HttpMethod.GET, REST_PATH, null);
                this.calendarId = calendarId;
                this.eventId = eventId;
            }

            public Event execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                Event result = (Event)((Object)response.parseAs(Event.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Get setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public String getEventId() {
                return this.eventId;
            }

            public Get setEventId(String eventId) {
                this.eventId = eventId;
                return this;
            }

            public String getTimeZone() {
                return this.timeZone;
            }

            public Get setTimeZone(String timeZone) {
                this.timeZone = timeZone;
                return this;
            }

            public Integer getMaxAttendees() {
                return this.maxAttendees;
            }

            public Get setMaxAttendees(Integer maxAttendees) {
                this.maxAttendees = maxAttendees;
                return this;
            }
        }

        public class Insert
        extends CalendarRequest {
            private static final String REST_PATH = "calendars/{calendarId}/events";
            @Key(value="calendarId")
            private String calendarId;
            @Key(value="sendNotifications")
            private Boolean sendNotifications;
            private Event content;

            private Insert(String calendarId, Event content) {
                super((JsonHttpClient)Calendar.this, HttpMethod.POST, REST_PATH, (Object)content);
                this.calendarId = calendarId;
                this.content = content;
            }

            public Event execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                Event result = (Event)((Object)response.parseAs(Event.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Insert setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public Boolean getSendNotifications() {
                return this.sendNotifications;
            }

            public Insert setSendNotifications(Boolean sendNotifications) {
                this.sendNotifications = sendNotifications;
                return this;
            }
        }

        public class Reset
        extends CalendarRequest {
            private static final String REST_PATH = "calendars/{calendarId}/events/{eventId}/reset";
            @Key(value="calendarId")
            private String calendarId;
            @Key(value="eventId")
            private String eventId;
            @Key(value="sendNotifications")
            private Boolean sendNotifications;

            private Reset(String calendarId, String eventId) {
                super((JsonHttpClient)Calendar.this, HttpMethod.POST, REST_PATH, null);
                this.calendarId = calendarId;
                this.eventId = eventId;
            }

            public Event execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                Event result = (Event)((Object)response.parseAs(Event.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Reset setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public String getEventId() {
                return this.eventId;
            }

            public Reset setEventId(String eventId) {
                this.eventId = eventId;
                return this;
            }

            public Boolean getSendNotifications() {
                return this.sendNotifications;
            }

            public Reset setSendNotifications(Boolean sendNotifications) {
                this.sendNotifications = sendNotifications;
                return this;
            }
        }
    }

    public class Colors {
        public Get get() throws IOException {
            Get result = new Get();
            Calendar.this.initialize(result);
            return result;
        }

        public class Get
        extends CalendarRequest {
            private static final String REST_PATH = "colors";

            private Get() {
                super((JsonHttpClient)Calendar.this, HttpMethod.GET, REST_PATH, null);
            }

            public com.google.api.services.calendar.model.Colors execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                com.google.api.services.calendar.model.Colors result = (com.google.api.services.calendar.model.Colors)((Object)response.parseAs(com.google.api.services.calendar.model.Colors.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }
        }
    }

    public class Acl {
        public Insert insert(String calendarId, AclRule content) throws IOException {
            Insert result = new Insert(calendarId, content);
            Calendar.this.initialize(result);
            return result;
        }

        public Get get(String calendarId, String ruleId) throws IOException {
            Get result = new Get(calendarId, ruleId);
            Calendar.this.initialize(result);
            return result;
        }

        public List list(String calendarId) throws IOException {
            List result = new List(calendarId);
            Calendar.this.initialize(result);
            return result;
        }

        public Update update(String calendarId, String ruleId, AclRule content) throws IOException {
            Update result = new Update(calendarId, ruleId, content);
            Calendar.this.initialize(result);
            return result;
        }

        public Patch patch(String calendarId, String ruleId, AclRule content) throws IOException {
            Patch result = new Patch(calendarId, ruleId, content);
            Calendar.this.initialize(result);
            return result;
        }

        public Delete delete(String calendarId, String ruleId) throws IOException {
            Delete result = new Delete(calendarId, ruleId);
            Calendar.this.initialize(result);
            return result;
        }

        public class Delete
        extends CalendarRequest {
            private static final String REST_PATH = "calendars/{calendarId}/acl/{ruleId}";
            @Key(value="calendarId")
            private String calendarId;
            @Key(value="ruleId")
            private String ruleId;

            private Delete(String calendarId, String ruleId) {
                super((JsonHttpClient)Calendar.this, HttpMethod.DELETE, REST_PATH, null);
                this.calendarId = calendarId;
                this.ruleId = ruleId;
            }

            public void execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                response.ignore();
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Delete setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public String getRuleId() {
                return this.ruleId;
            }

            public Delete setRuleId(String ruleId) {
                this.ruleId = ruleId;
                return this;
            }
        }

        public class Patch
        extends CalendarRequest {
            private static final String REST_PATH = "calendars/{calendarId}/acl/{ruleId}";
            @Key(value="calendarId")
            private String calendarId;
            @Key(value="ruleId")
            private String ruleId;
            private AclRule content;

            private Patch(String calendarId, String ruleId, AclRule content) {
                super((JsonHttpClient)Calendar.this, HttpMethod.PATCH, REST_PATH, (Object)content);
                this.calendarId = calendarId;
                this.ruleId = ruleId;
                this.content = content;
            }

            public AclRule execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                AclRule result = (AclRule)((Object)response.parseAs(AclRule.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Patch setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public String getRuleId() {
                return this.ruleId;
            }

            public Patch setRuleId(String ruleId) {
                this.ruleId = ruleId;
                return this;
            }
        }

        public class Update
        extends CalendarRequest {
            private static final String REST_PATH = "calendars/{calendarId}/acl/{ruleId}";
            @Key(value="calendarId")
            private String calendarId;
            @Key(value="ruleId")
            private String ruleId;
            private AclRule content;

            private Update(String calendarId, String ruleId, AclRule content) {
                super((JsonHttpClient)Calendar.this, HttpMethod.PUT, REST_PATH, (Object)content);
                this.calendarId = calendarId;
                this.ruleId = ruleId;
                this.content = content;
            }

            public AclRule execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                AclRule result = (AclRule)((Object)response.parseAs(AclRule.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Update setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public String getRuleId() {
                return this.ruleId;
            }

            public Update setRuleId(String ruleId) {
                this.ruleId = ruleId;
                return this;
            }
        }

        public class List
        extends CalendarRequest {
            private static final String REST_PATH = "calendars/{calendarId}/acl";
            @Key(value="calendarId")
            private String calendarId;

            private List(String calendarId) {
                super((JsonHttpClient)Calendar.this, HttpMethod.GET, REST_PATH, null);
                this.calendarId = calendarId;
            }

            public com.google.api.services.calendar.model.Acl execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                com.google.api.services.calendar.model.Acl result = (com.google.api.services.calendar.model.Acl)((Object)response.parseAs(com.google.api.services.calendar.model.Acl.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public List setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }
        }

        public class Get
        extends CalendarRequest {
            private static final String REST_PATH = "calendars/{calendarId}/acl/{ruleId}";
            @Key(value="calendarId")
            private String calendarId;
            @Key(value="ruleId")
            private String ruleId;

            private Get(String calendarId, String ruleId) {
                super((JsonHttpClient)Calendar.this, HttpMethod.GET, REST_PATH, null);
                this.calendarId = calendarId;
                this.ruleId = ruleId;
            }

            public AclRule execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                AclRule result = (AclRule)((Object)response.parseAs(AclRule.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Get setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }

            public String getRuleId() {
                return this.ruleId;
            }

            public Get setRuleId(String ruleId) {
                this.ruleId = ruleId;
                return this;
            }
        }

        public class Insert
        extends CalendarRequest {
            private static final String REST_PATH = "calendars/{calendarId}/acl";
            @Key(value="calendarId")
            private String calendarId;
            private AclRule content;

            private Insert(String calendarId, AclRule content) {
                super((JsonHttpClient)Calendar.this, HttpMethod.POST, REST_PATH, (Object)content);
                this.calendarId = calendarId;
                this.content = content;
            }

            public AclRule execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                AclRule result = (AclRule)((Object)response.parseAs(AclRule.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Insert setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }
        }
    }

    public class Calendars {
        public Insert insert(com.google.api.services.calendar.model.Calendar content) throws IOException {
            Insert result = new Insert(content);
            Calendar.this.initialize(result);
            return result;
        }

        public Get get(String calendarId) throws IOException {
            Get result = new Get(calendarId);
            Calendar.this.initialize(result);
            return result;
        }

        public Clear clear(String calendarId) throws IOException {
            Clear result = new Clear(calendarId);
            Calendar.this.initialize(result);
            return result;
        }

        public Update update(String calendarId, com.google.api.services.calendar.model.Calendar content) throws IOException {
            Update result = new Update(calendarId, content);
            Calendar.this.initialize(result);
            return result;
        }

        public Patch patch(String calendarId, com.google.api.services.calendar.model.Calendar content) throws IOException {
            Patch result = new Patch(calendarId, content);
            Calendar.this.initialize(result);
            return result;
        }

        public Delete delete(String calendarId) throws IOException {
            Delete result = new Delete(calendarId);
            Calendar.this.initialize(result);
            return result;
        }

        public class Delete
        extends CalendarRequest {
            private static final String REST_PATH = "calendars/{calendarId}";
            @Key(value="calendarId")
            private String calendarId;

            private Delete(String calendarId) {
                super((JsonHttpClient)Calendar.this, HttpMethod.DELETE, REST_PATH, null);
                this.calendarId = calendarId;
            }

            public void execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                response.ignore();
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Delete setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }
        }

        public class Patch
        extends CalendarRequest {
            private static final String REST_PATH = "calendars/{calendarId}";
            @Key(value="calendarId")
            private String calendarId;
            private com.google.api.services.calendar.model.Calendar content;

            private Patch(String calendarId, com.google.api.services.calendar.model.Calendar content) {
                super((JsonHttpClient)Calendar.this, HttpMethod.PATCH, REST_PATH, (Object)content);
                this.calendarId = calendarId;
                this.content = content;
            }

            public com.google.api.services.calendar.model.Calendar execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                com.google.api.services.calendar.model.Calendar result = (com.google.api.services.calendar.model.Calendar)((Object)response.parseAs(com.google.api.services.calendar.model.Calendar.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Patch setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }
        }

        public class Update
        extends CalendarRequest {
            private static final String REST_PATH = "calendars/{calendarId}";
            @Key(value="calendarId")
            private String calendarId;
            private com.google.api.services.calendar.model.Calendar content;

            private Update(String calendarId, com.google.api.services.calendar.model.Calendar content) {
                super((JsonHttpClient)Calendar.this, HttpMethod.PUT, REST_PATH, (Object)content);
                this.calendarId = calendarId;
                this.content = content;
            }

            public com.google.api.services.calendar.model.Calendar execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                com.google.api.services.calendar.model.Calendar result = (com.google.api.services.calendar.model.Calendar)((Object)response.parseAs(com.google.api.services.calendar.model.Calendar.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Update setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }
        }

        public class Clear
        extends CalendarRequest {
            private static final String REST_PATH = "calendars/{calendarId}/clear";
            @Key(value="calendarId")
            private String calendarId;

            private Clear(String calendarId) {
                super((JsonHttpClient)Calendar.this, HttpMethod.POST, REST_PATH, null);
                this.calendarId = calendarId;
            }

            public void execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                response.ignore();
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Clear setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }
        }

        public class Get
        extends CalendarRequest {
            private static final String REST_PATH = "calendars/{calendarId}";
            @Key(value="calendarId")
            private String calendarId;

            private Get(String calendarId) {
                super((JsonHttpClient)Calendar.this, HttpMethod.GET, REST_PATH, null);
                this.calendarId = calendarId;
            }

            public com.google.api.services.calendar.model.Calendar execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                com.google.api.services.calendar.model.Calendar result = (com.google.api.services.calendar.model.Calendar)((Object)response.parseAs(com.google.api.services.calendar.model.Calendar.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Get setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }
        }

        public class Insert
        extends CalendarRequest {
            private static final String REST_PATH = "calendars";
            private com.google.api.services.calendar.model.Calendar content;

            private Insert(com.google.api.services.calendar.model.Calendar content) {
                super((JsonHttpClient)Calendar.this, HttpMethod.POST, REST_PATH, (Object)content);
                this.content = content;
            }

            public com.google.api.services.calendar.model.Calendar execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                com.google.api.services.calendar.model.Calendar result = (com.google.api.services.calendar.model.Calendar)((Object)response.parseAs(com.google.api.services.calendar.model.Calendar.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }
        }
    }

    public class CalendarList {
        public Insert insert(CalendarListEntry content) throws IOException {
            Insert result = new Insert(content);
            Calendar.this.initialize(result);
            return result;
        }

        public Get get(String calendarId) throws IOException {
            Get result = new Get(calendarId);
            Calendar.this.initialize(result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Calendar.this.initialize(result);
            return result;
        }

        public Update update(String calendarId, CalendarListEntry content) throws IOException {
            Update result = new Update(calendarId, content);
            Calendar.this.initialize(result);
            return result;
        }

        public Patch patch(String calendarId, CalendarListEntry content) throws IOException {
            Patch result = new Patch(calendarId, content);
            Calendar.this.initialize(result);
            return result;
        }

        public Delete delete(String calendarId) throws IOException {
            Delete result = new Delete(calendarId);
            Calendar.this.initialize(result);
            return result;
        }

        public class Delete
        extends CalendarRequest {
            private static final String REST_PATH = "users/me/calendarList/{calendarId}";
            @Key(value="calendarId")
            private String calendarId;

            private Delete(String calendarId) {
                super((JsonHttpClient)Calendar.this, HttpMethod.DELETE, REST_PATH, null);
                this.calendarId = calendarId;
            }

            public void execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                response.ignore();
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Delete setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }
        }

        public class Patch
        extends CalendarRequest {
            private static final String REST_PATH = "users/me/calendarList/{calendarId}";
            @Key(value="calendarId")
            private String calendarId;
            private CalendarListEntry content;

            private Patch(String calendarId, CalendarListEntry content) {
                super((JsonHttpClient)Calendar.this, HttpMethod.PATCH, REST_PATH, (Object)content);
                this.calendarId = calendarId;
                this.content = content;
            }

            public CalendarListEntry execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                CalendarListEntry result = (CalendarListEntry)((Object)response.parseAs(CalendarListEntry.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Patch setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }
        }

        public class Update
        extends CalendarRequest {
            private static final String REST_PATH = "users/me/calendarList/{calendarId}";
            @Key(value="calendarId")
            private String calendarId;
            private CalendarListEntry content;

            private Update(String calendarId, CalendarListEntry content) {
                super((JsonHttpClient)Calendar.this, HttpMethod.PUT, REST_PATH, (Object)content);
                this.calendarId = calendarId;
                this.content = content;
            }

            public CalendarListEntry execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                CalendarListEntry result = (CalendarListEntry)((Object)response.parseAs(CalendarListEntry.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Update setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }
        }

        public class List
        extends CalendarRequest {
            private static final String REST_PATH = "users/me/calendarList";
            @Key(value="pageToken")
            private String pageToken;
            @Key(value="showHidden")
            private Boolean showHidden;
            @Key(value="maxResults")
            private Integer maxResults;
            @Key(value="minAccessRole")
            private String minAccessRole;

            private List() {
                super((JsonHttpClient)Calendar.this, HttpMethod.GET, REST_PATH, null);
            }

            public com.google.api.services.calendar.model.CalendarList execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                com.google.api.services.calendar.model.CalendarList result = (com.google.api.services.calendar.model.CalendarList)((Object)response.parseAs(com.google.api.services.calendar.model.CalendarList.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getShowHidden() {
                return this.showHidden;
            }

            public List setShowHidden(Boolean showHidden) {
                this.showHidden = showHidden;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getMinAccessRole() {
                return this.minAccessRole;
            }

            public List setMinAccessRole(String minAccessRole) {
                this.minAccessRole = minAccessRole;
                return this;
            }
        }

        public class Get
        extends CalendarRequest {
            private static final String REST_PATH = "users/me/calendarList/{calendarId}";
            @Key(value="calendarId")
            private String calendarId;

            private Get(String calendarId) {
                super((JsonHttpClient)Calendar.this, HttpMethod.GET, REST_PATH, null);
                this.calendarId = calendarId;
            }

            public CalendarListEntry execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                CalendarListEntry result = (CalendarListEntry)((Object)response.parseAs(CalendarListEntry.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getCalendarId() {
                return this.calendarId;
            }

            public Get setCalendarId(String calendarId) {
                this.calendarId = calendarId;
                return this;
            }
        }

        public class Insert
        extends CalendarRequest {
            private static final String REST_PATH = "users/me/calendarList";
            private CalendarListEntry content;

            private Insert(CalendarListEntry content) {
                super((JsonHttpClient)Calendar.this, HttpMethod.POST, REST_PATH, (Object)content);
                this.content = content;
            }

            public CalendarListEntry execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                CalendarListEntry result = (CalendarListEntry)((Object)response.parseAs(CalendarListEntry.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }
        }
    }

    public class Settings {
        public List list() throws IOException {
            List result = new List();
            Calendar.this.initialize(result);
            return result;
        }

        public Get get(String setting) throws IOException {
            Get result = new Get(setting);
            Calendar.this.initialize(result);
            return result;
        }

        public class Get
        extends CalendarRequest {
            private static final String REST_PATH = "users/me/settings/{setting}";
            @Key(value="setting")
            private String setting;

            private Get(String setting) {
                super((JsonHttpClient)Calendar.this, HttpMethod.GET, REST_PATH, null);
                this.setting = setting;
            }

            public Setting execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                Setting result = (Setting)((Object)response.parseAs(Setting.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }

            public String getSetting() {
                return this.setting;
            }

            public Get setSetting(String setting) {
                this.setting = setting;
                return this;
            }
        }

        public class List
        extends CalendarRequest {
            private static final String REST_PATH = "users/me/settings";

            private List() {
                super((JsonHttpClient)Calendar.this, HttpMethod.GET, REST_PATH, null);
            }

            public com.google.api.services.calendar.model.Settings execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                com.google.api.services.calendar.model.Settings result = (com.google.api.services.calendar.model.Settings)((Object)response.parseAs(com.google.api.services.calendar.model.Settings.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }
        }
    }

    public class Freebusy {
        public Query query(FreeBusyRequest content) throws IOException {
            Query result = new Query(content);
            Calendar.this.initialize(result);
            return result;
        }

        public class Query
        extends CalendarRequest {
            private static final String REST_PATH = "freeBusy";
            private FreeBusyRequest content;

            private Query(FreeBusyRequest content) {
                super((JsonHttpClient)Calendar.this, HttpMethod.POST, REST_PATH, (Object)content);
                this.content = content;
            }

            public FreeBusyResponse execute() throws IOException {
                HttpResponse response = this.executeUnparsed();
                FreeBusyResponse result = (FreeBusyResponse)((Object)response.parseAs(FreeBusyResponse.class));
                result.setResponseHeaders(response.getHeaders());
                return result;
            }
        }
    }

    private static class CalendarRequestInitializer
    implements JsonHttpRequestInitializer {
        private Calendar calendar;

        private CalendarRequestInitializer() {
        }

        void setCalendar(Calendar calendar) {
            this.calendar = calendar;
        }

        public void initialize(JsonHttpRequest jsonHttpRequest) {
            CalendarRequest request = (CalendarRequest)jsonHttpRequest;
            request.setPrettyPrint(this.calendar.getPrettyPrint());
            request.setFields(this.calendar.getFields());
            request.setQuotaUser(this.calendar.getQuotaUser());
            request.setOauthToken(this.calendar.getOauthToken());
            request.setKey(this.calendar.getKey());
            request.setUserIp(this.calendar.getUserIp());
            request.setAlt(this.calendar.getAlt());
        }
    }
}

