#!/usr/bin/php
<?php
	session_start();
	function question() {
?>

<!-- START QUESTION -->

	<div class="test_question">
		Recall our model for a <span class = "code">Map</span> given in Dynamics II:
		<br/>
		<br/>
<span class = "code">
	<span class = "keyword">abstract</span> <span class = "keyword">sig</span> Object {}
	<span class = "keyword">sig</span> Key, Value <span class = "keyword">extends</span> Object {}
	<span class = "keyword">sig</span> Map {
		values: Key -> <span class = "keyword">lone</span> Value
	}
</span>
		<br/>
		Suppose we want to write a predicate <span class = "code">replace(m, m':Map, k:Key, v:Value)</span> for the operation of changing the value associated with an existing <span class = "code">Key</span> in a <span class = "code">Map</span>. How could we implement this?<br/><br/>
	</div>

	<div class="test_option">
		<form action="<?php echo $_SERVER["PHP_SELF"]; ?>" method="post" name = "test_form">
			<table>
			<tr>
				<td valign = "top"><input type="radio" name="option" value="0"/></td>
				<td>
<span class = "code">
	<span class = "keyword">pred</span> replace(m, m':Map, k:Key, v':Value) { 
		m'.values = m.values + k -> v'
	}
</span>
				</td>
			<tr>
				<td valign = "top"><input type="radio" name="option" value="1"/></td>
				<td>
<span class = "code">
	<span class = "keyword">pred</span> replace(m, m':Map, k:Key, v':Value) { 
		<span class = "keyword">some</span> v:Value | 
			v != v' <span class = "keyword">and</span> k -> v in m.values <span class = "keyword">and</span> m'.values = m.values - k->v + k -> v'
	}
</span>
				</td>
			<tr>
			</table>
		<br/>
		<input type="submit" value="Submit">
		</form>
	</div>

<!-- END QUESTION -->



<?php
		return 1;
}
 
function answer($option) {
 ?>
<!-- START ANSWER -->



		<div class="test_explain">
	<?php 	if ($option == 0) {	?>

		This does not work: If there is a <span class = "code">Value</span> <span class = "code">v != v'</span> s.t. <span class = "code">k -> v</span> is in <span class = "code">m.values</span>, then <span class = "code">m'.values</span> would map both <span class = "code">v</span> and <span class = "code">v'</span> to <span class = "code">k</span>. This is impossible because of the use of <span class = "keyword">lone</span> in the definition of <span class = "code">values</span>. 

	<?php }	else if ($option == 1) {	?>

		The first solution does not work: If there is a <span class = "code">Value</span> <span class = "code">v != v'</span> s.t. <span class = "code">k -> v</span> is in <span class = "code">m.values</span>, then <span class = "code">m'.values</span> would map both <span class = "code">v</span> and <span class = "code">v'</span> to <span class = "code">k</span>. This is impossible because of the use of <span class = "keyword">lone</span> in the definition of <span class = "code">values</span>. Removing the existing mapping first avoids this problem. 

	<?php } ?>

		</div>

	

<!-- END ANSWER -->

<?php

}

?>

<?php
include "questions_template.php";
?>
