#!/usr/bin/php
<?php function main() { ?>

<div class="normal_text">

<table width="100%" cellpadding="15" border="0">
	<tr>

		<td align="center">
		<img src="Images/confusion.gif">
		</td>

		<td valign="center">

		
		<span class="sub_title">Philosophy</span>
		<br/><br/>

		Software development is difficult; 
		choosing correct abstractions to base your 
		design around is a tricky process! Quite often 
		apparently simple and robust designs can turn 
		out to be incoherent and even inconsistent 
		when you come to implement them.

		<br/><br/>

		One way to avoid this problem of 
		"wishful thinking" as well as making 
		software development more straightforward 
		is through formal specification. This method 
		approaches software abstraction head-on using 
		precise and unambiguous notation, one such 
		example is the declarative language Z.

		<br/><br/>

		Naturally this is not fool proof either though; 
		proving your specification is correct/sound requires 
		a substantial amount of effort. Whilst conventional 
		theorem based analysis tools have improved, their 
		level of automation is still relatively poor 
		compared to model checkers.

		<br/><br/>

		Hence, Alloy was developed in the hope of adapting a 
		declarative language like Z to bring in fully automatic 
		analysis. To do this Alloy sacrifices the ability to 
		totally prove a system's correctness. Rather, it attempts
		to find counterexamples within a limited scope that violate 
		the constraints of the system. Thus by combining the 
		best of both worlds Alloy produces a rigorous model 
		that gives the user immediate feedback
		</td>
	
	</tr>

	<tr>
	
		<td width="200" valign="center">
		<b>Main Developer</b>

		<br />

		Professor Daniel Jackson<br />
		<a href="http://people.csail.mit.edu/dnj/" target=_blank>
		<p align="center"><img src="Images/daniel_jackson.jpg"></p>
		</a></td>

		<td valign="center">

		<span class="sub_title">History</span>
		<br/><br/>

		The design was done by the Software Design Group at MIT 
		lead by Professor Daniel Jackson. In 1997 they produced 
		the first Alloy prototype, which was then a rather limited 
		object modelling language. Over the years Alloy has developed 
		into a full structural modelling language capable of expressing 
		complex structural constraints and behaviour.

		<br/><br/>

		By employing first order logic, Alloy is able to translate 
		specifications into large Boolean expression that can be 
		automatically analyzed by SAT solvers. Thus when given a logical 
		formula (in Alloy), the Alloy Analyzer can attempt to find a 
		model which satisfies it.

		<br/><br/>

		One of the great benefits this lends to Alloy is the ability of 
		incremental analysis. A programmer may explore design ideas starting 
		from a tiny model which is then scaled up, with Alloy able to 
		analyse it at every step.

		<br/><br/>

		Alloy has gradually improved in performance and scalability and been 
		applied to many fields including scheduling, cryptography and 
		instant messaging. 
		</td>

	</tr>

</table>

<br/>

<p>
<span class="sub_title"><a name="Links">Links</a></span>

<br/><br/>

For more information on Alloy, we recommend the following:

<ul>
	<li> 	
		<a href="http://alloy.mit.edu/" target="_blank">
		Alloy MIT Website
		</a> 
	</li>

	<li>
	 	<a href="http://alloy.mit.edu/tutorial3/alloy-tutorial.html" target="_blank">
		In-depth Online Tutorial
		</a>
	</li>

	<li> 
		<a href="http://mitpress.mit.edu/catalog/item/default.asp?ttype=2&tid=10928&mode=toc" target="_blank">
		Software Abstractions by Daniel Jackson
		</a>
	</li>
</ul>

</p>

<br/>

<p>
<span class="sub_title"><a name="Downloads">Downloads</a></span>

<br/><br/>

You can download the Alloy Analyzer from the following sources:

<ul>
	<li> 	
		<a href="http://alloy.mit.edu/alloy4/alloy4.dmg">
		Mac OS X
		</a> 
	</li>

	<li>
	 	<a href="http://alloy.mit.edu/alloy4/alloy4.jar">
		All Others
		</a>
	</li>
</ul>

</p>

</div>

<?php } include 'template.php'; ?>