#!/usr/bin/php
<?php
	session_start();
	function question() {
?>

<!-- START QUESTION -->

	<div class="test_question">
	A tree can be implemented in Alloy as below:

	<table cellpadding="10" width="100%">
		<tr>
			<td>
<pre><span class="code"><span class="keyword">sig</span> Tree {
	root: <span class="keyword">lone</span> Node,
	successors: Node -> Node
}
<span class="keyword">sig</span> Node {}
<span class="keyword">fact</span> notCyclic { <span class="keyword">no</span> n:Node |
	n <span class="keyword">in</span> n.^(Tree.successors)
}
<span class="keyword">fact</span> binaryTree { <span class="keyword">all</span> n:Node | 
	#n.(Tree.successors) = 2 
	<span class="keyword">or</span> #n.(Tree.successors) = 0
}
<span class="keyword">fact</span> allNodesBelongToOneTree {
	// ???
}
<span class="keyword">fact</span> singleMapping { 
	<span class="keyword">all</span> n,x,y:Node |
		x -> n <span class="keyword">in</span> Tree.successors 
		<span class="keyword">and</span> y -> n <span class="keyword">in</span> Tree.successors
			<span class="keyword">implies</span> x = y
}
<span class="keyword">pred</span> show() {}
<span class="keyword">run</span> show <span class="keyword">for exactly</span> 5 Node, 1 Tree</span></pre>
			</td>

			<td>
			<img src="Images/Tree_Q6.jpg">
			</td>
		<tr>
	</table>

	<p>
	Which one of the following is the correct implementation of the fact: allNodesBelongToOneTree?
	</p>

	</div>

	<div class="test_option">
		<form action="<?php echo $_SERVER["PHP_SELF"]; ?>" method="post" name = "test_form">
			<input type="radio" name="option" value="0"> all n: Node | one t:Tree  | n in t.root.*(t.successors)
			<br>
			<input type="radio" name="option" value="1"> all n: Node | some t:Tree | n in t.root.*(t.successors)
			<br>
			<input type="radio" name="option" value="2"> all n: Node | some t:Tree  | n in t.root.^(t.successors)
			<br>
			<br>
			<input type="submit" value="Submit">
		</form>
	</div>

<!-- END QUESTION -->



<?php
		return 0;
}
 
function answer($option) {
 ?>
<!-- START ANSWER -->



		<div class="test_explain">
	<?php 	if ($option == 0) {	?>
		
		This is the correct answer! <br/>
		All nodes are in one tree including the root node.

	<?php }	else if ($option == 1) {	?>
		
		This is an incorrect answer! <br/>
		Look carefully, do we don't want some tree but in fact one tree.

	<?php }	else if ($option == 2) {	?>
		
		This is an incorrect answer! <br/>
		Careful when deciding between ^ and *, they are non-reflexive and reflexive respectively.
	

	<?php } ?>

		</div>

	

<!-- END ANSWER -->

<?php

}

?>

<?php
include "questions_template.php";
?>
