#!/usr/bin/php
<?php
	session_start();
	function question() {
?>

<!-- START QUESTION -->

	<div class="test_question">
		Which of the following is a counterexample to the following assertion (This is an abridged version of an example taken from <a href="http://alloy.mit.edu/tutorial3/maintext-FS-I.html">http://alloy.mit.edu/tutorial3/maintext-FS-I.html</a>)?
		<br/>
		<br/>
		<span class = "code">
	<span class = "keyword">sig</span> Node {
		next: <span class = "keyword">lone</span> Node, 
		prev: <span class = "keyword">lone</span> Node
	}
	<span class = "keyword">sig</span> Head <span class = "keyword">extends</span> Node {}
	
	<span class = "keyword">fact</span> exactlyOneHead { <span class = "keyword">one</span> Head }
	<span class = "keyword">fact</span> headHasNoPrev { <span class = "keyword">no</span> Head.prev }
	<span class = "keyword">fact</span> prevIsInverseOfNext { <span class = "keyword">all</span> n:Node | n.next.prev = n }
	
	<span class = "keyword">assert</span> acyclic { no n:Node | n in n.^next }
	<span class = "keyword">check</span> acyclic <span class = "keyword">for</span> 5
		</span>
	</div>

	<div class="test_option">
		<form action="<?php echo $_SERVER["PHP_SELF"]; ?>" method="post" name = "test_form">
			<table cellspacing = "10" cellpadding = "15">
				<tr>
					<td valign = "top"><input type="radio" name="option" value="0"/>
					<img align = "top" src = "Images/Question_3_1.png"/></td>
					<td valign = "top"><input type="radio" name="option" value="1"/>
					<img align = "top" src = "Images/Question_3_2.png"/></td>
					<td valign = "top"><input type="radio" name="option" value="2"/>
					None. The assertion is valid. </td>
				</tr>
			</table>
	<input type="submit" value="Submit">
 	</form>

	

<!-- END QUESTION -->



<?php
		return 2;
}
 
function answer($option) {
 ?>
<!-- START ANSWER -->



		<div class="test_explain">
	<?php 	if ($option == 0) {	?>

		Wrong. This is not an instance of the above model as it violates <span class = "code">prevIsInverseOfNext</span>: <span class = "code">Head</span> is defined but <span class = "code">Head.next.prev</span> is undefined. 

	<?php }	else if ($option == 1) {	?>

		Wrong. This is not an instance of the above model as it violates <span class = "code">headHasNoPrev</span>. 

	<?php }	else if ($option == 2) {	?>

		This is the correct aswer! Here is an informal explanation: Assume there is a cycle. Then when we traverse the nodes, we will eventually get back to a node that we have already visited. This node cannot be the <span class = "code">Head</span> by <span class = "code">headHasNoPrev</span>. Also, it cannot be a non-<span class = "code">Head</span> node as this would mean that it that has two <span class = "code">prevs</span>. As a node can have at most one <span class = "code">prev</span>, this shows that there cannot be a cycle. 

	<?php } ?>

		</div>

	

<!-- END ANSWER -->

<?php

}

?>

<?php
include "questions_template.php";
?>
