#!/usr/bin/php
<?php function main() { ?>

<div class="normal_text">
In this tutorial, we will be using Alloy to model a linked list implementation of a Queue: Every queue has a root node and each node has a reference to the next node in the queue.

<br/><br/>

Each Alloy model starts with the <span class="keyword">module</span> declaration:

<pre><span class="code">	<span class="keyword">module</span> examples/tutorial/Queue
</pre></span>

This is similar to declaring a class Queue in the package examples.tutorial in Java. Similar to Java, the file should be named 'Queue.als' and be located in the subfolder examples/tutorial of the project folder. 

<br/><br/>

The first step is to declare the <span class="keyword">signature</span> for the queue and its nodes:

<pre><span class="code">	<span class="keyword">sig</span> Queue { root: <span class="keyword">lone</span> Node }
	<span class="keyword">sig</span> Node { next: <span class="keyword">lone</span> Node }
</pre></span>

You can think of root and next as being fields of type Node. <span class="keyword">lone</span> is a multiplicity keyword which indicates that each Queue has less than or equal to one root (similarly for next). 

<br/><br/>

A <span class="keyword">signature</span> in Alloy is similar to the <span class="keyword">signature</span> of a schema in that it defines the vocabulary for the model.

<br/><br/>

We can already visualize what we have written so far. The common way of doing this is to write a predicate and then make Alloy produce instances that satisfy this predicate.  Asking Alloy to find instances is similar to finding a model of a given schema.
 
<br/><br/>

Because we want any instance of the Queue so far, the predicate has no constraints:

<pre><span class="code">	<span class="keyword">pred</span> show() {}
</pre></span>

To get sample instances of the predicate we use the command <span class="keyword">run</span>:

<pre><span class="code">	<span class="keyword">run</span> show for 2
</pre></span>

A very important fact about Alloy is that it is only designed to search for instances within a <span class="emphasis"><a name = "finite_scope">finite scope</a></span>. In the above case this scope is set to at most 2 objects in each signature(i.e. at most two Queues and at most two Nodes). Note that this is always an upper bound; Alloy may return a smaller instance.

<br/><br/>

In order to produce and visualize an instance, we first execute the <span class="keyword">run</span> command by clicking on the Execute button. After the execution has finished, Alloy will tell us that it has found an instance which we can visualize by clicking on the Show button. 

<table border="0" width="100%">

	<tr>
		<td align="left" width="50%">
		<div><pre><span class="code">	<span class="keyword">module</span> examples/tutorial/Queue
	
	<span class="keyword">sig</span> Queue { root: Node }
	<span class="keyword">sig</span> Node { next: <span class="keyword">lone</span> Node }
	<span class="keyword">pred</span> show() {}
	<span class="keyword">run</span> show for 2
</pre></span></div>
		</td>
		<td>
		<div>
		<img src="Images/Example_01.jpg">
		</div>
		</td>
	</tr>

</table>

In the above image, we see that Node1 is its own successor. As this is not what we usually expect from a linked list, we add a <span class="keyword">fact</span> to constrain our model: 

<pre><span class="code">	<span class="keyword">fact</span> nextNotReflexive { <span class="keyword">no</span> n:Node | n = n.next }
</pre></span>

Facts in Alloy are 'global' in that they always apply and they correspond to the axioms of a schema. When Alloy is searching for instances it will discard any that violate the facts of the model. The constraint above can be read just like in first order logic: there is no Node n that is equal to its successor.

<br/><br/>

Executing <span class="keyword">run</span> <span class = "code">show</span> now produces the following instance:

<table border="0" width="100%">

	<tr>
		<td align="left" width="50%">
		<div>
		<pre>
<span class="code">	<span class="keyword">module</span> examples/tutorial/Queue
	
	<span class="keyword">sig</span> Queue { root: Node }
	<span class="keyword">sig</span> Node { next: <span class="keyword">lone</span> Node }
	<span class="keyword">fact</span> nextNotReflexive { <span class="keyword"><span class="keyword">no</span></span> n:Node | n = n.next }
	<span class="keyword">pred</span> show() {}
	<span class="keyword">run</span> show for 2
		</span></pre></div>
		</td>
		
		<td>
		<div>
		<img src="Images/Example_02.jpg">
		</div>
		</td>
	</tr>

</table>

We no longer have a Node that is its own successor, but now notice another problem of our model: There are Nodes that do not belong to any Queue. 
</div>

<?php } include 'template.php'; ?>
