#!/usr/bin/php
<?php function main() { ?>

<div class="normal_text">

To address the issue of nodes that do not belong to any queues, we add another <span class="keyword">fact</span>:

<span class="code"><pre>
	<span class="keyword">fact</span> allNodesBelongToSomeQueue {
		<span class="keyword">all</span> n:Node | <span class="keyword">some</span> q:Queue | n <span class="keyword">in</span> q.root.*next
	}
</pre></span>

<span class="keyword">all</span> and <span class="keyword">some</span> behave exactly like the forall and exists quantifiers in predicate logic. The .* operator represents the <span class = "emphasise_text">reflexive transitive closure</span>: It returns the set consisting of all elements 

<span class="code"><pre>
	q.root, 
	q.root.next, 
	q.root.next.next, 
	...
</pre></span>

If we press Execute, Alloy tells us that it found an instance. However, when we ask it to visualize the instance, it tells us that every atom is hidden. In order to get the next solution, we click Next at the top. Browsing through the instances, we find that one of them contains a cycle:

<table border="0" width="100%">

	<tr>
		<td align="left" width="50%">
		<div>
		<span class="code"><pre>
	<span class="keyword">module</span> examples/tutorial/Queue
	
	<span class="keyword">sig</span> Queue { root: Node }
	<span class="keyword">sig</span> Node { next: <span class="keyword">lone</span> Node }
	<span class="keyword">fact</span> nextNotReflexive { <span class="keyword">no</span> n:Node | n = n.next }
	<span class="keyword">fact</span> allNodesBelongToSomeQueue {
		<span class="keyword">all</span> n:Node | <span class="keyword">some</span> q:Queue | n <span class="keyword">in</span> q.root.*next 
	}
	
	<span class="keyword">pred</span> show() {}
	<span class="keyword">run</span> show for 2
</pre></span></div>
		</td>

		<div>
		<td>
		<img src="Images/Example_04.jpg">
		</td>
		</div>
	</tr>

</table>

In order to fix our model we add another <span class="keyword">fact</span>:

<span class="code"><pre>
	<span class="keyword">fact</span> nextNotCyclic { <span class="keyword">no</span> n:Node | n <span class="keyword">in</span> n.^next }
</pre></span>

In contrast to the .* operator, .^ represents the <span class = "emphasise_text">non-reflexive transitive closure</span> which returns the set consisting of all elements:

<span class="code"><pre>
	n.next, 
	n.next.next, 
	n.next.next.next, 
	...
</pre></span>

(Note that this set does not include n itself). 

<br/><br/>

Executing, visualizing and browsing through a few instances, we spot another error: 

<br/>

<table border="0" width="100%">

	<tr>
		<td align="left" width="50%">
		<div><pre>
	<span class="keyword">module</span> examples/tutorial/Queue
	
	<span class="keyword">sig</span> Queue { root: Node }
	<span class="keyword">sig</span> Node { next: <span class="keyword">lone</span> Node }
	<span class="keyword">fact</span> nextNotReflexive { <span class="keyword">no</span> n:Node | n = n.next }
	<span class="keyword">fact</span> allNodesBelongToSomeQueue {
		<span class="keyword">all</span> n:Node | <span class="keyword">some</span> q:Queue | n <span class="keyword">in</span> q.root.*next
	}
	<span class="keyword">fact</span> nextNotCyclic { <span class="keyword">no</span> n:Node | n <span class="keyword">in</span> n.^next }
	
	<span class="keyword">pred</span> show() {}
	<span class="keyword">run</span> show for 2
</pre></span></div>
		</td>

		<div>
		<td>
		<img src="Images/Example_03.jpg">
		</td>
		</div>
	</tr>

</table>

The problem here is that Node0 belongs to two different queues. This is because <span class = "code">allNodesBelongToSomeQueue</span> constrains a Node to belong to <span class="keyword">some</span> Queue while it should actually belong to exactly one. To fix this we modify the <span class="keyword">fact</span>:

<span class="code"><pre>
	<span class="keyword">fact</span> allNodesBelongToOneQueue {
		<span class="keyword">all</span> n:Node | <span class="keyword">one</span> q:Queue | n <span class="keyword">in</span> q.root.*next
	}
</pre></span>

Browsing through the instances for this version of the model, Alloy soon tells us that 'there are no more satisfying instances'. All the solutions found within the scope provided seem to be correct. To gain more confidence, we increase the scope further:

<span class="code"><pre>
	<span class="keyword">run</span> show for 3
</pre></span>

Still, we cannot find any instances that clash with our definition of a linked list and conclude that this seems to be a good model for a linked list implementation of a queue. However, note that this does not prove that our model is correct! We can only guarantee that it corresponds with our definition for at most three Queues and three Nodes. As Alloy only ever searches a finite scope, it never allows you to prove that your model is correct. However, you can gain a fair amount of confidence that the main errors have been eliminated. 

<br/><br/>

Now that we have seen how to model the static aspects of a system, we will move on to modelling dynamic behaviour and adding operations. For this, we will consider a different example. </div>

</div>


<?php 
}
include ('template.php');
 ?>
