#!/usr/bin/php
<?php function main() { ?>

<div class = "normal_text">

We will proceed to adding dynamic behaviour to our model. In particular, we will define the operation of adding entries to the <span class = "code">Map</span>:

<pre>	<span class="code"><span class="keyword">pred</span> put(m, m':Map, k:Key, v:Value) { m'.values = m.values + k -> v }</span></pre>

This is very similar to an operation schema in Object-Z: the instances of <span class = "code">put</span> consist of the state before(<span class = "code">m</span>), inputs(<span class = "code">v</span>), state after(<span class = "code">m'</span>) and outputs of the operation. As in Object-Z, the convention is to use <span class = "code">'</span> to decorate the state after the operation.

<br/><br/>

<span class = "code">+</span> is the <span class = "emphasise_text">set union operator</span>. The above constraint therefore reads as:

<br/>

<pre><span class="emphasise_text">		"The set of values after is equal to the union of the set of values before with the extra mapping from k to v"</span></pre>

(Note how <span class = "code">m.values</span> is again treated as a set of tuples).

<br/><br/>

We execute this predicate with the usual command:

<br/>

<pre><span class = "code">	<span class = "keyword">run</span> put <span class = "keyword">for</span> 3 but <span class = "keyword">exactly</span> 2 Map, <span class = "keyword">exactly</span> 1 Key, <span class = "keyword">exactly</span> 1 Value
</span></pre>
Alloy produces the following instance which illustrates the functionality of the <span class = "code">put</span> operation:
	<table width="100%" cellpadding="10">
		<tr>
			<td rowspan="2" width="50%"><div>
			<pre><span class="code"><span class="keyword">module</span> examples/tutorial/Map
<span class="keyword">abstract</span> <span class="keyword">sig</span> Object {}
<span class="keyword">sig</span> Key, Value <span class="keyword">extends</span> Object {}
<span class="keyword">sig</span> Map {
	values: Key -> <span class="keyword">lone</span> Value
}
<span class="keyword">assert</span> mappingIsUnique {
	<span class="keyword">all</span> m:Map, k:Key, v, v':Value |
		k -> v <span class="keyword">in</span> m.values 
		<span class="keyword">and</span> k -> v' <span class="keyword">in</span> m.values
			<span class="keyword">implies</span> v = v'
}
<span class="keyword">pred</span> put(m, m':Map, k:Key, v:Value) { 
	m'.values = m.values + k -&gt; v 
}
<span class="keyword">run</span> put <span class="keyword">for</span> 3 but <span class="keyword">exactly</span> 2 Map, 
<span class="keyword">exactly</span> 1 Key, <span class="keyword">exactly</span> 1 Value

			</span></pre></div>
			</td>

			<td align="center">
			<img src="Images/Example_2_03.jpg"/>
			<br/>
			<div class="image_caption">State before</div>
			</td>

			<td align="center">
			<img src="Images/Example_2_04.jpg"/>
			<div class="image_caption">State after</div>
			</td>
		</tr>
	</table>

The assertion <span class = "code">putLocal</span> checks that <span class = "code">put</span> does not change the existing mappings in the set:

<pre><span class = "code">	<span class = "keyword">assert</span> putLocal {
		<span class = "keyword">all</span> m, m': Map, k, k': Key, v: Value |
			put[m,m',k,v] and k != k' <span class = "keyword">implies</span>
				lookup[m,k'] = lookup[m',k']
	}
	<span class = "keyword">fun</span> lookup(m: Map, k: Key): <span class = "keyword">set</span> Value { k.(m.values) }
</span></pre>

<span class = "code">lookup</span> is an example of a <span class = "emphasise_text">function</span> in Alloy. It uses the <a name = "dot_operator"><span class = "code">.</span> operator</a> to return all values that are associated with the <span class = "code">Key</span> <span class = "code">k</span> in the <span class = "code">Map</span> <span class = "code">m</span>, i.e. the set <span class = "code">{v | (k, v) in m.values}</span>. Note that the arguments to a function are enclosed in square brackets <span class = "code">[]</span>. This is new in Alloy 4; in older versions (such as the one used in the official tutorial on the MIT website), they were enclosed in parentheses (). 
<br/>
<br/>
We check that the assertion holds as before:

<pre><span class = "code">	<span class = "keyword">check</span> putLocal
</span></pre>

Alloy informs us that no counter-examples were found. This is also the case if we increase the scope (to 15, say). Confident that our assertion may be valid, we stop here. 
<br/>
<br/>
This already marks the end of our short tutorial. If you want to learn more about Alloy, we suggest looking at the following excellent resources:
<ul>
	<li>
	 	<a href="http://alloy.mit.edu/alloy4/tutorial4" target="_blank">Official MIT Online Tutorial</a>, in particular
	<ul>
		<li><a href="http://alloy.mit.edu/alloy4/tutorial4/sidenote-levels-of-understanding.html">3 levels of understanding an Alloy model</a> explains what fields really are in Alloy (highly recommended!)</li>
		<li><a href="http://alloy.mit.edu/alloy4/tutorial4/sidenote-relations-are-ordered-pairs.html">Relations as Ordered Tuples</a> is a recap on relations and how to find the "inverse" of a relation</li>
		<li><a href="http://alloy.mit.edu/alloy4/tutorial4/sidenote-relations-everywhere.html">Everything in Alloy is a relation</a> gives you an insight into how Alloy works behind the scenes. </li>
	</ul>
	</li>

	<li> 
		<a href="http://mitpress.mit.edu/catalog/item/default.asp?ttype=2&amp;tid=10928&amp;mode=toc" target="_blank">
		Software Abstractions by Daniel Jackson
		</a>
		<ul>
			<li>
				<a href="http://www.cs.ucl.ac.uk/staff/e.letier/teaching/GS03/alloy/" target="_blank" >Solutions for the exercises in the book</a> (<a href="http://www.cs.ucl.ac.uk/staff/e.letier/teaching/GS03/" target="_blank">Dr. Emmanuel Letier</a>, University College London)
			</li>
		</ul>
	</li>
</ul>
</div>

<?php } include 'template.php'; ?>
