/*
 * Decompiled with CFR 0.152.
 */
package directedsaucy;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import utilities.CommunicatingProcess;
import utilities.Config;

public class DirectedSaucy {
    private static int noNodes;

    private static void convertToUndirectedForm(BufferedReader br, FileWriter fw) throws IOException {
        String line = br.readLine();
        StringTokenizer strtok = new StringTokenizer(line, " ");
        noNodes = Integer.parseInt(strtok.nextToken());
        fw.write(String.valueOf(noNodes * 3) + " ");
        if (!strtok.hasMoreTokens()) {
            line = br.readLine();
            strtok = new StringTokenizer(line, " ");
        }
        fw.write(String.valueOf(Integer.parseInt(strtok.nextToken()) * 3) + " ");
        if (!strtok.hasMoreTokens()) {
            line = br.readLine();
            strtok = new StringTokenizer(line, " ");
        }
        int noColourClasses = Integer.parseInt(strtok.nextToken());
        fw.write(String.valueOf(noColourClasses + 2) + " ");
        int i = 0;
        while (i < noColourClasses - 1) {
            if (!strtok.hasMoreTokens()) {
                line = br.readLine();
                strtok = new StringTokenizer(line, " ");
            }
            fw.write(String.valueOf(strtok.nextToken()) + " ");
            ++i;
        }
        fw.write(String.valueOf(noNodes) + " " + noNodes * 2 + " ");
        while (true) {
            if (!strtok.hasMoreTokens()) {
                line = br.readLine();
                if (line == null) break;
                strtok = new StringTokenizer(line, " ");
                fw.write("\n");
            }
            i = Integer.parseInt(strtok.nextToken());
            if (!strtok.hasMoreTokens()) {
                line = br.readLine();
                if (line == null) break;
                strtok = new StringTokenizer(line, " ");
                fw.write("\n");
            }
            int j = Integer.parseInt(strtok.nextToken());
            fw.write(String.valueOf(i) + " " + (i + noNodes) + " ");
            fw.write(String.valueOf(i + noNodes) + " " + (j + 2 * noNodes) + " ");
            fw.write(String.valueOf(j + 2 * noNodes) + " " + j + " ");
            if (strtok.hasMoreTokens()) continue;
            line = br.readLine();
            if (line == null) break;
            strtok = new StringTokenizer(line, " ");
        }
        br.close();
        fw.close();
    }

    private static String throwAwayExcess(String generator) {
        StringTokenizer strtok = new StringTokenizer(generator, "(");
        String result = "";
        while (strtok.hasMoreTokens()) {
            String cycle = strtok.nextToken();
            StringTokenizer cycleSplitter = new StringTokenizer(cycle, " ");
            if (Integer.parseInt(cycleSplitter.nextToken()) >= noNodes) continue;
            result = String.valueOf(result) + "(" + cycle;
        }
        return result;
    }

    private static String getGeneratorsRestrictedToOriginalNodes(Process saucy) {
        BufferedReader br = CommunicatingProcess.getReader(saucy);
        String generators = "";
        try {
            String temp;
            while ((temp = br.readLine()) != null) {
                String newGenerator = DirectedSaucy.throwAwayExcess(temp);
                if (newGenerator.equals("")) continue;
                generators = String.valueOf(generators) + newGenerator + "\n";
            }
            br.close();
        }
        catch (IOException ioe) {
            System.out.println("Error while getting output from saucy");
            ioe.printStackTrace();
        }
        return generators;
    }

    public static String computeAutomorphismsOfDirectedGraph(String filename) {
        try {
            DirectedSaucy.convertToUndirectedForm(new BufferedReader(new FileReader(filename)), new FileWriter(String.valueOf(Config.tempFiles()) + "undirectedrepresentation.saucy"));
            Process saucy = Config.isOSWindows() ? CommunicatingProcess.create(String.valueOf(Config.saucy()) + " \"" + Config.tempFiles() + "undirectedrepresentation.saucy\"") : CommunicatingProcess.create(String.valueOf(Config.saucy()) + " " + Config.tempFiles() + "undirectedrepresentation.saucy");
            return DirectedSaucy.getGeneratorsRestrictedToOriginalNodes(saucy);
        }
        catch (FileNotFoundException e) {
            System.out.println("Input file for saucy not found");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("Error reading input for saucy");
            e.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("One argument must be supplied: the name of the input file for a directed graph");
        } else {
            System.out.println(DirectedSaucy.computeAutomorphismsOfDirectedGraph(args[0]));
        }
    }
}

