/*
 * Decompiled with CFR 0.152.
 */
package promela;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PushbackReader;
import promela.checker.Checker;
import promela.error.ErrorTable;
import promela.lexer.Lexer;
import promela.node.Node;
import promela.parser.Parser;

public class Check {
    protected Node theAST;
    protected String sourceName;

    public Check(String sourceName) {
        this.sourceName = sourceName;
        Lexer scanner = null;
        try {
            scanner = new Lexer(new PushbackReader(new BufferedReader(new FileReader(sourceName)), 1024));
        }
        catch (FileNotFoundException e) {
            System.out.println("Can't access source file " + sourceName);
            System.exit(1);
        }
        Parser parser = new Parser(scanner);
        try {
            this.theAST = parser.parse();
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(1);
        }
    }

    public boolean isWellTyped(boolean isPidSensitive) {
        Checker chk = new Checker(isPidSensitive);
        this.theAST.apply(chk);
        chk.unify();
        ErrorTable errorTable = chk.getErrorTable();
        if (errorTable.hasErrors()) {
            System.out.println(errorTable.output("while processing " + this.sourceName));
            return false;
        }
        System.out.println("Program is well typed");
        return true;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: check filename");
            System.exit(1);
        }
        boolean isPidSensitive = args.length > 1 && args[1].equals("-symm");
        new Check(args[0]).isWellTyped(isPidSensitive);
    }
}

