/*
 * Decompiled with CFR 0.152.
 */
package promela;

import directedsaucy.DirectedSaucy;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.Iterator;
import junit.framework.Assert;
import promela.Check;
import promela.checker.Checker;
import promela.group.Group;
import promela.group.Permutation;
import promela.lexer.Lexer;
import promela.parser.Parser;
import promela.staticchanneldiagram.InlineReplacer;
import promela.staticchanneldiagram.ProcessAndChannelLiteralsDecorator;
import promela.staticchanneldiagram.StaticChannelDiagramExtractor;
import promela.staticchanneldiagram.TextualAdjacencyDiagramExtractor;
import promela.unifier.Substituter;
import utilities.CommunicatingProcess;
import utilities.Config;

public class Extract
extends Check {
    private int noOfRandomConjugates = 0;
    private long timeBound = 10000L;
    protected Process gap;

    public Extract(String sourceName) throws IOException {
        super(sourceName);
        System.out.println("Starting GAP");
        this.gap = Config.isOSWindows() ? CommunicatingProcess.create(String.valueOf(Config.gap()) + " -L \"" + Config.common() + "gapworkspace\" -q") : CommunicatingProcess.create(String.valueOf(Config.gap()) + " -L " + Config.common() + "gapworkspace -q");
        BufferedReader br = CommunicatingProcess.getReader(this.gap);
        BufferedWriter bw = CommunicatingProcess.getWriter(this.gap);
        bw.write("0;\n");
        bw.flush();
        while (!br.readLine().equals("0")) {
        }
    }

    private StaticChannelDiagramExtractor extract(String detectionStrategy) throws IOException {
        return this.extract(detectionStrategy, 0);
    }

    public StaticChannelDiagramExtractor extract(String detectionStrategy, int noOfRandomConjugates) throws IOException {
        Assert.assertTrue(detectionStrategy.equals("scd") || detectionStrategy.equals("iad"));
        this.noOfRandomConjugates = noOfRandomConjugates;
        StaticChannelDiagramExtractor extractor = new StaticChannelDiagramExtractor();
        if (this.isWellTyped(true)) {
            Group autos;
            System.out.println("Reparsing source without inlines");
            this.reparseSourceWithoutInlines();
            this.theAST.apply(extractor);
            Substituter substituter = extractor.unify();
            this.applyTypeSubstitutions(extractor, substituter);
            if (detectionStrategy.equals("scd")) {
                autos = this.computeStaticChannelDiagramAutomorphisms(extractor);
                System.out.println("  Aut(C(P)) = " + autos);
            } else {
                autos = this.computeTextualAdjacencyDiagramAutomorphisms(extractor);
                System.out.println("  Aut(T(P)) = " + autos);
            }
            this.computeLargestValidSubgroup(extractor, autos);
            return extractor;
        }
        return null;
    }

    private Group computeTextualAdjacencyDiagramAutomorphisms(StaticChannelDiagramExtractor extractor) {
        System.out.println("Extracting textual adjacency diagram");
        extractor.directedSaucyRepresentation();
        ProcessAndChannelLiteralsDecorator decorator = new ProcessAndChannelLiteralsDecorator(extractor);
        this.theAST.apply(decorator);
        TextualAdjacencyDiagramExtractor edgeCollector = new TextualAdjacencyDiagramExtractor(decorator);
        this.theAST.apply(edgeCollector);
        try {
            String temp;
            FileWriter fw = new FileWriter(String.valueOf(Config.tempFiles()) + "graph.saucy");
            fw.write(edgeCollector.saucyRepresentation(extractor));
            fw.close();
            System.out.println("Computing the group Aut(T(P)) using saucy");
            Process saucy = CommunicatingProcess.create(String.valueOf(Config.saucy()) + " " + Config.tempFiles() + "graph.saucy");
            try {
                saucy.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            BufferedReader br = CommunicatingProcess.getReader(saucy);
            String generators = "";
            while ((temp = br.readLine()) != null) {
                generators = String.valueOf(generators) + temp + "\n";
            }
            br.close();
            return Group.createGroupWithSaucyGenerators(generators, extractor);
        }
        catch (IOException ioe) {
            System.out.println("Error while getting output from saucy");
            ioe.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    protected void reparseSourceWithoutInlines() {
        InlineReplacer inlineReplacer = new InlineReplacer();
        this.theAST.apply(inlineReplacer);
        String inlinedSourceProgram = inlineReplacer.getInlinedProgram();
        this.parseInputString(inlinedSourceProgram);
    }

    private Group computeLargestValidSubgroup(StaticChannelDiagramExtractor extractor, Group autos) throws IOException {
        Group result = null;
        System.out.println("Computing safe generators");
        String safeGenerators = this.computeBaseGroupGenerators(extractor, autos);
        BufferedReader gapReader = CommunicatingProcess.getReader(this.gap);
        BufferedWriter gapWriter = CommunicatingProcess.getWriter(this.gap);
        this.sendBaseAndOverallGroupsToGAP(autos, safeGenerators, gapWriter);
        this.enlargeBaseGroupWithRandomConjugates(extractor, gapReader, gapWriter);
        this.computeLargestValidSubgroup(extractor, gapReader, gapWriter);
        result = this.getFinalGroupFromGAP(extractor, gapReader, gapWriter);
        return result;
    }

    public void destroyGAP() throws IOException, InterruptedException {
        BufferedWriter gapWriter = CommunicatingProcess.getWriter(this.gap);
        gapWriter.write("quit;\n");
        gapWriter.flush();
        this.gap.waitFor();
        BufferedReader gapReader = CommunicatingProcess.getReader(this.gap);
        gapReader.close();
        gapWriter.close();
        this.gap.destroy();
    }

    private String computeBaseGroupGenerators(StaticChannelDiagramExtractor extractor, Group autos) {
        System.out.print("   ");
        String safeGenerators = "(";
        Iterator i = autos.iterator();
        while (i.hasNext()) {
            Permutation alpha = (Permutation)i.next();
            if (alpha.isSafeFor(this.theAST, extractor)) {
                System.out.print("1");
                safeGenerators = String.valueOf(safeGenerators) + alpha.gapRepresentation() + ",";
                continue;
            }
            System.out.print("0");
        }
        System.out.println("\n");
        safeGenerators = safeGenerators.equals("(") ? "(())" : String.valueOf(safeGenerators.substring(0, safeGenerators.length() - 1)) + ")";
        return safeGenerators;
    }

    private Group getFinalGroupFromGAP(StaticChannelDiagramExtractor channelDiagram, BufferedReader gapReader, BufferedWriter gapWriter) throws IOException {
        gapWriter.write("Print(JoinStringsWithSeparator(GeneratorsOfGroup(H),\"!\"),\"\\n\");\n");
        gapWriter.flush();
        String newGenerators = "";
        String temp = gapReader.readLine();
        while (temp.charAt(temp.length() - 1) == '\\') {
            newGenerators = String.valueOf(newGenerators) + temp.substring(0, temp.length() - 1);
            temp = gapReader.readLine();
        }
        newGenerators = String.valueOf(newGenerators) + temp;
        Group H = Group.createGroupWithGAPGenerators(newGenerators, channelDiagram);
        System.out.println("H = " + H);
        System.out.println("      is a safe group for symmetry reduction.");
        gapWriter.flush();
        return H;
    }

    private void computeLargestValidSubgroup(StaticChannelDiagramExtractor channelDiagram, BufferedReader gapReader, BufferedWriter gapWriter) throws IOException {
        System.out.println("Finding largest valid subgroup");
        gapWriter.write("C := RightTransversal(G,H);;\n");
        gapWriter.write("Size(C);\n");
        gapWriter.flush();
        int noCosets = Integer.parseInt(gapReader.readLine());
        int j = 2;
        long initialTime = System.currentTimeMillis();
        while (j <= noCosets && (this.timeBound == 0L || System.currentTimeMillis() - initialTime < this.timeBound)) {
            Extract.printRepresentative(gapWriter, j);
            if (Extract.nextRepresentative(channelDiagram, gapReader).isSafeFor(this.theAST, channelDiagram)) {
                Extract.addRepresentativeToGenerators(gapWriter, j);
                noCosets = Extract.recomputeCosetRepresentatives(gapReader, gapWriter);
                System.out.println("No cosets: " + noCosets);
                j = 2;
                continue;
            }
            ++j;
        }
    }

    private static Permutation nextRepresentative(StaticChannelDiagramExtractor channelDiagram, BufferedReader gapReader) throws IOException {
        return new Permutation(Permutation.gap_to_nauty(Extract.getRepresentative(gapReader)), channelDiagram);
    }

    private static void printRepresentative(BufferedWriter gapWriter, int j) throws IOException {
        gapWriter.write("C[" + j + "];\n");
        gapWriter.flush();
    }

    private static int recomputeCosetRepresentatives(BufferedReader gapReader, BufferedWriter gapWriter) throws IOException {
        gapWriter.write("C := RightTransversal(G,H);;\n");
        gapWriter.write("Size(C);\n");
        gapWriter.flush();
        int noCosets = Integer.parseInt(gapReader.readLine());
        return noCosets;
    }

    private static String getRepresentative(BufferedReader reader) throws IOException {
        String perm = reader.readLine();
        while (perm.charAt(perm.length() - 1) == ',') {
            perm = String.valueOf(perm) + reader.readLine();
        }
        return perm;
    }

    private static void addRepresentativeToGenerators(BufferedWriter writer, int representativePosition) throws IOException {
        writer.write("H := Group(Concatenation(GeneratorsOfGroup(H),[C[" + representativePosition + "]]));;\n");
    }

    private void sendBaseAndOverallGroupsToGAP(Group autos, String safeGenerators, BufferedWriter bw) throws IOException {
        bw.write("G := " + autos.gapGenerators() + ";\n");
        bw.write("H := Group" + safeGenerators + ";;\n");
    }

    private void enlargeBaseGroupWithRandomConjugates(StaticChannelDiagramExtractor extractor, BufferedReader br, BufferedWriter bw) throws IOException {
        int noOfGens = Extract.findNumberOfGenerators(br, bw);
        this.computeGeneratorConjugates(bw, noOfGens);
        this.addValidConjugatesToBaseGroup(extractor, br, bw, noOfGens);
    }

    private void addValidConjugatesToBaseGroup(StaticChannelDiagramExtractor extractor, BufferedReader br, BufferedWriter bw, int noOfGens) throws IOException {
        int l = 1;
        while (l <= this.noOfRandomConjugates * noOfGens) {
            Permutation pe = new Permutation(Permutation.gap_to_nauty(br.readLine()), extractor);
            if (pe.isSafeFor(this.theAST, extractor)) {
                bw.write("alpha := " + pe.gapRepresentation() + ";;\n");
                bw.write("if (not (alpha in H)) then\n");
                bw.write("H := Group(Concatenation(GeneratorsOfGroup(H),[alpha]));;\n");
                bw.write("fi;;\n");
            }
            ++l;
        }
    }

    private void computeGeneratorConjugates(BufferedWriter bw, int noOfGens) throws IOException {
        int l = 1;
        while (l <= this.noOfRandomConjugates) {
            bw.write("alpha := Random(G);;\n");
            int j = 1;
            while (j <= noOfGens) {
                bw.write("(alpha^-1) * (GeneratorsOfGroup(H)[" + j + "]) * alpha;\n");
                ++j;
            }
            bw.flush();
            ++l;
        }
        bw.flush();
    }

    private static int findNumberOfGenerators(BufferedReader br, BufferedWriter bw) throws IOException {
        bw.write("Size(GeneratorsOfGroup(H));\n");
        bw.flush();
        int noOfGens = Integer.parseInt(br.readLine());
        return noOfGens;
    }

    private Group computeStaticChannelDiagramAutomorphisms(StaticChannelDiagramExtractor extractor) throws IOException {
        FileWriter fw = new FileWriter(String.valueOf(Config.tempFiles()) + "graph.saucy");
        fw.write(extractor.directedSaucyRepresentation());
        fw.close();
        System.out.println("Computing the group Aut(C(P)) using directed saucy.");
        return Group.createGroupWithSaucyGenerators(DirectedSaucy.computeAutomorphismsOfDirectedGraph(String.valueOf(Config.tempFiles()) + "graph.saucy"), extractor);
    }

    protected void applyTypeSubstitutions(Checker chk, Substituter substituter) {
        substituter.setTypeInformation(chk);
        this.theAST.apply(substituter);
    }

    private void parseInputString(String source) {
        Lexer scanner = new Lexer(new PushbackReader(new BufferedReader(new StringReader(source))));
        Parser parser = new Parser(scanner);
        try {
            this.theAST = parser.parse();
        }
        catch (Exception e) {
            System.out.println(e);
            System.exit(1);
        }
    }
}

