/*
 * Decompiled with CFR 0.152.
 */
package promela.checker;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import promela.checker.InlineProcessor;
import promela.env.ChannelEntry;
import promela.env.Env;
import promela.env.EnvEntry;
import promela.env.MtypeEntry;
import promela.env.ProctypeEntry;
import promela.env.TypeEntry;
import promela.env.VarEntry;
import promela.error.AssignmentMismatchError;
import promela.error.ElementDoesNotExistError;
import promela.error.EqMismatchError;
import promela.error.Error;
import promela.error.ErrorTable;
import promela.error.IfCondError;
import promela.error.IfMismatchError;
import promela.error.LiteralValueTooLargeError;
import promela.error.NameAlreadyUsedError;
import promela.error.NoUnsignedOnChannelError;
import promela.error.NoWidthForUnsignedTypeError;
import promela.error.NotBoolError;
import promela.error.NotNumericError;
import promela.error.SubtypingError;
import promela.error.UnsignedTypeInitialisationError;
import promela.error.VariableNotArrayError;
import promela.error.VariableNotChannelError;
import promela.error.VariableNotRecordError;
import promela.error.WidthForNonUnsignedTypeError;
import promela.error.WrongNumArgsError;
import promela.node.AArrayIvar;
import promela.node.AArrayref;
import promela.node.AAssertStmnt;
import promela.node.AAssignmentAssignment;
import promela.node.ABitTypename;
import promela.node.ABoolTypename;
import promela.node.ABreakStmnt;
import promela.node.AByteTypename;
import promela.node.AChanTypename;
import promela.node.AChannelIvarassignment;
import promela.node.AChanopFactor;
import promela.node.AComplementUnExpr;
import promela.node.ACompoundAndExpr;
import promela.node.ACompoundBitandExpr;
import promela.node.ACompoundBitorExpr;
import promela.node.ACompoundBitxorExpr;
import promela.node.ACompoundEqExpr;
import promela.node.ACompoundMultExpr;
import promela.node.ACompoundOrExpr;
import promela.node.ACompoundShiftExpr;
import promela.node.ACompoundgtRelExpr;
import promela.node.ACompoundltRelExpr;
import promela.node.ACompoundminusAddExpr;
import promela.node.ACompoundplusAddExpr;
import promela.node.ACompoundrelopRelExpr;
import promela.node.AConditionalExpr;
import promela.node.AConstFactor;
import promela.node.AConstRecvArg;
import promela.node.ADecrementAssignment;
import promela.node.AElseStmnt;
import promela.node.AEvalRecvArg;
import promela.node.AFalseConst;
import promela.node.AFifoReceive;
import promela.node.AFifoRecvPoll;
import promela.node.AFifoSend;
import promela.node.AFifopollReceive;
import promela.node.AHeadedlistSendArgs;
import promela.node.AHiddenVisible;
import promela.node.AIncrementAssignment;
import promela.node.AIntTypename;
import promela.node.ALengthFactor;
import promela.node.AListSendArgs;
import promela.node.AManyArgLst;
import promela.node.AManyDeclLst;
import promela.node.AManyIvarLst;
import promela.node.AManyNameLst;
import promela.node.AManyRecvArgs;
import promela.node.AManyTypenamelst;
import promela.node.AManyheadedRecvArgs;
import promela.node.AMtype;
import promela.node.AMtypeTypename;
import promela.node.ANonprogressFactor;
import promela.node.ANotUnExpr;
import promela.node.ANumberConst;
import promela.node.AOneArgLst;
import promela.node.AOneDecl;
import promela.node.AOneDeclLst;
import promela.node.AOneIvarLst;
import promela.node.AOneNameLst;
import promela.node.AOneRecvArgs;
import promela.node.AOneTypenamelst;
import promela.node.AParentheseFactor;
import promela.node.APidConst;
import promela.node.APidTypename;
import promela.node.AProctype;
import promela.node.ARandomReceive;
import promela.node.ARandomRecvPoll;
import promela.node.ARandompollReceive;
import promela.node.ARecordVarref;
import promela.node.ARunFactor;
import promela.node.AShortTypename;
import promela.node.ASimpleAddExpr;
import promela.node.ASimpleAndExpr;
import promela.node.ASimpleBitandExpr;
import promela.node.ASimpleBitorExpr;
import promela.node.ASimpleBitxorExpr;
import promela.node.ASimpleEqExpr;
import promela.node.ASimpleExpr;
import promela.node.ASimpleMultExpr;
import promela.node.ASimpleOrExpr;
import promela.node.ASimpleRelExpr;
import promela.node.ASimpleShiftExpr;
import promela.node.ASimpleUnExpr;
import promela.node.ASingleIvar;
import promela.node.ASingleVarref;
import promela.node.ASortedSend;
import promela.node.ATimeoutFactor;
import promela.node.ATrueConst;
import promela.node.AUnameTypename;
import promela.node.AUnderscoreConst;
import promela.node.AUnsignedTypename;
import promela.node.AUtype;
import promela.node.AVarRecvArg;
import promela.node.AVariableIvarassignment;
import promela.node.AVarrefFactor;
import promela.node.AWidth;
import promela.node.Node;
import promela.node.PDeclLst;
import promela.node.PIvar;
import promela.node.PIvarLst;
import promela.node.PIvarassignment;
import promela.node.PNameLst;
import promela.node.PRecvArgs;
import promela.node.PSendArgs;
import promela.node.PTypename;
import promela.node.PVarref;
import promela.node.TBang;
import promela.node.TBangBang;
import promela.node.TName;
import promela.node.Token;
import promela.types.ArrayType;
import promela.types.BoolType;
import promela.types.ChanType;
import promela.types.IncomparableTypesException;
import promela.types.MtypeType;
import promela.types.NumericType;
import promela.types.RecordType;
import promela.types.Type;
import promela.types.TypeVariableFactory;
import promela.types.TypeVariableType;
import promela.types.UnsignedNumericType;
import promela.unifier.ConstraintSet;
import promela.unifier.EqualityConstraint;
import promela.unifier.Substituter;
import promela.unifier.SubtypingConstraint;

public class Checker
extends InlineProcessor {
    private ErrorTable errorTable = new ErrorTable();
    private Env env = new Env();
    private ConstraintSet constraintSet = new ConstraintSet();
    private TypeVariableFactory factory = new TypeVariableFactory();
    protected boolean inTypedef = false;
    private List callStack = new ArrayList();
    private static final String USER_TYPE = "user defined type";
    private static final String PROCTYPE = "proctype";
    private static final String VARIABLE = "variable";
    private static final String FIELD = "field";
    protected ProctypeEntry currentProctype = null;
    private List typedefFieldNames = new ArrayList();
    private List typedefFieldTypes = new ArrayList();
    private int nextPid = 1;

    public Checker(boolean isPidSensitive) {
        NumericType.setPidSensitive(isPidSensitive);
    }

    public ErrorTable getErrorTable() {
        return this.errorTable;
    }

    public EnvEntry getEnvEntry(String name) {
        return this.env.get(name);
    }

    protected void putEnvEntry(String name, EnvEntry entry) {
        this.env.put(name, entry);
    }

    public Env getEnv() {
        return this.env;
    }

    public Substituter unify() {
        return this.constraintSet.unify(this.errorTable);
    }

    public void caseAMtype(AMtype node) {
        PNameLst names = node.getNameLst();
        while (names instanceof AManyNameLst) {
            this.addMtypeNameToEnvironment(((AManyNameLst)names).getName().getText(), node.getMtypetok());
            names = ((AManyNameLst)names).getNameLst();
        }
        this.addMtypeNameToEnvironment(((AOneNameLst)names).getName().getText(), node.getMtypetok());
    }

    private void addMtypeNameToEnvironment(String name, Token tok) {
        if (this.nameExists(name)) {
            this.addError(tok, new NameAlreadyUsedError(name, this.env.get(name)));
        } else {
            this.env.put(name, new MtypeEntry());
        }
    }

    private boolean nameExists(String name) {
        return this.env.get(name) != null;
    }

    public void caseAUtype(AUtype node) {
        this.enterTypedef();
        node.getDeclLst().apply(this);
        String name = node.getName().getText();
        EnvEntry alreadyExists = this.env.putGlobal(name, new TypeEntry(new RecordType(name, this.typedefFieldNames, this.typedefFieldTypes)));
        if (alreadyExists != null) {
            this.addError(node.getName(), new NameAlreadyUsedError(name, alreadyExists));
        }
        this.exitTypedef();
    }

    public void outAOneDecl(AOneDecl node) {
        PIvarLst variables = node.getIvarLst();
        while (variables instanceof AManyIvarLst) {
            this.processVar(((AManyIvarLst)variables).getIvar(), this.getOutType(node.getTypename()), this.isHidden(node));
            variables = ((AManyIvarLst)variables).getIvarLst();
        }
        this.processVar(((AOneIvarLst)variables).getIvar(), this.getOutType(node.getTypename()), this.isHidden(node));
    }

    private boolean isHidden(AOneDecl node) {
        return node.getVisible() instanceof AHiddenVisible;
    }

    public void outABitTypename(ABitTypename node) {
        this.setOut(node, this.bitType());
    }

    public void outAByteTypename(AByteTypename node) {
        this.setOut(node, this.byteType());
    }

    public void outAShortTypename(AShortTypename node) {
        this.setOut(node, this.shortType());
    }

    public void outAIntTypename(AIntTypename node) {
        this.setOut(node, this.intType());
    }

    public void outABoolTypename(ABoolTypename node) {
        this.setOut(node, this.boolType());
    }

    public void outAPidTypename(APidTypename node) {
        this.setOut(node, this.pidType());
    }

    public void outAMtypeTypename(AMtypeTypename node) {
        this.setOut(node, new MtypeType());
    }

    public void outAChanTypename(AChanTypename node) {
        this.setOut(node, new ChanType(this.factory.freshTypeVariable()));
    }

    public void outAUnameTypename(AUnameTypename node) {
        String name = node.getName().getText();
        if (!(this.env.get(name) instanceof TypeEntry)) {
            this.addError(node.getName(), new ElementDoesNotExistError(name, USER_TYPE));
        } else {
            this.setOut(node, ((TypeEntry)this.env.get(name)).getType());
        }
    }

    public void outAUnsignedTypename(AUnsignedTypename node) {
        this.setOut(node, new UnsignedNumericType());
    }

    public void outAAssignmentAssignment(AAssignmentAssignment node) {
        Type leftType = this.getOutType(node.getVarref());
        Type rightType = this.getOutType(node.getExpr());
        if (leftType != null && rightType != null) {
            if (this.isChan(leftType) || this.isChan(rightType)) {
                this.postEqualityConstraint(leftType, rightType, node.getAssign());
            } else if (!rightType.isSubtype(leftType)) {
                this.addError(node.getAssign(), new AssignmentMismatchError(leftType.name(), rightType.name()));
            }
        }
    }

    public void outAIncrementAssignment(AIncrementAssignment node) {
        this.checkForNotNumericError(this.getOutType(node.getVarref()), node.getPlusPlus(), Error.UNARY);
    }

    public void outADecrementAssignment(ADecrementAssignment node) {
        this.checkForNotNumericError(this.getOutType(node.getVarref()), node.getMinusMinus(), Error.UNARY);
    }

    public void outARecordVarref(ARecordVarref node) {
        Type t = this.getOutType(node.getVarref());
        if (t != null) {
            if (!(t instanceof RecordType)) {
                this.addError(node.getDot(), new VariableNotRecordError(t.name()));
            } else {
                Type fieldType = ((RecordType)t).getFieldType(node.getName().getText());
                if (fieldType == null) {
                    this.addError(node.getDot(), new ElementDoesNotExistError(node.getName().getText(), FIELD, t.name()));
                } else if (node.getArrayref() == null) {
                    this.setOut(node, fieldType);
                } else if (fieldType instanceof ArrayType) {
                    this.setOut(node, ((ArrayType)fieldType).getElementType());
                    if (this.getArrayIndexType(node) != null) {
                        this.postEqualityConstraint(((ArrayType)fieldType).getIndexType(), this.getArrayIndexType(node), node.getName());
                    }
                } else {
                    this.addError(node.getDot(), new VariableNotArrayError(node.getName().getText(), fieldType.name()));
                }
            }
        }
    }

    public void outASingleVarref(ASingleVarref node) {
        EnvEntry entry = this.env.get(node.getName().getText());
        if (entry instanceof MtypeEntry && node.getArrayref() == null) {
            this.setOut(node, new MtypeType());
        } else if (!(entry instanceof VarEntry)) {
            this.addError(node.getName(), new ElementDoesNotExistError(node.getName().getText(), VARIABLE));
        } else {
            Type t = ((VarEntry)entry).getType();
            if (this.isArray(t) && this.hasArrayReference(node)) {
                this.setOut(node, ((ArrayType)t).getElementType());
                if (this.getArrayIndexType(node) != null) {
                    this.postEqualityConstraint(((ArrayType)t).getIndexType(), this.getArrayIndexType(node), node.getName());
                }
            } else if (!this.isArray(t) && this.hasArrayReference(node)) {
                this.addError(node.getName(), new VariableNotArrayError(node.getName().getText(), t.name()));
            } else {
                this.setOut(node, t);
            }
        }
    }

    private boolean hasArrayReference(ASingleVarref node) {
        return node.getArrayref() != null;
    }

    private Type getArrayIndexType(ASingleVarref node) {
        return this.getOutType(((AArrayref)node.getArrayref()).getExpr());
    }

    private Type getArrayIndexType(ARecordVarref node) {
        return this.getOutType(((AArrayref)node.getArrayref()).getExpr());
    }

    public void outAArrayref(AArrayref node) {
        Type exprType = this.getOutType(node.getExpr());
        if (exprType != null && !this.isByteOrPidSubtype(exprType)) {
            this.addError(node.getLBracket(), new SubtypingError(exprType.name(), this.byteType().name()));
        }
    }

    private boolean isByteOrPidSubtype(Type exprType) {
        return exprType.isSubtype(this.byteType()) || exprType.isSubtype(this.pidType());
    }

    public void outARunFactor(ARunFactor node) {
        EnvEntry entry = this.env.get(node.getName().getText());
        if (!(entry instanceof ProctypeEntry)) {
            this.addError(node.getName(), new ElementDoesNotExistError(node.getName().getText(), PROCTYPE));
        } else {
            if (node.getArgLst() == null) {
                this.typeCheckRunArguments(this.proctypeFormalArgs(entry), new ArrayList(), node.getName());
            } else {
                this.typeCheckRunArguments(this.proctypeFormalArgs(entry), (List)this.getOut(node.getArgLst()), node.getName());
            }
            this.setOut(node, this.pidType());
        }
        node.setPid(this.nextPid++);
    }

    private List proctypeFormalArgs(EnvEntry entry) {
        return ((ProctypeEntry)entry).getArgTypes();
    }

    private void typeCheckRunArguments(List formalArgTypes, List actualArgTypes, TName proctypeName) {
        this.checkCorrectNumberOfActualArgs(formalArgTypes, actualArgTypes, proctypeName);
        int i = 0;
        while (i < this.minSize(formalArgTypes, actualArgTypes)) {
            if (actualArgTypes.get(i) != null && formalArgTypes.get(i) != null) {
                this.postSubtypingConstraint((Type)actualArgTypes.get(i), (Type)formalArgTypes.get(i), proctypeName);
            }
            ++i;
        }
    }

    private void checkCorrectNumberOfActualArgs(List formalArgs, List actualArgs, TName proctypeName) {
        if (formalArgs.size() != actualArgs.size()) {
            this.addError(proctypeName, new WrongNumArgsError(proctypeName.getText(), formalArgs.size(), actualArgs.size()));
        }
    }

    private int minSize(List x, List y) {
        return Math.min(x.size(), y.size());
    }

    public void outAConditionalExpr(AConditionalExpr node) {
        Type condType = this.getOutType(node.getIf());
        Type thenType = this.getOutType(node.getThen());
        Type elseType = this.getOutType(node.getElse());
        if (condType != null && !this.isBoolSubtype(condType)) {
            this.addError(node.getRightarrow(), new IfCondError(condType.name()));
        }
        if (thenType != null && elseType != null) {
            if (this.isChan(thenType) && this.isChan(elseType)) {
                this.postEqualityConstraint(thenType, elseType, node.getRightarrow());
                this.setOut(node, thenType);
            } else {
                try {
                    this.setOut(node, Type.max(thenType, elseType));
                }
                catch (IncomparableTypesException e) {
                    this.addError(node.getRightarrow(), new IfMismatchError(thenType.name(), elseType.name()));
                }
            }
        }
    }

    public void outACompoundOrExpr(ACompoundOrExpr node) {
        Type leftType = this.getOutType(node.getAndExpr());
        Type rightType = this.getOutType(node.getOrExpr());
        this.checkForNotBoolError(leftType, rightType, node.getOr());
        if (this.isBoolSubtype(leftType) && this.isBoolSubtype(rightType)) {
            this.setOut(node, this.boolType());
        }
    }

    private boolean isBoolSubtype(Type t) {
        return t.isSubtype(new BoolType());
    }

    public void outACompoundAndExpr(ACompoundAndExpr node) {
        Type leftType = this.getOutType(node.getBitorExpr());
        Type rightType = this.getOutType(node.getAndExpr());
        this.checkForNotBoolError(leftType, rightType, node.getAnd());
        if (this.isBoolSubtype(leftType) && this.isBoolSubtype(rightType)) {
            this.setOut(node, this.boolType());
        }
    }

    public void outACompoundBitorExpr(ACompoundBitorExpr node) {
        this.checkNumericOperationOnNumericTypes(node, node.getBitor(), this.getOutType(node.getBitxorExpr()), this.getOutType(node.getBitorExpr()));
    }

    public void outACompoundBitxorExpr(ACompoundBitxorExpr node) {
        this.checkNumericOperationOnNumericTypes(node, node.getBitxor(), this.getOutType(node.getBitandExpr()), this.getOutType(node.getBitxorExpr()));
    }

    public void outACompoundBitandExpr(ACompoundBitandExpr node) {
        this.checkNumericOperationOnNumericTypes(node, node.getBitand(), this.getOutType(node.getEqExpr()), this.getOutType(node.getBitandExpr()));
    }

    public void outACompoundEqExpr(ACompoundEqExpr node) {
        Type leftType = this.getOutType(node.getRelExpr());
        Type rightType = this.getOutType(node.getEqExpr());
        if (leftType != null && rightType != null) {
            if (this.isChan(leftType) && this.isChan(rightType)) {
                this.setOut(node, this.boolType());
            } else if (!leftType.isSubtype(rightType) && !rightType.isSubtype(leftType)) {
                this.addError(node.getEqop(), new EqMismatchError(leftType.name(), rightType.name(), node.getEqop().getText()));
            } else {
                this.setOut(node, this.boolType());
            }
        }
    }

    public void outASimpleEqExpr(ASimpleEqExpr node) {
        this.setOut(node, this.getOut(node.getRelExpr()));
    }

    public void outACompoundrelopRelExpr(ACompoundrelopRelExpr node) {
        this.checkBooleanOperationOnNumericTypes(node, node.getRelop(), this.getOutType(node.getShiftExpr()), this.getOutType(node.getRelExpr()));
    }

    public void outACompoundgtRelExpr(ACompoundgtRelExpr node) {
        this.checkBooleanOperationOnNumericTypes(node, node.getGt(), this.getOutType(node.getShiftExpr()), this.getOutType(node.getRelExpr()));
    }

    public void outACompoundltRelExpr(ACompoundltRelExpr node) {
        this.checkBooleanOperationOnNumericTypes(node, node.getLt(), this.getOutType(node.getShiftExpr()), this.getOutType(node.getRelExpr()));
    }

    public void outACompoundShiftExpr(ACompoundShiftExpr node) {
        if (this.checkBothSidesNumeric(this.getOutType(node.getAddExpr()), this.getOutType(node.getShiftExpr()), node.getShiftop())) {
            this.setOut(node, this.getOutType(node.getAddExpr()));
        }
    }

    public void outACompoundplusAddExpr(ACompoundplusAddExpr node) {
        this.checkNumericOperationOnNumericTypes(node, node.getPlus(), this.getOutType(node.getMultExpr()), this.getOutType(node.getAddExpr()));
    }

    public void outACompoundminusAddExpr(ACompoundminusAddExpr node) {
        this.checkNumericOperationOnNumericTypes(node, node.getMinus(), this.getOutType(node.getMultExpr()), this.getOutType(node.getAddExpr()));
    }

    public void outACompoundMultExpr(ACompoundMultExpr node) {
        this.checkNumericOperationOnNumericTypes(node, node.getMultop(), this.getOutType(node.getUnExpr()), this.getOutType(node.getMultExpr()));
    }

    public void outANotUnExpr(ANotUnExpr node) {
        Type t = this.getOutType(node.getFactor());
        if (t != null) {
            if (t.isSubtype(this.boolType())) {
                this.setOut(node, t);
            } else {
                this.addError(node.getBang(), new NotBoolError(t.name(), node.getBang().getText(), Error.UNARY));
            }
        }
    }

    public void outAComplementUnExpr(AComplementUnExpr node) {
        Type t = this.getOutType(node.getFactor());
        if (t != null) {
            if (this.isNumeric(t)) {
                this.setOut(node, t);
            } else {
                this.addError(node.getComplement(), new NotNumericError(t.name(), node.getComplement().getText(), Error.UNARY));
            }
        }
    }

    public void outASimpleExpr(ASimpleExpr node) {
        this.setOut(node, this.getOut(node.getOrExpr()));
    }

    public void outASimpleOrExpr(ASimpleOrExpr node) {
        this.setOut(node, this.getOut(node.getAndExpr()));
    }

    public void outASimpleAndExpr(ASimpleAndExpr node) {
        this.setOut(node, this.getOut(node.getBitorExpr()));
    }

    public void outASimpleBitorExpr(ASimpleBitorExpr node) {
        this.setOut(node, this.getOut(node.getBitxorExpr()));
    }

    public void outASimpleBitxorExpr(ASimpleBitxorExpr node) {
        this.setOut(node, this.getOut(node.getBitandExpr()));
    }

    public void outASimpleBitandExpr(ASimpleBitandExpr node) {
        this.setOut(node, this.getOut(node.getEqExpr()));
    }

    public void outASimpleRelExpr(ASimpleRelExpr node) {
        this.setOut(node, this.getOut(node.getShiftExpr()));
    }

    public void outASimpleAddExpr(ASimpleAddExpr node) {
        this.setOut(node, this.getOut(node.getMultExpr()));
    }

    public void outASimpleShiftExpr(ASimpleShiftExpr node) {
        this.setOut(node, this.getOut(node.getAddExpr()));
    }

    public void outASimpleMultExpr(ASimpleMultExpr node) {
        this.setOut(node, this.getOut(node.getUnExpr()));
    }

    public void outASimpleUnExpr(ASimpleUnExpr node) {
        this.setOut(node, this.getOut(node.getFactor()));
    }

    public void outAParentheseFactor(AParentheseFactor node) {
        this.setOut(node, this.getOut(node.getExpr()));
    }

    public void outAConstFactor(AConstFactor node) {
        this.setOut(node, this.getOut(node.getConst()));
    }

    public void outATrueConst(ATrueConst node) {
        this.setOut(node, this.boolType());
    }

    public void outAPidConst(APidConst node) {
        this.setOut(node, this.pidType());
    }

    public void outAUnderscoreConst(AUnderscoreConst node) {
        this.setOut(node, this.factory.freshTypeVariable());
    }

    public void outAFalseConst(AFalseConst node) {
        this.setOut(node, this.boolType());
    }

    public void outATimeoutFactor(ATimeoutFactor node) {
        this.setOut(node, this.boolType());
    }

    public void outANonprogressFactor(ANonprogressFactor node) {
        this.setOut(node, this.boolType());
    }

    public void outAVarrefFactor(AVarrefFactor node) {
        this.setOut(node, this.getOut(node.getVarref()));
    }

    public void outAChanopFactor(AChanopFactor node) {
        Type varType = this.getOutType(node.getVarref());
        if (varType != null) {
            if (!this.isChan(varType)) {
                this.addError(node.getLParenthese(), new VariableNotChannelError(varType.name()));
            } else {
                this.setOut(node, this.boolType());
            }
        }
    }

    public void outALengthFactor(ALengthFactor node) {
        Type varType = this.getOutType(node.getVarref());
        if (varType != null) {
            if (!this.isChan(varType)) {
                this.addError(node.getLParenthese(), new VariableNotChannelError(varType.name()));
            } else {
                this.setOut(node, this.byteType());
            }
        }
    }

    public void outANumberConst(ANumberConst node) {
        long val = Long.parseLong(node.getNumber().getText());
        if (this.valueOutOfLegalRange(val)) {
            this.addError(node.getNumber(), new LiteralValueTooLargeError(val));
        } else if (node.getMinus() == null) {
            this.setOut(node, NumericType.typeOfNumericLiteral(val));
        } else {
            this.setOut(node, NumericType.typeOfNumericLiteral(val * -1L));
        }
    }

    private boolean valueOutOfLegalRange(long val) {
        return val > Integer.MAX_VALUE || val < -2147483647L;
    }

    public void outAAssertStmnt(AAssertStmnt node) {
        Type type = this.getOutType(node.getExpr());
        if (type != null && !type.isSubtype(this.boolType())) {
            this.addError(node.getAssert(), new SubtypingError(type.name(), this.boolType().name()));
        }
    }

    public void outAElseStmnt(AElseStmnt node) {
    }

    public void outABreakStmnt(ABreakStmnt node) {
    }

    private void processSend(PVarref chan, PSendArgs args, Token bang) {
        this.processCommunication(chan, (List)this.getOut(args), bang);
    }

    private void processReceive(PVarref chan, PRecvArgs args, Token query) {
        this.processCommunication(chan, (List)this.getOut(args), query);
    }

    public void processCommunication(PVarref chan, List argTypes, Token operator) {
        if (this.getOutType(chan) != null && argTypes != null) {
            List typeVariables = this.createTypeVariablesForCommunication(operator, argTypes);
            this.postEqualityConstraint(new ChanType(typeVariables), this.getOutType(chan), operator);
        }
    }

    public void outAListSendArgs(AListSendArgs node) {
        this.setOut(node, this.getOut(node.getArgLst()));
    }

    public void outAHeadedListSendArgs(AHeadedlistSendArgs node) {
        List tailTypes = (List)this.getOut(node.getArgLst());
        if (tailTypes != null && this.getOut(node.getExpr()) != null) {
            tailTypes.add(0, this.getOut(node.getExpr()));
            this.setOut(node, tailTypes);
        }
    }

    public void outAOneArgLst(AOneArgLst node) {
        this.setOut(node, this.processArg(node.getExpr()));
    }

    public void outAOneRecvArgs(AOneRecvArgs node) {
        this.setOut(node, this.processArg(node.getRecvArg()));
    }

    public void outAManyArgLst(AManyArgLst node) {
        this.setOut(node, this.processArgs(node.getExpr(), node.getArgLst()));
    }

    private List processArgs(Node head, Node tail) {
        List argumentTypes = (List)this.getOut(tail);
        argumentTypes.add(0, this.getOut(head));
        return argumentTypes;
    }

    private List processArg(Node arg) {
        ArrayList<Object> argumentType = new ArrayList<Object>();
        argumentType.add(this.getOut(arg));
        return argumentType;
    }

    public void outAOneTypenamelst(AOneTypenamelst node) {
        if (this.checkForUnsignedOnChannelError(node.getTypename())) {
            this.setOut(node, this.processArg(node.getTypename()));
        }
    }

    public void outAManyTypenamelst(AManyTypenamelst node) {
        if (this.checkForUnsignedOnChannelError(node.getTypename())) {
            this.setOut(node, this.processArgs(node.getTypename(), node.getTypenamelst()));
        }
    }

    private List createTypeVariablesForCommunication(Token operator, List actualArgTypes) {
        ArrayList typeVariables = new ArrayList();
        int i = 0;
        while (i < actualArgTypes.size()) {
            this.addTypeVariableForArgType(typeVariables, (Type)actualArgTypes.get(i), operator);
            ++i;
        }
        return typeVariables;
    }

    private void addTypeVariableForArgType(List variables, Type argType, Token operator) {
        TypeVariableType tv = this.factory.freshTypeVariable();
        if (this.isBang(operator) || this.isTypeOfNumericConstant(argType)) {
            this.postSubtypingConstraint(argType, tv, operator);
        } else {
            this.postSubtypingConstraint(tv, argType, operator);
        }
        variables.add(tv);
    }

    private boolean isTypeOfNumericConstant(Type t) {
        return this.isNumeric(t) && ((NumericType)t).isTypeOfConstant();
    }

    private boolean isBang(Token operator) {
        return operator instanceof TBang || operator instanceof TBangBang;
    }

    public void outAFifoSend(AFifoSend node) {
        this.processSend(node.getVarref(), node.getSendArgs(), node.getBang());
    }

    public void outASortedSend(ASortedSend node) {
        this.processSend(node.getVarref(), node.getSendArgs(), node.getBangBang());
    }

    public void outAFifoReceive(AFifoReceive node) {
        this.processReceive(node.getVarref(), node.getRecvArgs(), node.getQuery());
    }

    public void outARandomReceive(ARandomReceive node) {
        this.processReceive(node.getVarref(), node.getRecvArgs(), node.getQueryQuery());
    }

    public void outAFifopollReceive(AFifopollReceive node) {
        this.processReceive(node.getVarref(), node.getRecvArgs(), node.getQuery());
    }

    public void outARandompollReceive(ARandompollReceive node) {
        this.processReceive(node.getVarref(), node.getRecvArgs(), node.getQueryQuery());
    }

    public void outAFifoRecvPoll(AFifoRecvPoll node) {
        this.processReceive(node.getVarref(), node.getRecvArgs(), node.getQuery());
        this.setOut(node, this.boolType());
    }

    public void outARandomRecvPoll(ARandomRecvPoll node) {
        this.processReceive(node.getVarref(), node.getRecvArgs(), node.getQueryQuery());
        this.setOut(node, this.boolType());
    }

    public void outAManyheadedRecvArgs(AManyheadedRecvArgs node) {
        this.setOut(node, this.processArgs(node.getRecvArg(), node.getRecvArgs()));
    }

    public void outAManyRecvArgs(AManyRecvArgs node) {
        this.setOut(node, this.processArgs(node.getRecvArg(), node.getRecvArgs()));
    }

    public void outAVarRecvArg(AVarRecvArg node) {
        this.setOut(node, this.getOut(node.getVarref()));
    }

    public void outAEvalRecvArg(AEvalRecvArg node) {
        Type t = this.getOutType(node.getExpr());
        if (this.isNumeric(t)) {
            ((NumericType)t).setConstantType();
        }
        this.setOut(node, t);
    }

    public void outAConstRecvArg(AConstRecvArg node) {
        this.setOut(node, this.getOut(node.getConst()));
    }

    public void caseAProctype(AProctype node) {
        this.dealWithEnabler(node);
        this.env.openScope();
        this.dealWithDeclarations(node);
        this.currentProctype = this.getParameterNamesAndTypes(node.getDeclLst());
        EnvEntry existingEntry = this.env.putGlobal(node.getName().getText(), this.currentProctype);
        if (existingEntry != null) {
            this.addError(node.getName(), new NameAlreadyUsedError(node.getName().getText(), existingEntry));
        }
        node.getSequence().apply(this);
        ((ProctypeEntry)this.env.get(node.getName().getText())).setLocalVariableTypeInfo(this.env.getTopVariables());
        this.env.closeScope();
    }

    private ProctypeEntry getParameterNamesAndTypes(PDeclLst parameters) {
        ArrayList argTypes = new ArrayList();
        ArrayList argNames = new ArrayList();
        if (parameters != null) {
            while (parameters instanceof AManyDeclLst) {
                argTypes.addAll(this.getArgumentTypes(this.getNames((AManyDeclLst)parameters)));
                argNames.addAll(this.getArgumentNames(this.getNames((AManyDeclLst)parameters)));
                parameters = ((AManyDeclLst)parameters).getDeclLst();
            }
            argTypes.addAll(this.getArgumentTypes(this.getNames((AOneDeclLst)parameters)));
            argNames.addAll(this.getArgumentNames(this.getNames((AOneDeclLst)parameters)));
        }
        Assert.assertEquals(argTypes.size(), argNames.size());
        return new ProctypeEntry(argTypes, argNames);
    }

    private PIvarLst getNames(AOneDeclLst typedArgs) {
        return ((AOneDecl)typedArgs.getOneDecl()).getIvarLst();
    }

    private PIvarLst getNames(AManyDeclLst typedArgs) {
        return ((AOneDecl)typedArgs.getOneDecl()).getIvarLst();
    }

    private void dealWithDeclarations(AProctype node) {
        if (node.getDeclLst() != null) {
            node.getDeclLst().apply(this);
        }
    }

    private void dealWithEnabler(AProctype node) {
        if (node.getEnabler() != null) {
            node.getEnabler().apply(this);
        }
    }

    private void setToMaxType(Node node, Type left, Type right) {
        if (this.isNumeric(left) && this.isNumeric(right)) {
            try {
                this.setOut(node, Type.max(left, right));
            }
            catch (IncomparableTypesException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    private boolean checkForNotNumericError(Type t, Token operator, int nature) {
        if (t != null) {
            if (!this.isNumeric(t)) {
                this.addError(operator, new NotNumericError(t.name(), operator.getText(), nature));
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean checkForUnsignedOnChannelError(PTypename typename) {
        if (typename instanceof AUnsignedTypename) {
            this.addError(((AUnsignedTypename)typename).getUnsigned(), new NoUnsignedOnChannelError());
            return false;
        }
        return true;
    }

    private boolean checkBothSidesNumeric(Type left, Type right, Token operator) {
        return this.checkForNotNumericError(left, operator, Error.LEFT) && this.checkForNotNumericError(right, operator, Error.RIGHT);
    }

    private void checkNumericOperationOnNumericTypes(Node node, Token operation, Type leftType, Type rightType) {
        if (this.checkBothSidesNumeric(leftType, rightType, operation)) {
            this.setToMaxType(node, leftType, rightType);
        }
    }

    private void checkBooleanOperationOnNumericTypes(Node node, Token operation, Type leftType, Type rightType) {
        if (this.checkBothSidesNumeric(leftType, rightType, operation)) {
            this.setOut(node, this.boolType());
        }
    }

    private void checkForNotBoolError(Type t, Token operator, int nature) {
        if (t != null && !this.isBoolSubtype(t)) {
            this.addError(operator, new NotBoolError(t.name(), operator.getText(), nature));
        }
    }

    private void checkForNotBoolError(Type left, Type right, Token operator) {
        this.checkForNotBoolError(left, operator, Error.LEFT);
        this.checkForNotBoolError(right, operator, Error.RIGHT);
    }

    private List getArgumentNames(PIvarLst names) {
        ArrayList<String> result = new ArrayList<String>();
        while (names instanceof AManyIvarLst) {
            result.add(((ASingleIvar)((AManyIvarLst)names).getIvar()).getName().getText());
            names = ((AManyIvarLst)names).getIvarLst();
        }
        result.add(((ASingleIvar)((AOneIvarLst)names).getIvar()).getName().getText());
        return result;
    }

    private List getArgumentTypes(PIvarLst names) {
        String currentName;
        ArrayList<Type> result = new ArrayList<Type>();
        while (names instanceof AManyIvarLst) {
            currentName = ((ASingleIvar)((AManyIvarLst)names).getIvar()).getName().getText();
            result.add(((VarEntry)this.env.get(currentName)).getType());
            names = ((AManyIvarLst)names).getIvarLst();
        }
        currentName = ((ASingleIvar)((AOneIvarLst)names).getIvar()).getName().getText();
        result.add(((VarEntry)this.env.get(currentName)).getType());
        return result;
    }

    private void processVar(PIvar var, Type groupType, boolean isHidden) {
        Type individualType = groupType;
        if (groupType instanceof UnsignedNumericType && var instanceof ASingleIvar && ((ASingleIvar)var).getWidth() == null) {
            this.addError(((ASingleIvar)var).getName(), new NoWidthForUnsignedTypeError(((ASingleIvar)var).getName().getText()));
            return;
        }
        if (!(groupType instanceof UnsignedNumericType) && var instanceof ASingleIvar && ((ASingleIvar)var).getWidth() != null) {
            this.addError(((ASingleIvar)var).getName(), new WidthForNonUnsignedTypeError(((ASingleIvar)var).getName().getText()));
        }
        if (groupType instanceof UnsignedNumericType && var instanceof ASingleIvar && ((ASingleIvar)var).getWidth() != null) {
            boolean error = false;
            AWidth width = (AWidth)((ASingleIvar)var).getWidth();
            if (!(width.getConst() instanceof ANumberConst)) {
                error = true;
            } else if (((ANumberConst)width.getConst()).getMinus() != null) {
                error = true;
            } else {
                int noBits = Integer.parseInt(((ANumberConst)width.getConst()).getNumber().getText());
                if (noBits > 0 && noBits < 32) {
                    individualType = new UnsignedNumericType(noBits);
                } else {
                    error = true;
                }
            }
            if (error) {
                this.addError(width.getColon(), new UnsignedTypeInitialisationError(width.getConst().toString()));
                return;
            }
        }
        if (this.isChan(groupType)) {
            individualType = new ChanType(this.factory.freshTypeVariable());
        }
        if (var instanceof AArrayIvar) {
            int length;
            Type initType = (Type)this.getOut(((AArrayIvar)var).getConst());
            if (initType != null) {
                if (!initType.isSubtype(this.byteType())) {
                    this.addError(((AArrayIvar)var).getName(), new SubtypingError(initType.name(), this.byteType().name()));
                    length = -1;
                } else {
                    length = Integer.parseInt(((ANumberConst)((AArrayIvar)var).getConst()).getNumber().getText());
                }
            } else {
                length = -1;
            }
            individualType = new ArrayType(groupType, this.factory.freshTypeVariable(), length);
            this.checkVar(((AArrayIvar)var).getIvarassignment(), ((AArrayIvar)var).getName(), individualType, isHidden);
        }
        if (var instanceof ASingleIvar) {
            this.checkVar(((ASingleIvar)var).getIvarassignment(), ((ASingleIvar)var).getName(), individualType, isHidden);
        }
    }

    private void checkVar(PIvarassignment assignment, TName name, Type type, boolean isHidden) {
        if (assignment instanceof AVariableIvarassignment) {
            this.checkVariableInitialisation((AVariableIvarassignment)assignment, type);
        }
        if (assignment instanceof AChannelIvarassignment) {
            this.checkChannelInitialisation((AChannelIvarassignment)assignment, type);
            this.addStaticChannelToEnvironment(name, type, (AChannelIvarassignment)assignment, isHidden);
            return;
        }
        this.addVariableToEnvironment(name, type, isHidden);
    }

    private void addVariableToEnvironment(TName name, Type type, boolean isHidden) {
        if (!this.inTypedef && this.nameExists(name.getText()) || this.nameExistsInTopScope(name.getText())) {
            this.addError(name, new NameAlreadyUsedError(name.getText(), this.env.get(name.getText())));
        } else {
            if (this.inTypedef) {
                this.typedefFieldNames.add(name.getText());
                this.typedefFieldTypes.add(type);
            }
            this.env.put(name.getText(), new VarEntry(type, isHidden));
        }
    }

    private void addStaticChannelToEnvironment(TName name, Type type, AChannelIvarassignment assignment, boolean isHidden) {
        if (!this.inTypedef && this.nameExists(name.getText()) || this.nameExistsInTopScope(name.getText())) {
            this.addError(name, new NameAlreadyUsedError(name.getText(), this.env.get(name.getText())));
        } else {
            int length = Integer.parseInt(((ANumberConst)assignment.getConst()).getNumber().getText());
            if (this.inTypedef) {
                this.typedefFieldNames.add(name.getText());
                this.typedefFieldTypes.add(type);
            }
            this.env.put(name.getText(), new ChannelEntry(new VarEntry(type, isHidden), length));
        }
    }

    private void checkVariableInitialisation(AVariableIvarassignment assignment, Type type) {
        Type assignType = this.getOutType(assignment.getExpr());
        if (assignType != null) {
            if (this.isChan(assignType)) {
                this.postEqualityConstraint(type, assignType, assignment.getAssign());
            } else if (this.isArray(type)) {
                if (!assignType.isSubtype(((ArrayType)type).getElementType())) {
                    this.addError(assignment.getAssign(), new AssignmentMismatchError(((ArrayType)type).getElementType().name(), assignType.name()));
                }
            } else if (!assignType.isSubtype(type)) {
                this.addError(assignment.getAssign(), new AssignmentMismatchError(type.name(), assignType.name()));
            }
        }
    }

    private void checkChannelInitialisation(AChannelIvarassignment assignment, Type type) {
        if (this.getChannelAssignmentTypeList(assignment) != null) {
            if (this.isChan(type)) {
                this.postEqualityConstraint(type, this.getChannelAssignmentType(assignment), assignment.getAssign());
            } else if (this.isArray(type) && this.isChan(((ArrayType)type).getElementType())) {
                this.postEqualityConstraint(((ArrayType)type).getElementType(), this.getChannelAssignmentType(assignment), assignment.getAssign());
            } else {
                this.addError(assignment.getAssign(), new AssignmentMismatchError(type.name(), this.getChannelAssignmentType(assignment).name()));
            }
        }
    }

    private ChanType getChannelAssignmentType(AChannelIvarassignment assignment) {
        return new ChanType(this.getChannelAssignmentTypeList(assignment));
    }

    private List getChannelAssignmentTypeList(AChannelIvarassignment assignment) {
        return (List)this.getOut(assignment.getTypenamelst());
    }

    private boolean nameExistsInTopScope(String name) {
        return this.env.getLocal(name) != null;
    }

    private void exitTypedef() {
        this.env.closeScope();
        this.inTypedef = false;
    }

    private void enterTypedef() {
        this.env.openScope();
        this.inTypedef = true;
        this.typedefFieldNames = new ArrayList();
        this.typedefFieldTypes = new ArrayList();
    }

    protected void addError(Token t, Error e) {
        if (this.callStack.isEmpty()) {
            this.errorTable.add(t.getLine(), e);
        } else {
            this.errorTable.add(t.getLine(), this.callStack, e);
        }
    }

    private void postEqualityConstraint(Type left, Type right, Token tok) {
        this.constraintSet.add(new EqualityConstraint(left, right, tok.getLine()));
    }

    private void postSubtypingConstraint(Type left, Type right, Token tok) {
        this.constraintSet.add(new SubtypingConstraint(left, right, tok.getLine()));
    }

    private Type getOutType(Node n) {
        return (Type)this.getOut(n);
    }

    private BoolType boolType() {
        return new BoolType();
    }

    private NumericType bitType() {
        return new NumericType(0);
    }

    private NumericType byteType() {
        return new NumericType(1);
    }

    private NumericType pidType() {
        return new NumericType(2);
    }

    private NumericType shortType() {
        return new NumericType(3);
    }

    private NumericType intType() {
        return new NumericType(4);
    }

    private boolean isChan(Type t) {
        return t instanceof ChanType;
    }

    private boolean isNumeric(Type t) {
        return t instanceof NumericType;
    }

    private boolean isArray(Type t) {
        return t instanceof ArrayType;
    }
}

