/*
 * Decompiled with CFR 0.152.
 */
package promela.env;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import junit.framework.Assert;
import promela.env.ChannelEntry;
import promela.env.EnvEntry;
import promela.env.ProctypeEntry;
import promela.env.VarEntry;
import promela.types.Type;
import promela.unifier.TypeSubstituter;

public class Env {
    private Vector stack = new Vector(1, 1);

    public Env() {
        this.stack.addElement(new Hashtable());
    }

    public void openScope() {
        this.stack.addElement(new Hashtable());
    }

    public void closeScope() {
        this.stack.removeElementAt(this.stack.size() - 1);
    }

    public EnvEntry putGlobal(String n, EnvEntry e) {
        EnvEntry result = this.get(n);
        ((Hashtable)this.stack.elementAt(0)).put(n, e);
        return result;
    }

    public EnvEntry put(String n, EnvEntry e) {
        return ((Hashtable)this.stack.elementAt(this.stack.size() - 1)).put(n, e);
    }

    public EnvEntry get(String n) {
        int i = this.stack.size() - 1;
        while (i >= 0) {
            EnvEntry e = (EnvEntry)((Hashtable)this.stack.elementAt(i)).get(n);
            if (e != null) {
                return e;
            }
            --i;
        }
        return null;
    }

    public EnvEntry getLocal(String n) {
        EnvEntry e = (EnvEntry)((Hashtable)this.stack.elementAt(this.stack.size() - 1)).get(n);
        return e;
    }

    public Map getTopVariableEntries() {
        HashMap<String, EnvEntry> result = new HashMap<String, EnvEntry>();
        Hashtable top = (Hashtable)this.stack.elementAt(this.stack.size() - 1);
        Enumeration i = top.keys();
        while (i.hasMoreElements()) {
            String s = (String)i.nextElement();
            EnvEntry e = (EnvEntry)top.get(s);
            if (!(e instanceof VarEntry)) continue;
            result.put(s, e);
        }
        return result;
    }

    public Map getTopVariables() {
        HashMap<String, Type> result = new HashMap<String, Type>();
        Hashtable top = (Hashtable)this.stack.elementAt(this.stack.size() - 1);
        Enumeration i = top.keys();
        while (i.hasMoreElements()) {
            String s = (String)i.nextElement();
            EnvEntry e = (EnvEntry)top.get(s);
            if (!(e instanceof VarEntry)) continue;
            result.put(s, ((VarEntry)e).getType());
        }
        return result;
    }

    public Map getProctypeEntries() {
        HashMap<String, EnvEntry> result = new HashMap<String, EnvEntry>();
        Hashtable bottom = (Hashtable)this.stack.elementAt(0);
        Enumeration i = bottom.keys();
        while (i.hasMoreElements()) {
            String s = (String)i.nextElement();
            EnvEntry e = (EnvEntry)bottom.get(s);
            if (!(e instanceof ProctypeEntry)) continue;
            result.put(s, e);
        }
        return result;
    }

    public Map getChannelEntries() {
        HashMap<String, EnvEntry> result = new HashMap<String, EnvEntry>();
        Hashtable bottom = (Hashtable)this.stack.elementAt(0);
        Enumeration i = bottom.keys();
        while (i.hasMoreElements()) {
            String s = (String)i.nextElement();
            EnvEntry e = (EnvEntry)bottom.get(s);
            if (!(e instanceof ChannelEntry)) continue;
            result.put(s, e);
        }
        return result;
    }

    public void applySubsitutions(TypeSubstituter substituter) {
        Assert.assertTrue(this.stack.size() == 1);
        Hashtable bottom = (Hashtable)this.stack.elementAt(0);
        Collection values = bottom.values();
        Iterator i = values.iterator();
        while (i.hasNext()) {
            EnvEntry e = (EnvEntry)i.next();
            if (e instanceof VarEntry) {
                Type oldType = ((VarEntry)e).getType();
                Type newType = substituter.applySubstitutions(oldType);
                ((VarEntry)e).setType(newType);
            }
            if (!(e instanceof ProctypeEntry)) continue;
            Map localVariables = ((ProctypeEntry)e).getLocalVariableTypeInfo();
            HashMap<String, Type> newLocalVariables = new HashMap<String, Type>();
            Iterator iter = localVariables.keySet().iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                newLocalVariables.put(name, substituter.applySubstitutions((Type)localVariables.get(name)));
            }
            ((ProctypeEntry)e).setLocalVariableTypeInfo(newLocalVariables);
        }
    }
}

