/*
 * Decompiled with CFR 0.152.
 */
package promela.group;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import promela.group.Permutation;
import promela.staticchanneldiagram.StaticChannelDiagramExtractor;

public class Group {
    private Set generators = new HashSet();
    private String nautyGenerators;

    public static Group createGroupWithNautyGenerators(String nautyGens, StaticChannelDiagramExtractor channelDiagram) {
        return new Group(nautyGens, channelDiagram);
    }

    public static Group createGroupWithSaucyGenerators(String saucyGens, StaticChannelDiagramExtractor channelDiagram) {
        return new Group(Group.saucyToNauty(saucyGens, channelDiagram), channelDiagram);
    }

    public static Group createGroupWithGAPGenerators(String gapGenerators, StaticChannelDiagramExtractor channelDiagram) {
        return new Group(Group.gapToNauty(gapGenerators), channelDiagram);
    }

    private Group(String nautyGenerators, StaticChannelDiagramExtractor channelDiagram) {
        this.nautyGenerators = nautyGenerators;
        StringTokenizer strtok = new StringTokenizer(nautyGenerators, "\n");
        while (strtok.hasMoreTokens()) {
            this.generators.add(new Permutation(strtok.nextToken(), channelDiagram));
        }
    }

    public Iterator iterator() {
        return this.generators.iterator();
    }

    public String toString() {
        if (this.generators.isEmpty()) {
            return "{id}";
        }
        String result = "<";
        Iterator i = this.generators.iterator();
        while (i.hasNext()) {
            result = String.valueOf(result) + i.next().toString();
            if (!i.hasNext()) continue;
            result = String.valueOf(result) + ",";
        }
        return String.valueOf(result) + ">";
    }

    public String gapGenerators() {
        if (this.isTrivialGroup()) {
            return "Group(());";
        }
        String result = "Group(";
        StringTokenizer elementSplitter = new StringTokenizer(this.nautyGenerators, "\n");
        while (elementSplitter.hasMoreTokens()) {
            StringTokenizer cycleSplitter = new StringTokenizer(elementSplitter.nextToken(), "()");
            while (cycleSplitter.hasMoreTokens()) {
                result = String.valueOf(result) + "(";
                StringTokenizer numberSplitter = new StringTokenizer(cycleSplitter.nextToken(), " ");
                while (numberSplitter.hasMoreTokens()) {
                    result = String.valueOf(result) + (Integer.parseInt(numberSplitter.nextToken()) + 1);
                    if (!numberSplitter.hasMoreTokens()) continue;
                    result = String.valueOf(result) + ",";
                }
                result = String.valueOf(result) + ")";
            }
            if (!elementSplitter.hasMoreTokens()) continue;
            result = String.valueOf(result) + ",";
        }
        result = String.valueOf(result) + ");";
        return result;
    }

    private boolean isTrivialGroup() {
        return this.nautyGenerators.equals("\n");
    }

    private static String gapToNauty(String s) {
        String result = "";
        StringTokenizer strtok = new StringTokenizer(s, "!\n");
        while (strtok.hasMoreTokens()) {
            result = String.valueOf(result) + Permutation.gap_to_nauty(strtok.nextToken()) + "\n";
        }
        return result;
    }

    private static String saucyToNauty(String gens, StaticChannelDiagramExtractor chanDiag) {
        String result = "";
        int[] colourPermutation = chanDiag.getColourPermutation();
        StringTokenizer strtok = new StringTokenizer(gens, "\n");
        while (strtok.hasMoreTokens()) {
            String generator = strtok.nextToken();
            StringTokenizer genSplitter = new StringTokenizer(generator, "(");
            while (genSplitter.hasMoreTokens()) {
                result = String.valueOf(result) + "(";
                String cycle = genSplitter.nextToken();
                StringTokenizer cycleSplitter = new StringTokenizer(cycle, " )");
                while (cycleSplitter.hasMoreTokens()) {
                    int number = Integer.parseInt(cycleSplitter.nextToken());
                    int i = 0;
                    while (i < colourPermutation.length) {
                        if (colourPermutation[i] == number) {
                            result = String.valueOf(result) + i;
                            break;
                        }
                        ++i;
                    }
                    if (!cycleSplitter.hasMoreTokens()) continue;
                    result = String.valueOf(result) + " ";
                }
                result = String.valueOf(result) + ")";
            }
            result = String.valueOf(result) + "\n";
        }
        return result;
    }
}

