/*
 * Decompiled with CFR 0.152.
 */
package promela.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import promela.analysis.DepthFirstAdapter;
import promela.group.NodeComparator;
import promela.node.AAtomicStmnt;
import promela.node.ACompoundAndExpr;
import promela.node.ACompoundOrExpr;
import promela.node.AInit;
import promela.node.AManySequence;
import promela.node.ANormalOptions;
import promela.node.AOneSequence;
import promela.node.ASimpleAndExpr;
import promela.node.ASimpleOrExpr;
import promela.node.AStmntStep;
import promela.node.PAndExpr;
import promela.node.PBitorExpr;
import promela.node.POptions;
import promela.node.POrExpr;
import promela.node.PSequence;
import promela.node.PStep;
import promela.node.PStmnt;

public class Normaliser
extends DepthFirstAdapter {
    public void outANormalOptions(ANormalOptions node) {
        if (!(node.parent() instanceof ANormalOptions)) {
            ArrayList<PSequence> optionList = new ArrayList<PSequence>();
            POptions temp = node;
            do {
                optionList.add(((ANormalOptions)temp).getSequence());
            } while ((temp = ((ANormalOptions)temp).getOptions()) != null);
            NodeComparator cmp = new NodeComparator();
            Collections.sort(optionList, cmp);
            temp = node;
            int i = 0;
            while (i < optionList.size()) {
                ((ANormalOptions)temp).setSequence((PSequence)optionList.get(i));
                temp = ((ANormalOptions)temp).getOptions();
                ++i;
            }
        }
    }

    public void outAInit(AInit node) {
        PSequence initSequence = node.getSequence();
        Assert.assertTrue(initSequence instanceof AOneSequence);
        PStmnt atomicStatement = ((AStmntStep)((AOneSequence)initSequence).getStep()).getStmnt();
        List allStatements = this.getListOfStatements(atomicStatement);
        this.sort(allStatements);
        this.replaceStatements(atomicStatement, allStatements);
    }

    private void replaceStatements(PStmnt atomicStatement, List newStatements) {
        Assert.assertTrue(atomicStatement instanceof AAtomicStmnt);
        PSequence sequence = ((AAtomicStmnt)atomicStatement).getSequence();
        int i = 0;
        while (sequence instanceof AManySequence) {
            ((AManySequence)sequence).setStep((PStep)newStatements.get(i));
            sequence = ((AManySequence)sequence).getSequence();
            ++i;
        }
        if (sequence instanceof AOneSequence) {
            ((AOneSequence)sequence).setStep((PStep)newStatements.get(i));
        }
    }

    private void sort(List list) {
        NodeComparator cmp = new NodeComparator();
        Collections.sort(list, cmp);
    }

    private List getListOfStatements(PStmnt atomicStatement) {
        ArrayList<PStep> allStatements = new ArrayList<PStep>();
        Assert.assertTrue(atomicStatement instanceof AAtomicStmnt);
        PSequence sequence = ((AAtomicStmnt)atomicStatement).getSequence();
        while (sequence instanceof AManySequence) {
            allStatements.add(((AManySequence)sequence).getStep());
            sequence = ((AManySequence)sequence).getSequence();
        }
        if (sequence instanceof AOneSequence) {
            allStatements.add(((AOneSequence)sequence).getStep());
        }
        return allStatements;
    }

    public void outACompoundOrExpr(ACompoundOrExpr node) {
        if (!(node.parent() instanceof POrExpr)) {
            ArrayList<PAndExpr> operands = new ArrayList<PAndExpr>();
            POrExpr temp = node;
            int i = 0;
            while (temp instanceof ACompoundOrExpr) {
                operands.add(i, ((ACompoundOrExpr)temp).getAndExpr());
                ++i;
                temp = ((ACompoundOrExpr)temp).getOrExpr();
            }
            operands.add(i, ((ASimpleOrExpr)temp).getAndExpr());
            Collections.sort(operands, new NodeComparator());
            temp = node;
            i = 0;
            while (temp instanceof ACompoundOrExpr) {
                ((ACompoundOrExpr)temp).setAndExpr((PAndExpr)operands.get(i));
                ++i;
                temp = ((ACompoundOrExpr)temp).getOrExpr();
            }
            ((ASimpleOrExpr)temp).setAndExpr((PAndExpr)operands.get(i));
        }
    }

    public void outACompoundAndExpr(ACompoundAndExpr node) {
        if (!(node.parent() instanceof PAndExpr)) {
            ArrayList<PBitorExpr> operands = new ArrayList<PBitorExpr>();
            PAndExpr temp = node;
            int i = 0;
            while (temp instanceof ACompoundAndExpr) {
                operands.add(i, ((ACompoundAndExpr)temp).getBitorExpr());
                ++i;
                temp = ((ACompoundAndExpr)temp).getAndExpr();
            }
            operands.add(i, ((ASimpleAndExpr)temp).getBitorExpr());
            Collections.sort(operands, new NodeComparator());
            temp = node;
            i = 0;
            while (temp instanceof ACompoundAndExpr) {
                ((ACompoundAndExpr)temp).setBitorExpr((PBitorExpr)operands.get(i));
                ++i;
                temp = ((ACompoundAndExpr)temp).getAndExpr();
            }
            ((ASimpleAndExpr)temp).setBitorExpr((PBitorExpr)operands.get(i));
        }
    }

    private boolean isRunStatement(PStep step) {
        return step.toString().substring(0, 4).equals("run ");
    }
}

