/*
 * Decompiled with CFR 0.152.
 */
package promela.group;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import promela.group.NodeComparator;
import promela.group.Normaliser;
import promela.group.Permuter;
import promela.node.Node;
import promela.staticchanneldiagram.StaticChannelDiagramExtractor;

public class Permutation {
    private Map theMap = new HashMap();
    private String nautyRep;

    public Permutation(String nautyperm, StaticChannelDiagramExtractor chanDiag) {
        this.nautyRep = nautyperm;
        StringTokenizer permSplitter = new StringTokenizer(nautyperm, "()");
        while (permSplitter.hasMoreTokens()) {
            String first;
            String cycle = permSplitter.nextToken();
            StringTokenizer cycleSplitter = new StringTokenizer(cycle, " ");
            String current = new String();
            String previous = first = cycleSplitter.nextToken();
            while (cycleSplitter.hasMoreTokens()) {
                current = cycleSplitter.nextToken();
                this.theMap.put(chanDiag.getNode(Integer.parseInt(previous)), chanDiag.getNode(Integer.parseInt(current)));
                previous = current;
            }
            this.theMap.put(chanDiag.getNode(Integer.parseInt(current)), chanDiag.getNode(Integer.parseInt(first)));
        }
    }

    public Permutation() {
    }

    public String gapRepresentation() {
        String result = "";
        StringTokenizer strtok = new StringTokenizer(this.nautyRep, "(");
        while (strtok.hasMoreTokens()) {
            result = String.valueOf(result) + "(";
            StringTokenizer strtok2 = new StringTokenizer(strtok.nextToken(), " )");
            while (strtok2.hasMoreTokens()) {
                result = String.valueOf(result) + (Integer.parseInt(strtok2.nextToken()) + 1);
                if (!strtok2.hasMoreTokens()) continue;
                result = String.valueOf(result) + ",";
            }
            result = String.valueOf(result) + ")";
        }
        return result;
    }

    public String toString() {
        String result = "";
        HashSet toDealWith = new HashSet(this.theMap.keySet());
        while (!toDealWith.isEmpty()) {
            Iterator i = toDealWith.iterator();
            Object cycleStart = i.next();
            result = ((String)cycleStart).charAt(cycleStart.toString().length() - 1) == ' ' ? String.valueOf(result) + "(" + cycleStart.toString().substring(0, cycleStart.toString().length() - 1) : String.valueOf(result) + "(" + cycleStart.toString();
            Object current = cycleStart;
            Object next = this.theMap.get(current);
            while (!next.equals(cycleStart)) {
                result = ((String)next).charAt(next.toString().length() - 1) == ' ' ? String.valueOf(result) + " " + next.toString().substring(0, next.toString().length() - 1) : String.valueOf(result) + " " + next.toString();
                toDealWith.remove(current);
                current = next;
                next = this.theMap.get(current);
            }
            toDealWith.remove(current);
            result = String.valueOf(result) + ")";
        }
        return result;
    }

    public Object apply(Object o) {
        if (this.theMap.containsKey(o)) {
            return this.theMap.get(o);
        }
        return o;
    }

    public Permutation inverse() {
        Permutation result = new Permutation();
        try {
            Iterator i = this.theMap.keySet().iterator();
            while (i.hasNext()) {
                Object o1 = i.next();
                Object o2 = this.theMap.get(o1);
                result.theMap.put(o2, o1);
            }
        }
        catch (Exception e) {
            System.out.println("EXCEPTION WHILE FINDING INVERSE");
            System.out.println(this);
            e.printStackTrace();
            System.exit(1);
        }
        return result;
    }

    public boolean isSafeFor(Node theAST, StaticChannelDiagramExtractor typeInfo) {
        Node originalAST = (Node)theAST.clone();
        originalAST.apply(new Normaliser());
        theAST.apply(new Permuter(this, typeInfo));
        Node permutedAST = (Node)theAST.clone();
        permutedAST.apply(new Normaliser());
        theAST.apply(new Permuter(this.inverse(), typeInfo));
        return new NodeComparator().compare(originalAST, permutedAST) == 0;
    }

    public static String gap_to_nauty(String gap_perm) {
        String result = "";
        StringTokenizer strtok = new StringTokenizer(gap_perm, "()");
        while (strtok.hasMoreTokens()) {
            result = String.valueOf(result) + "(";
            StringTokenizer strtok2 = new StringTokenizer(strtok.nextToken(), " ,");
            while (strtok2.hasMoreTokens()) {
                result = String.valueOf(result) + (Integer.parseInt(strtok2.nextToken()) - 1);
                if (!strtok2.hasMoreTokens()) continue;
                result = String.valueOf(result) + " ";
            }
            result = String.valueOf(result) + ")";
        }
        return result;
    }
}

