/*
 * Decompiled with CFR 0.152.
 */
package promela.lexer;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PushbackReader;
import promela.lexer.LexerException;
import promela.node.EOF;
import promela.node.TActivetok;
import promela.node.TAnd;
import promela.node.TAssert;
import promela.node.TAssign;
import promela.node.TAt;
import promela.node.TAtomic;
import promela.node.TBang;
import promela.node.TBangBang;
import promela.node.TBit;
import promela.node.TBitand;
import promela.node.TBitor;
import promela.node.TBitxor;
import promela.node.TBool;
import promela.node.TBreak;
import promela.node.TByte;
import promela.node.TByteliteral;
import promela.node.TChan;
import promela.node.TChanop;
import promela.node.TColon;
import promela.node.TColonColon;
import promela.node.TComma;
import promela.node.TComplement;
import promela.node.TDStep;
import promela.node.TDo;
import promela.node.TDot;
import promela.node.TElse;
import promela.node.TEnabled;
import promela.node.TEndOfLineComment;
import promela.node.TEqop;
import promela.node.TEval;
import promela.node.TFalse;
import promela.node.TFi;
import promela.node.TFor;
import promela.node.TGoto;
import promela.node.TGt;
import promela.node.THidden;
import promela.node.TIf;
import promela.node.TInittok;
import promela.node.TInlinetok;
import promela.node.TInt;
import promela.node.TLBrace;
import promela.node.TLBracket;
import promela.node.TLParenthese;
import promela.node.TLen;
import promela.node.TLt;
import promela.node.TMinus;
import promela.node.TMinusMinus;
import promela.node.TMtypetok;
import promela.node.TMultop;
import promela.node.TName;
import promela.node.TNevertok;
import promela.node.TNotrace;
import promela.node.TNp;
import promela.node.TNumber;
import promela.node.TOd;
import promela.node.TOf;
import promela.node.TOr;
import promela.node.TOver;
import promela.node.TPcValue;
import promela.node.TPid;
import promela.node.TPlus;
import promela.node.TPlusPlus;
import promela.node.TPrint;
import promela.node.TPrioritytok;
import promela.node.TProcessid;
import promela.node.TProctypetok;
import promela.node.TProvided;
import promela.node.TQuery;
import promela.node.TQueryQuery;
import promela.node.TQuotes;
import promela.node.TRBrace;
import promela.node.TRBracket;
import promela.node.TRParenthese;
import promela.node.TRelop;
import promela.node.TRightarrow;
import promela.node.TRun;
import promela.node.TSeparator;
import promela.node.TShiftop;
import promela.node.TShort;
import promela.node.TShow;
import promela.node.TSkip;
import promela.node.TString;
import promela.node.TTemplatetok;
import promela.node.TTimeout;
import promela.node.TTracetok;
import promela.node.TTraditionalComment;
import promela.node.TTrue;
import promela.node.TTypedef;
import promela.node.TUnderscore;
import promela.node.TUnless;
import promela.node.TUnsigned;
import promela.node.TWhiteSpace;
import promela.node.TXr;
import promela.node.TXs;
import promela.node.Token;

public class Lexer {
    protected Token token;
    protected State state = State.INITIAL;
    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();
    private static int[][][][] gotoTable;
    private static int[][] accept;
    static /* synthetic */ Class class$0;

    protected void filter() throws LexerException, IOException {
    }

    public Lexer(PushbackReader in) {
        this.in = in;
        if (gotoTable == null) {
            try {
                int j;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("promela.lexer.Lexer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                DataInputStream s = new DataInputStream(new BufferedInputStream(clazz.getResourceAsStream("lexer.dat")));
                int length = s.readInt();
                gotoTable = new int[length][][][];
                int i = 0;
                while (i < gotoTable.length) {
                    length = s.readInt();
                    Lexer.gotoTable[i] = new int[length][][];
                    j = 0;
                    while (j < gotoTable[i].length) {
                        length = s.readInt();
                        Lexer.gotoTable[i][j] = new int[length][3];
                        int k = 0;
                        while (k < gotoTable[i][j].length) {
                            int l = 0;
                            while (l < 3) {
                                Lexer.gotoTable[i][j][k][l] = s.readInt();
                                ++l;
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                length = s.readInt();
                accept = new int[length][];
                i = 0;
                while (i < accept.length) {
                    length = s.readInt();
                    Lexer.accept[i] = new int[length];
                    j = 0;
                    while (j < accept[i].length) {
                        Lexer.accept[i][j] = s.readInt();
                        ++j;
                    }
                    ++i;
                }
                s.close();
            }
            catch (Exception e) {
                throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
            }
        }
    }

    public Token peek() throws LexerException, IOException {
        while (this.token == null) {
            this.token = this.getToken();
            this.filter();
        }
        return this.token;
    }

    public Token next() throws LexerException, IOException {
        while (this.token == null) {
            this.token = this.getToken();
            this.filter();
        }
        Token result = this.token;
        this.token = null;
        return result;
    }

    protected Token getToken() throws IOException, LexerException {
        int dfa_state = 0;
        int start_pos = this.pos;
        int start_line = this.line;
        int accept_state = -1;
        int accept_token = -1;
        int accept_length = -1;
        int accept_pos = -1;
        int accept_line = -1;
        int[][][] gotoTable = Lexer.gotoTable[this.state.id()];
        int[] accept = Lexer.accept[this.state.id()];
        this.text.setLength(0);
        while (true) {
            int c;
            if ((c = this.getChar()) != -1) {
                switch (c) {
                    case 10: {
                        if (this.cr) {
                            this.cr = false;
                            break;
                        }
                        ++this.line;
                        this.pos = 0;
                        break;
                    }
                    case 13: {
                        ++this.line;
                        this.pos = 0;
                        this.cr = true;
                        break;
                    }
                    default: {
                        ++this.pos;
                        this.cr = false;
                    }
                }
                this.text.append((char)c);
                block101: do {
                    int oldState = dfa_state < -1 ? -2 - dfa_state : dfa_state;
                    dfa_state = -1;
                    int[][] tmp1 = gotoTable[oldState];
                    int low = 0;
                    int high = tmp1.length - 1;
                    while (low <= high) {
                        int middle = (low + high) / 2;
                        int[] tmp2 = tmp1[middle];
                        if (c < tmp2[0]) {
                            high = middle - 1;
                            continue;
                        }
                        if (c > tmp2[1]) {
                            low = middle + 1;
                            continue;
                        }
                        dfa_state = tmp2[2];
                        continue block101;
                    }
                } while (dfa_state < -1);
            } else {
                dfa_state = -1;
            }
            if (dfa_state >= 0) {
                if (accept[dfa_state] == -1) continue;
                accept_state = dfa_state;
                accept_token = accept[dfa_state];
                accept_length = this.text.length();
                accept_pos = this.pos;
                accept_line = this.line;
                continue;
            }
            if (accept_state == -1) break;
            switch (accept_token) {
                case 0: {
                    Token token = this.new0(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 1: {
                    Token token = this.new1(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 2: {
                    Token token = this.new2(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 3: {
                    Token token = this.new3(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 4: {
                    Token token = this.new4(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 5: {
                    Token token = this.new5(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 6: {
                    Token token = this.new6(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 7: {
                    Token token = this.new7(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 8: {
                    Token token = this.new8(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 9: {
                    Token token = this.new9(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 10: {
                    Token token = this.new10(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 11: {
                    Token token = this.new11(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 12: {
                    Token token = this.new12(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 13: {
                    Token token = this.new13(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 14: {
                    Token token = this.new14(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 15: {
                    Token token = this.new15(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 16: {
                    Token token = this.new16(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 17: {
                    Token token = this.new17(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 18: {
                    Token token = this.new18(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 19: {
                    Token token = this.new19(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 20: {
                    Token token = this.new20(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 21: {
                    Token token = this.new21(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 22: {
                    Token token = this.new22(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 23: {
                    Token token = this.new23(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 24: {
                    Token token = this.new24(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 25: {
                    Token token = this.new25(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 26: {
                    Token token = this.new26(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 27: {
                    Token token = this.new27(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 28: {
                    Token token = this.new28(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 29: {
                    Token token = this.new29(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 30: {
                    Token token = this.new30(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 31: {
                    Token token = this.new31(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 32: {
                    Token token = this.new32(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 33: {
                    Token token = this.new33(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 34: {
                    Token token = this.new34(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 35: {
                    Token token = this.new35(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 36: {
                    Token token = this.new36(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 37: {
                    Token token = this.new37(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 38: {
                    Token token = this.new38(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 39: {
                    Token token = this.new39(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 40: {
                    Token token = this.new40(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 41: {
                    Token token = this.new41(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 42: {
                    Token token = this.new42(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 43: {
                    Token token = this.new43(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 44: {
                    Token token = this.new44(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 45: {
                    Token token = this.new45(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 46: {
                    Token token = this.new46(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 47: {
                    Token token = this.new47(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 48: {
                    Token token = this.new48(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 49: {
                    Token token = this.new49(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 50: {
                    Token token = this.new50(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 51: {
                    Token token = this.new51(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 52: {
                    Token token = this.new52(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 53: {
                    Token token = this.new53(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 54: {
                    Token token = this.new54(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 55: {
                    Token token = this.new55(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 56: {
                    Token token = this.new56(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 57: {
                    Token token = this.new57(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 58: {
                    Token token = this.new58(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 59: {
                    Token token = this.new59(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 60: {
                    Token token = this.new60(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 61: {
                    Token token = this.new61(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 62: {
                    Token token = this.new62(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 63: {
                    Token token = this.new63(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 64: {
                    Token token = this.new64(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 65: {
                    Token token = this.new65(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 66: {
                    Token token = this.new66(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 67: {
                    Token token = this.new67(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 68: {
                    Token token = this.new68(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 69: {
                    Token token = this.new69(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 70: {
                    Token token = this.new70(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 71: {
                    Token token = this.new71(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 72: {
                    Token token = this.new72(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 73: {
                    Token token = this.new73(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 74: {
                    Token token = this.new74(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 75: {
                    Token token = this.new75(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 76: {
                    Token token = this.new76(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 77: {
                    Token token = this.new77(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 78: {
                    Token token = this.new78(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 79: {
                    Token token = this.new79(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 80: {
                    Token token = this.new80(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 81: {
                    Token token = this.new81(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 82: {
                    Token token = this.new82(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 83: {
                    Token token = this.new83(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 84: {
                    Token token = this.new84(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 85: {
                    Token token = this.new85(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 86: {
                    Token token = this.new86(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 87: {
                    Token token = this.new87(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 88: {
                    Token token = this.new88(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 89: {
                    Token token = this.new89(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 90: {
                    Token token = this.new90(start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 91: {
                    Token token = this.new91(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 92: {
                    Token token = this.new92(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
                case 93: {
                    Token token = this.new93(this.getText(accept_length), start_line + 1, start_pos + 1);
                    this.pushBack(accept_length);
                    this.pos = accept_pos;
                    this.line = accept_line;
                    return token;
                }
            }
        }
        if (this.text.length() > 0) {
            throw new LexerException("[" + (start_line + 1) + "," + (start_pos + 1) + "]" + " Unknown token: " + this.text);
        }
        EOF token = new EOF(start_line + 1, start_pos + 1);
        return token;
    }

    Token new0(String text, int line, int pos) {
        return new TWhiteSpace(text, line, pos);
    }

    Token new1(String text, int line, int pos) {
        return new TTraditionalComment(text, line, pos);
    }

    Token new2(String text, int line, int pos) {
        return new TEndOfLineComment(text, line, pos);
    }

    Token new3(String text, int line, int pos) {
        return new TNumber(text, line, pos);
    }

    Token new4(int line, int pos) {
        return new TBang(line, pos);
    }

    Token new5(int line, int pos) {
        return new TComplement(line, pos);
    }

    Token new6(String text, int line, int pos) {
        return new TMultop(text, line, pos);
    }

    Token new7(int line, int pos) {
        return new TPlus(line, pos);
    }

    Token new8(int line, int pos) {
        return new TMinus(line, pos);
    }

    Token new9(String text, int line, int pos) {
        return new TShiftop(text, line, pos);
    }

    Token new10(String text, int line, int pos) {
        return new TEqop(text, line, pos);
    }

    Token new11(int line, int pos) {
        return new TBitand(line, pos);
    }

    Token new12(int line, int pos) {
        return new TBitor(line, pos);
    }

    Token new13(int line, int pos) {
        return new TBitxor(line, pos);
    }

    Token new14(int line, int pos) {
        return new TAnd(line, pos);
    }

    Token new15(int line, int pos) {
        return new TOr(line, pos);
    }

    Token new16(int line, int pos) {
        return new TLt(line, pos);
    }

    Token new17(int line, int pos) {
        return new TGt(line, pos);
    }

    Token new18(String text, int line, int pos) {
        return new TRelop(text, line, pos);
    }

    Token new19(int line, int pos) {
        return new TLParenthese(line, pos);
    }

    Token new20(int line, int pos) {
        return new TRParenthese(line, pos);
    }

    Token new21(int line, int pos) {
        return new TLBrace(line, pos);
    }

    Token new22(int line, int pos) {
        return new TRBrace(line, pos);
    }

    Token new23(int line, int pos) {
        return new TLBracket(line, pos);
    }

    Token new24(int line, int pos) {
        return new TRBracket(line, pos);
    }

    Token new25(String text, int line, int pos) {
        return new TSeparator(text, line, pos);
    }

    Token new26(int line, int pos) {
        return new TComma(line, pos);
    }

    Token new27(int line, int pos) {
        return new TDot(line, pos);
    }

    Token new28(int line, int pos) {
        return new TAssign(line, pos);
    }

    Token new29(int line, int pos) {
        return new TColonColon(line, pos);
    }

    Token new30(int line, int pos) {
        return new TColon(line, pos);
    }

    Token new31(int line, int pos) {
        return new TPlusPlus(line, pos);
    }

    Token new32(int line, int pos) {
        return new TMinusMinus(line, pos);
    }

    Token new33(int line, int pos) {
        return new TRightarrow(line, pos);
    }

    Token new34(int line, int pos) {
        return new TBangBang(line, pos);
    }

    Token new35(int line, int pos) {
        return new TQueryQuery(line, pos);
    }

    Token new36(int line, int pos) {
        return new TQuery(line, pos);
    }

    Token new37(int line, int pos) {
        return new TUnderscore(line, pos);
    }

    Token new38(int line, int pos) {
        return new TQuotes(line, pos);
    }

    Token new39(int line, int pos) {
        return new TAt(line, pos);
    }

    Token new40(int line, int pos) {
        return new TActivetok(line, pos);
    }

    Token new41(int line, int pos) {
        return new TAssert(line, pos);
    }

    Token new42(int line, int pos) {
        return new TAtomic(line, pos);
    }

    Token new43(int line, int pos) {
        return new TBit(line, pos);
    }

    Token new44(int line, int pos) {
        return new TBool(line, pos);
    }

    Token new45(int line, int pos) {
        return new TBreak(line, pos);
    }

    Token new46(int line, int pos) {
        return new TByte(line, pos);
    }

    Token new47(String text, int line, int pos) {
        return new TChanop(text, line, pos);
    }

    Token new48(int line, int pos) {
        return new TChan(line, pos);
    }

    Token new49(int line, int pos) {
        return new TDStep(line, pos);
    }

    Token new50(int line, int pos) {
        return new TDo(line, pos);
    }

    Token new51(int line, int pos) {
        return new TElse(line, pos);
    }

    Token new52(int line, int pos) {
        return new TEnabled(line, pos);
    }

    Token new53(int line, int pos) {
        return new TEval(line, pos);
    }

    Token new54(int line, int pos) {
        return new TFalse(line, pos);
    }

    Token new55(int line, int pos) {
        return new TFi(line, pos);
    }

    Token new56(int line, int pos) {
        return new TGoto(line, pos);
    }

    Token new57(int line, int pos) {
        return new THidden(line, pos);
    }

    Token new58(int line, int pos) {
        return new TIf(line, pos);
    }

    Token new59(int line, int pos) {
        return new TInittok(line, pos);
    }

    Token new60(int line, int pos) {
        return new TInlinetok(line, pos);
    }

    Token new61(int line, int pos) {
        return new TInt(line, pos);
    }

    Token new62(int line, int pos) {
        return new TLen(line, pos);
    }

    Token new63(int line, int pos) {
        return new TMtypetok(line, pos);
    }

    Token new64(int line, int pos) {
        return new TNevertok(line, pos);
    }

    Token new65(int line, int pos) {
        return new TNotrace(line, pos);
    }

    Token new66(int line, int pos) {
        return new TNp(line, pos);
    }

    Token new67(int line, int pos) {
        return new TOd(line, pos);
    }

    Token new68(int line, int pos) {
        return new TOf(line, pos);
    }

    Token new69(int line, int pos) {
        return new TPcValue(line, pos);
    }

    Token new70(int line, int pos) {
        return new TPid(line, pos);
    }

    Token new71(String text, int line, int pos) {
        return new TPrint(text, line, pos);
    }

    Token new72(int line, int pos) {
        return new TPrioritytok(line, pos);
    }

    Token new73(int line, int pos) {
        return new TProcessid(line, pos);
    }

    Token new74(int line, int pos) {
        return new TProctypetok(line, pos);
    }

    Token new75(int line, int pos) {
        return new TProvided(line, pos);
    }

    Token new76(int line, int pos) {
        return new TRun(line, pos);
    }

    Token new77(int line, int pos) {
        return new TShort(line, pos);
    }

    Token new78(int line, int pos) {
        return new TShow(line, pos);
    }

    Token new79(int line, int pos) {
        return new TSkip(line, pos);
    }

    Token new80(int line, int pos) {
        return new TTimeout(line, pos);
    }

    Token new81(int line, int pos) {
        return new TTracetok(line, pos);
    }

    Token new82(int line, int pos) {
        return new TTrue(line, pos);
    }

    Token new83(int line, int pos) {
        return new TTypedef(line, pos);
    }

    Token new84(int line, int pos) {
        return new TUnless(line, pos);
    }

    Token new85(int line, int pos) {
        return new TUnsigned(line, pos);
    }

    Token new86(int line, int pos) {
        return new TXr(line, pos);
    }

    Token new87(int line, int pos) {
        return new TXs(line, pos);
    }

    Token new88(int line, int pos) {
        return new TTemplatetok(line, pos);
    }

    Token new89(int line, int pos) {
        return new TFor(line, pos);
    }

    Token new90(int line, int pos) {
        return new TOver(line, pos);
    }

    Token new91(String text, int line, int pos) {
        return new TName(text, line, pos);
    }

    Token new92(String text, int line, int pos) {
        return new TByteliteral(text, line, pos);
    }

    Token new93(String text, int line, int pos) {
        return new TString(text, line, pos);
    }

    private int getChar() throws IOException {
        if (this.eof) {
            return -1;
        }
        int result = this.in.read();
        if (result == -1) {
            this.eof = true;
        }
        return result;
    }

    private void pushBack(int acceptLength) throws IOException {
        int length = this.text.length();
        int i = length - 1;
        while (i >= acceptLength) {
            this.eof = false;
            this.in.unread(this.text.charAt(i));
            --i;
        }
    }

    protected void unread(Token token) throws IOException {
        String text = token.getText();
        int length = text.length();
        int i = length - 1;
        while (i >= 0) {
            this.eof = false;
            this.in.unread(text.charAt(i));
            --i;
        }
        this.pos = token.getPos() - 1;
        this.line = token.getLine() - 1;
    }

    private String getText(int acceptLength) {
        StringBuffer s = new StringBuffer(acceptLength);
        int i = 0;
        while (i < acceptLength) {
            s.append(this.text.charAt(i));
            ++i;
        }
        return s.toString();
    }

    public static class State {
        public static final State INITIAL = new State(0);
        private int id;

        private State(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }
    }
}

