/*
 * Decompiled with CFR 0.152.
 */
package promela.staticchanneldiagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import promela.checker.Checker;
import promela.env.ChannelEntry;
import promela.env.ProctypeEntry;
import promela.node.AAtomicStmnt;
import promela.node.AChannelIvarassignment;
import promela.node.AFifoReceive;
import promela.node.AFifoRecvPoll;
import promela.node.AFifoSend;
import promela.node.AFifopollReceive;
import promela.node.AInit;
import promela.node.AManyArgLst;
import promela.node.AOneArgLst;
import promela.node.AOneSequence;
import promela.node.AProctype;
import promela.node.ARandomReceive;
import promela.node.ARandomRecvPoll;
import promela.node.ARandompollReceive;
import promela.node.ARunFactor;
import promela.node.ASingleIvar;
import promela.node.ASortedSend;
import promela.node.AStmntStep;
import promela.node.PArgLst;
import promela.node.PIvar;
import promela.node.PSequence;
import promela.node.TSeparator;
import promela.staticchanneldiagram.ProcessEntry;
import utilities.StringHelper;

public class StaticChannelDiagramExtractor
extends Checker {
    protected List processEntries = new ArrayList();
    private List staticChannelNames = new ArrayList();
    protected List proctypeNames = new ArrayList();
    private Set distinctChannelSignatures = new HashSet();
    private int[] colourPermutation;
    private List colourPartition;
    private boolean inProctype = false;

    public StaticChannelDiagramExtractor() {
        super(true);
    }

    public List getStaticChannelNames() {
        return Collections.unmodifiableList(this.staticChannelNames);
    }

    public Set getDistinctChannelSignatures() {
        return Collections.unmodifiableSet(this.distinctChannelSignatures);
    }

    public List getColourPartition() {
        return Collections.unmodifiableList(this.colourPartition);
    }

    public void caseTSeparator(TSeparator node) {
        node.setText(";");
    }

    public String directedSaucyRepresentation() {
        ArrayList edges = new ArrayList();
        this.colourPartition = new ArrayList();
        this.colourPermutation = new int[this.staticChannelNames.size() + this.processEntries.size()];
        int i = 0;
        while (i < this.colourPermutation.length) {
            this.colourPermutation[i] = -1;
            ++i;
        }
        this.computeDistinctChannelSignatures();
        this.assignProcessColours();
        this.assignChannelColours();
        ListIterator li = this.processEntries.listIterator();
        while (li.hasNext()) {
            ProcessEntry processEntry = (ProcessEntry)li.next();
            this.addEdges(edges, processEntry, this.proctypeForProcess(processEntry), true);
            this.addEdges(edges, processEntry, this.proctypeForProcess(processEntry), false);
        }
        return this.constructSaucyOutput(edges);
    }

    private void computeDistinctChannelSignatures() {
        Map channelEntries = this.getEnv().getChannelEntries();
        Iterator iter = channelEntries.values().iterator();
        while (iter.hasNext()) {
            this.addChannelEntry((ChannelEntry)iter.next());
        }
    }

    private String constructSaucyOutput(List edges) {
        String result = String.valueOf(this.processEntries.size() + this.staticChannelNames.size()) + " ";
        result = String.valueOf(result) + edges.size() / 2 + " ";
        result = String.valueOf(result) + (this.colourPartition.size() + 1) + " ";
        int k = 0;
        while (k < this.colourPartition.size()) {
            result = String.valueOf(result) + this.colourPartition.get(k) + " ";
            ++k;
        }
        k = 0;
        while (k < edges.size()) {
            result = String.valueOf(result) + edges.get(k) + " ";
            ++k;
        }
        return result;
    }

    private ProctypeEntry proctypeForProcess(ProcessEntry processEntry) {
        return (ProctypeEntry)this.getEnvEntry(processEntry.getProctypeName());
    }

    public void outAInit(AInit node) {
        if (!this.hasCorrectForm(node.getSequence())) {
            System.out.println("When exploiting symmetry, the init process must consist of a single atomic statement");
            System.exit(0);
        }
    }

    private boolean hasCorrectForm(PSequence initSequence) {
        return initSequence instanceof AOneSequence && ((AOneSequence)initSequence).getStep() instanceof AStmntStep && ((AStmntStep)((AOneSequence)initSequence).getStep()).getStmnt() instanceof AAtomicStmnt;
    }

    private void addEdges(List edges, ProcessEntry processEntry, ProctypeEntry proctypeEntry, boolean outgoing) {
        Iterator iter = outgoing ? proctypeEntry.getOutChannels().iterator() : proctypeEntry.getInChannels().iterator();
        block0: while (iter.hasNext()) {
            String chanName = (String)iter.next();
            if (this.staticChannelNames.contains(chanName)) {
                if (outgoing) {
                    edges.add(new Integer(this.colourPermutation[this.processEntries.indexOf(processEntry)]));
                    edges.add(new Integer(this.colourPermutation[this.staticChannelNames.indexOf(chanName) + this.processEntries.size()]));
                    continue;
                }
                edges.add(new Integer(this.colourPermutation[this.staticChannelNames.indexOf(chanName) + this.processEntries.size()]));
                edges.add(new Integer(this.colourPermutation[this.processEntries.indexOf(processEntry)]));
                continue;
            }
            List argNames = proctypeEntry.getArgNames();
            int k = 0;
            while (k < argNames.size()) {
                if (chanName.equals(argNames.get(k))) {
                    if (outgoing) {
                        edges.add(new Integer(this.colourPermutation[this.processEntries.indexOf(processEntry)]));
                        edges.add(new Integer(this.colourPermutation[this.staticChannelNames.indexOf(processEntry.getParameterNames().get(k)) + this.processEntries.size()]));
                        continue block0;
                    }
                    edges.add(new Integer(this.colourPermutation[this.staticChannelNames.indexOf(processEntry.getParameterNames().get(k)) + this.processEntries.size()]));
                    edges.add(new Integer(this.colourPermutation[this.processEntries.indexOf(processEntry)]));
                    continue block0;
                }
                ++k;
            }
        }
    }

    private void assignChannelColours() {
        int marker = (Integer)this.colourPartition.get(this.colourPartition.size() - 1);
        Iterator iter = this.distinctChannelSignatures.iterator();
        while (iter.hasNext()) {
            ChannelEntry channelEntry = (ChannelEntry)iter.next();
            ListIterator j = this.staticChannelNames.listIterator();
            while (j.hasNext()) {
                String currentName = (String)j.next();
                ChannelEntry currentEntry = (ChannelEntry)this.getEnvEntry(currentName);
                if (!currentEntry.equal(channelEntry)) continue;
                this.colourPermutation[this.staticChannelNames.indexOf((Object)currentName) + this.processEntries.size()] = marker++;
            }
            if (!iter.hasNext()) continue;
            this.colourPartition.add(new Integer(marker));
        }
    }

    private void assignProcessColours() {
        int marker = 0;
        Iterator i = this.proctypeNames.iterator();
        while (i.hasNext()) {
            String proctypeName = (String)i.next();
            ListIterator j = this.processEntries.listIterator();
            while (j.hasNext()) {
                ProcessEntry currentProcessEntry = (ProcessEntry)j.next();
                if (!currentProcessEntry.getProctypeName().equals(proctypeName)) continue;
                this.colourPermutation[this.processEntries.indexOf((Object)currentProcessEntry)] = marker++;
            }
            this.colourPartition.add(new Integer(marker));
        }
    }

    public void caseAProctype(AProctype node) {
        this.inProctype = true;
        super.caseAProctype(node);
        this.proctypeNames.add(node.getName().getText());
        this.inProctype = false;
    }

    public void outARunFactor(ARunFactor node) {
        super.outARunFactor(node);
        ArrayList<String> parameterNames = new ArrayList<String>();
        PArgLst paramList = node.getArgLst();
        if (paramList != null) {
            while (paramList instanceof AManyArgLst) {
                parameterNames.add(StringHelper.removeWhitespace(((AManyArgLst)paramList).getExpr().toString()));
                paramList = ((AManyArgLst)paramList).getArgLst();
            }
            parameterNames.add(StringHelper.removeWhitespace(((AOneArgLst)paramList).getExpr().toString()));
        }
        this.processEntries.add(new ProcessEntry(node.getName().getText(), parameterNames));
    }

    public void outAChannelIvarassignment(AChannelIvarassignment node) {
        PIvar channel;
        if (this.inTypedef) {
            System.out.println("Dynamic channel creation is not permitted when applying symmetry reduction, therefore channels cannot be initialised inside a user defined type. <useful message on how to remodel>");
            System.exit(0);
        }
        if (this.inProctype) {
            System.out.println("Dynamic channel creation is not permitted when applying symmetry reduction, therefore channels cannot be initialised inside a proctype. <useful message on how to remodel>");
            System.exit(0);
        }
        if ((channel = (PIvar)node.parent()) instanceof ASingleIvar) {
            this.staticChannelNames.add(((ASingleIvar)channel).getName().getText());
        } else {
            System.out.println("Global arrays of channels are not permitted when applying symmetry reduction. <useful message on how to remodel>");
            System.exit(0);
        }
    }

    private void addChannelEntry(ChannelEntry channelEntry) {
        Iterator iter = this.distinctChannelSignatures.iterator();
        while (iter.hasNext()) {
            if (!channelEntry.equal((ChannelEntry)iter.next())) continue;
            return;
        }
        this.distinctChannelSignatures.add(channelEntry);
    }

    public void outAFifoSend(AFifoSend node) {
        this.currentProctype.addOutChannelName(StringHelper.removeWhitespace(node.getVarref().toString()));
        super.outAFifoSend(node);
    }

    public void outASortedSend(ASortedSend node) {
        super.outASortedSend(node);
    }

    public void outAFifoReceive(AFifoReceive node) {
        this.currentProctype.addInChannelName(StringHelper.removeWhitespace(node.getVarref().toString()));
        super.outAFifoReceive(node);
    }

    public void outARandomReceive(ARandomReceive node) {
        super.outARandomReceive(node);
    }

    public void outAFifopollReceive(AFifopollReceive node) {
        this.currentProctype.addInChannelName(StringHelper.removeWhitespace(node.getVarref().toString()));
        super.outAFifopollReceive(node);
    }

    public void outARandompollReceive(ARandompollReceive node) {
        super.outARandompollReceive(node);
    }

    public void outAFifoRecvPoll(AFifoRecvPoll node) {
        this.currentProctype.addInChannelName(StringHelper.removeWhitespace(node.getVarref().toString()));
        super.outAFifoRecvPoll(node);
    }

    public void outARandomRecvPoll(ARandomRecvPoll node) {
        super.outARandomRecvPoll(node);
    }

    public String getNode(int i) {
        if (i < this.processEntries.size()) {
            return String.valueOf(i + 1);
        }
        return (String)this.staticChannelNames.get(i - this.processEntries.size());
    }

    public int[] getColourPermutation() {
        return this.colourPermutation;
    }

    public int size() {
        return this.processEntries.size() + this.staticChannelNames.size();
    }

    public int getSaucyNumber(Object v) {
        Assert.assertTrue(v instanceof Integer || v instanceof String);
        if (v instanceof Integer) {
            return this.colourPermutation[(Integer)v - 1];
        }
        return this.colourPermutation[this.staticChannelNames.indexOf(v) + this.processEntries.size()];
    }

    public int getNoProcesses() {
        return this.processEntries.size();
    }

    public List getProctypeNames() {
        return Collections.unmodifiableList(this.proctypeNames);
    }

    public List getProcessEntries() {
        return Collections.unmodifiableList(this.processEntries);
    }
}

