/*
 * Decompiled with CFR 0.152.
 */
package promela.staticchanneldiagram;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import promela.analysis.DepthFirstAdapter;
import promela.node.ACompoundAndExpr;
import promela.node.ACompoundOrExpr;
import promela.node.ANormalOptions;
import promela.node.AProctype;
import promela.node.ASimpleAndExpr;
import promela.node.ASimpleOrExpr;
import promela.node.Node;
import promela.node.PAndExpr;
import promela.node.POrExpr;
import promela.node.TName;
import promela.staticchanneldiagram.ProcessAndChannelLiteralsDecorator;
import promela.staticchanneldiagram.StaticChannelDiagramExtractor;
import promela.staticchanneldiagram.TextualAdjacencyDiagramEdge;
import promela.staticchanneldiagram.TextualAdjacencyDiagramEdgeSet;

public class TextualAdjacencyDiagramExtractor
extends DepthFirstAdapter {
    private ProcessAndChannelLiteralsDecorator decorator;
    private Object lastLiteral;
    private TextualAdjacencyDiagramEdgeSet edges;
    private boolean inProctype;
    private Set lastLiteralSet;

    public TextualAdjacencyDiagramExtractor(ProcessAndChannelLiteralsDecorator decorator) {
        this(decorator, null, false);
    }

    public String saucyRepresentation(StaticChannelDiagramExtractor channelDiagram) {
        ArrayList<Integer> colourPartition = new ArrayList<Integer>();
        colourPartition.addAll(channelDiagram.getColourPartition());
        colourPartition.add(new Integer(channelDiagram.getColourPermutation().length));
        String result = String.valueOf(this.noNodes(channelDiagram)) + " " + this.edges.size() + " " + this.noColours(colourPartition) + " ";
        int i = 0;
        while (i < colourPartition.size()) {
            result = String.valueOf(result) + colourPartition.get(i) + " ";
            ++i;
        }
        Iterator iter = this.edges.iterator();
        while (iter.hasNext()) {
            TextualAdjacencyDiagramEdge edge = (TextualAdjacencyDiagramEdge)iter.next();
            result = this.addNodeNumber(result, edge.getV1(), channelDiagram);
            result = this.addNodeNumber(result, edge.getV2(), channelDiagram);
        }
        System.out.println(this.edges);
        return result;
    }

    private String addNodeNumber(String result, Object v1, StaticChannelDiagramExtractor channelDiagram) {
        result = this.isInitNode(v1) ? String.valueOf(result) + channelDiagram.size() + " " : String.valueOf(result) + channelDiagram.getSaucyNumber(v1) + " ";
        return result;
    }

    private boolean isInitNode(Object v) {
        return v instanceof Integer && (Integer)v == 0;
    }

    private int noColours(List colourPartition) {
        return colourPartition.size() + 1;
    }

    private int noNodes(StaticChannelDiagramExtractor channelDiagram) {
        return channelDiagram.getColourPermutation().length + 1;
    }

    public TextualAdjacencyDiagramEdgeSet getEdges() {
        return this.edges;
    }

    public void caseTName(TName node) {
        this.dealWithNode(node);
    }

    public void defaultIn(Node node) {
        this.dealWithNode(node);
    }

    private void dealWithNode(Node node) {
        Object decoration = this.getDecoration(node);
        if (this.inProctype && decoration != null) {
            if (this.lastLiteral == null) {
                this.lastLiteral = decoration;
            } else {
                if (this.lastLiteralSet != null) {
                    Iterator iter = this.lastLiteralSet.iterator();
                    while (iter.hasNext()) {
                        this.addEdge(iter.next(), decoration);
                    }
                    this.lastLiteralSet = null;
                } else {
                    this.addEdge(this.lastLiteral, decoration);
                }
                this.lastLiteral = decoration;
            }
        }
    }

    private TextualAdjacencyDiagramExtractor(ProcessAndChannelLiteralsDecorator decorator, Object lastLiteral, boolean inProctype) {
        Assert.assertTrue(lastLiteral == null || lastLiteral instanceof String || lastLiteral instanceof Integer);
        this.decorator = decorator;
        this.lastLiteral = lastLiteral;
        this.inProctype = inProctype;
        this.edges = new TextualAdjacencyDiagramEdgeSet();
        this.lastLiteralSet = null;
    }

    private void addEdge(Object v1, Object v2) {
        this.edges.add(new TextualAdjacencyDiagramEdge(v1, v2));
    }

    public void caseAProctype(AProctype node) {
        this.inProctype = true;
        node.getSequence().apply(this);
        this.inProctype = false;
    }

    public void caseANormalOptions(ANormalOptions node) {
        if (this.inProctype) {
            ANormalOptions temp = node;
            HashSet<Object> lastLiteralsForBranches = new HashSet<Object>();
            do {
                TextualAdjacencyDiagramExtractor edgeCollector = new TextualAdjacencyDiagramExtractor(this.decorator, this.lastLiteral, true);
                temp.getSequence().apply(edgeCollector);
                this.edges.addAll(edgeCollector.getEdges());
                if (edgeCollector.getLastLiteral() == null) continue;
                lastLiteralsForBranches.add(edgeCollector.getLastLiteral());
            } while ((temp = (ANormalOptions)temp.getOptions()) != null);
            if (!lastLiteralsForBranches.isEmpty()) {
                this.lastLiteralSet = lastLiteralsForBranches;
            }
        }
    }

    private Object getLastLiteral() {
        return this.lastLiteral;
    }

    public void caseACompoundOrExpr(ACompoundOrExpr node) {
        if (this.inProctype) {
            TextualAdjacencyDiagramExtractor edgeCollector;
            POrExpr temp = node;
            HashSet<Object> lastLiteralsForBranches = new HashSet<Object>();
            while (temp instanceof ACompoundOrExpr) {
                edgeCollector = new TextualAdjacencyDiagramExtractor(this.decorator, this.lastLiteral, true);
                temp.getAndExpr().apply(edgeCollector);
                this.edges.addAll(edgeCollector.getEdges());
                if (edgeCollector.getLastLiteral() != null) {
                    lastLiteralsForBranches.add(edgeCollector.getLastLiteral());
                }
                temp = temp.getOrExpr();
            }
            edgeCollector = new TextualAdjacencyDiagramExtractor(this.decorator, this.lastLiteral, true);
            ((ASimpleOrExpr)temp).getAndExpr().apply(edgeCollector);
            this.edges.addAll(edgeCollector.getEdges());
            if (edgeCollector.getLastLiteral() != null) {
                lastLiteralsForBranches.add(edgeCollector.getLastLiteral());
            }
            if (!lastLiteralsForBranches.isEmpty()) {
                this.lastLiteralSet = lastLiteralsForBranches;
            }
        }
    }

    public void caseACompoundAndExpr(ACompoundAndExpr node) {
        if (this.inProctype) {
            TextualAdjacencyDiagramExtractor edgeCollector;
            PAndExpr temp = node;
            HashSet<Object> lastLiteralsForBranches = new HashSet<Object>();
            while (temp instanceof ACompoundAndExpr) {
                edgeCollector = new TextualAdjacencyDiagramExtractor(this.decorator, this.lastLiteral, true);
                temp.getAndExpr().apply(edgeCollector);
                this.edges.addAll(edgeCollector.getEdges());
                if (edgeCollector.getLastLiteral() != null) {
                    lastLiteralsForBranches.add(edgeCollector.getLastLiteral());
                }
                temp = temp.getAndExpr();
            }
            edgeCollector = new TextualAdjacencyDiagramExtractor(this.decorator, this.lastLiteral, true);
            ((ASimpleAndExpr)temp).getBitorExpr().apply(edgeCollector);
            this.edges.addAll(edgeCollector.getEdges());
            if (edgeCollector.getLastLiteral() != null) {
                lastLiteralsForBranches.add(edgeCollector.getLastLiteral());
            }
            if (!lastLiteralsForBranches.isEmpty()) {
                this.lastLiteralSet = lastLiteralsForBranches;
            }
        }
    }

    private Object getDecoration(Node node) {
        return this.decorator.getOut(node);
    }
}

