/*
 * Decompiled with CFR 0.152.
 */
package promela.staticchanneldiagram;

import java.util.ArrayList;
import junit.framework.Assert;
import promela.analysis.DepthFirstAdapter;
import promela.env.VarEntry;
import promela.node.AOneDecl;
import promela.node.ARecordVarref;
import promela.node.ASingleVarref;
import promela.node.Node;
import promela.node.PVarref;
import promela.staticchanneldiagram.StaticChannelDiagramExtractor;
import promela.types.ArrayType;
import promela.types.NumericType;
import promela.types.RecordType;
import promela.types.Type;

public abstract class TypedSyntaxTreeAnalyser
extends DepthFirstAdapter {
    protected StaticChannelDiagramExtractor typeInfo;
    protected Type typename;

    public TypedSyntaxTreeAnalyser(StaticChannelDiagramExtractor typeInfo) {
        this.typeInfo = typeInfo;
        this.typename = null;
    }

    protected boolean isArrayIndexedByPid(PVarref varref) {
        PVarref temp = varref;
        Assert.assertTrue(varref instanceof ASingleVarref && ((ASingleVarref)varref).getArrayref() != null || varref instanceof ARecordVarref && ((ARecordVarref)varref).getArrayref() != null);
        ArrayList<String> fieldNamesStack = new ArrayList<String>();
        while (temp instanceof ARecordVarref) {
            fieldNamesStack.add(((ARecordVarref)temp).getName().getText());
            temp = ((ARecordVarref)temp).getVarref();
        }
        VarEntry envEntry = (VarEntry)this.typeInfo.getEnvEntry(((ASingleVarref)temp).getName().getText());
        if (envEntry == null) {
            return false;
        }
        Type t = envEntry.getType();
        while (!fieldNamesStack.isEmpty()) {
            Assert.assertTrue(t instanceof RecordType || t instanceof ArrayType && ((ArrayType)t).getElementType() instanceof RecordType);
            String fieldName = (String)fieldNamesStack.remove(fieldNamesStack.size() - 1);
            t = t instanceof RecordType ? ((RecordType)t).getFieldType(fieldName) : ((RecordType)((ArrayType)t).getElementType()).getFieldType(fieldName);
        }
        Assert.assertTrue(t instanceof ArrayType);
        return this.isPid(((ArrayType)t).getIndexType());
    }

    protected boolean isPid(Type t) {
        return t instanceof NumericType && ((NumericType)t).isPidType();
    }

    protected boolean isNumericNode(Node n) {
        try {
            Integer.parseInt(n.toString().substring(0, n.toString().length() - 1));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void inAOneDecl(AOneDecl node) {
        this.typename = (Type)this.typeInfo.getOut(node.getTypename());
    }

    public void outAOneDecl(AOneDecl node) {
        this.typename = null;
    }
}

