/*
 * Decompiled with CFR 0.152.
 */
package promela.types;

import java.util.List;
import promela.types.Type;
import promela.types.TypeVariableType;

public class ArrayType
extends Type {
    private Type elementType;
    private Type indexType;
    private int length;

    public ArrayType(Type elementType, Type indexType, int length) {
        this.elementType = elementType;
        this.indexType = indexType;
        this.length = length;
    }

    public Type getElementType() {
        return this.elementType;
    }

    public Type getIndexType() {
        return this.indexType;
    }

    public int getLength() {
        return this.length;
    }

    public String name() {
        return String.valueOf(this.elementType.name()) + "[" + this.indexType.name() + "]";
    }

    public boolean equal(Type t) {
        return t instanceof ArrayType && ((ArrayType)t).elementType.equal(this.elementType) && ((ArrayType)t).getIndexType().equal(this.indexType);
    }

    public boolean isSubtype(Type t) {
        return t.equal(this);
    }

    public Type findRecTypeConstructor(TypeVariableType tv) {
        return this.getElementType().findRecTypeConstructor(tv);
    }

    public boolean isDistinguishableFrom(Type t, Type outer, List numbering, boolean[][] distinguishable) {
        Type child1 = this.getElementType().skipRecursion(outer);
        Type child2 = ((ArrayType)t).getElementType().skipRecursion(outer);
        return distinguishable[numbering.indexOf(child1)][numbering.indexOf(child2)];
    }

    public boolean isDistinguishableFrom(Type t) {
        return !(t instanceof ArrayType);
    }
}

