/*
 * Decompiled with CFR 0.152.
 */
package promela.types;

import promela.types.ArrayType;
import promela.types.BoolType;
import promela.types.MtypeType;
import promela.types.NumericType;
import promela.types.TypeTest;

public class ArrayTypeTest
extends TypeTest {
    public void testEqual() throws Exception {
        ArrayType t1 = new ArrayType(this.createByte(), this.createByte(), 4);
        ArrayType t2 = new ArrayType(this.createByte(), this.createByte(), 4);
        ArrayTypeTest.assertTrue(t1.equal(t2));
        t2 = new ArrayType(this.createByte(), this.createPid(), 3);
        ArrayTypeTest.assertTrue(t1.equal(t2));
        NumericType.setPidSensitive(true);
        ArrayTypeTest.assertFalse(t1.equal(t2));
        t2 = new ArrayType(new MtypeType(), this.createByte(), 3);
        ArrayTypeTest.assertFalse(t1.equal(t2));
    }

    public void testIsSubtype() throws Exception {
        ArrayType t1 = new ArrayType(new MtypeType(), this.createByte(), 4);
        ArrayType t2 = new ArrayType(new MtypeType(), this.createByte(), 4);
        ArrayTypeTest.assertTrue(t1.isSubtype(t2));
        t2 = new ArrayType(new MtypeType(), this.createPid(), 4);
        ArrayTypeTest.assertTrue(t1.isSubtype(t2));
        NumericType.setPidSensitive(true);
        ArrayTypeTest.assertFalse(t1.isSubtype(t2));
        t2 = new ArrayType(new BoolType(), this.createByte(), 4);
        ArrayTypeTest.assertFalse(t1.isSubtype(t2));
    }

    public void testName() throws Exception {
        ArrayType t = new ArrayType(new MtypeType(), this.createPid(), 4);
        ArrayTypeTest.assertTrue(t.name().equals("mtype[pid]"));
        t = new ArrayType(new MtypeType(), this.createByte(), 4);
        ArrayTypeTest.assertTrue(t.name().equals("mtype[byte]"));
    }
}

