/*
 * Decompiled with CFR 0.152.
 */
package promela.types;

import java.util.ArrayList;
import promela.types.ArrayType;
import promela.types.BoolType;
import promela.types.ChanType;
import promela.types.MtypeType;
import promela.types.NumericType;
import promela.types.ProductType;
import promela.types.Type;
import promela.types.TypeTest;
import promela.types.TypeVariableType;

public class ChanTypeTest
extends TypeTest {
    public void testName() throws Exception {
        ArrayList al = this.constructListOfTypes();
        ChanType t = new ChanType(new ProductType(al));
        ChanTypeTest.assertTrue(t.name().equals("chan {X1,bit..int,mtype}"));
    }

    public void testEqual() throws Exception {
        ArrayList first = this.constructListOfTypes();
        ChanType t = new ChanType(new ProductType(first));
        ArrayList second = this.constructListOfTypes();
        ChanType u = new ChanType(new ProductType(second));
        ChanTypeTest.assertTrue(t.equal(u));
        second.add(new BoolType());
        u = new ChanType(new ProductType(first));
        ChanTypeTest.assertFalse(t.equals(u));
    }

    public void testIsSubtype() throws Exception {
        ArrayList first = this.constructListOfTypes();
        ChanType t = new ChanType(new ProductType(first));
        ArrayList<Type> second = this.constructListOfTypes();
        ChanType u = new ChanType(new ProductType(first));
        ChanTypeTest.assertTrue(t.isSubtype(u));
        second = new ArrayList<Type>();
        second.add(this.createByte());
        second.add(NumericType.typeOfNumericLiteral(0L));
        second.add(new MtypeType());
        u = new ChanType(new ProductType(second));
        ChanTypeTest.assertFalse(t.isSubtype(u));
        ChanTypeTest.assertFalse(t.isSubtype(new ArrayType(new MtypeType(), this.createByte(), 3)));
    }

    private ArrayList constructListOfTypes() {
        ArrayList<Type> types = new ArrayList<Type>();
        types.add(new TypeVariableType(1));
        types.add(NumericType.typeOfNumericLiteral(0L));
        types.add(new MtypeType());
        return types;
    }
}

