/*
 * Decompiled with CFR 0.152.
 */
package promela.types;

import promela.types.BoolType;
import promela.types.Type;
import promela.types.UnsignedNumericType;

public class NumericType
extends Type {
    protected static boolean pidSensitive = false;
    public static final int BIT = 0;
    public static final int BYTE = 1;
    public static final int PID = 2;
    public static final int SHORT = 3;
    public static final int INT = 4;
    public static final long MAX_INT = Integer.MAX_VALUE;
    public static final long MIN_INT = -2147483647L;
    private static final int noOfNumericTypes = 5;
    protected boolean[] hasType;
    private boolean aroseAsTypeOfConstant;

    public NumericType(int type) {
        this.initialise();
        this.hasType[type] = true;
    }

    protected NumericType() {
        this.initialise();
    }

    public static boolean isPidSensitive() {
        return pidSensitive;
    }

    public static void setPidSensitive(boolean isPidSensitive) {
        pidSensitive = isPidSensitive;
    }

    public void setConstantType() {
        this.aroseAsTypeOfConstant = true;
    }

    public boolean isPidType() {
        return this.hasType[2];
    }

    public boolean isBitType() {
        return this.hasType[0];
    }

    public boolean isTypeOfConstant() {
        return this.aroseAsTypeOfConstant;
    }

    void initialise() {
        this.aroseAsTypeOfConstant = false;
        this.hasType = new boolean[5];
        int i = 0;
        while (i < 5) {
            this.hasType[i] = false;
            ++i;
        }
    }

    public static NumericType typeOfNumericLiteral(long val) {
        NumericType result = new NumericType();
        result.aroseAsTypeOfConstant = true;
        result.hasType[4] = true;
        result.hasType[3] = val < 32768L && val > -32769L;
        result.hasType[1] = val < 256L && val >= 0L;
        result.hasType[2] = result.hasType[1];
        result.hasType[0] = val == 0L || val == 1L;
        return result;
    }

    public boolean isCompatible(NumericType t) {
        return this.hasType[0] && t.hasType[0] || this.hasType[1] && t.hasType[1] || this.hasType[2] && t.hasType[2] || this.hasType[2] && t.hasType[1] && !pidSensitive || this.hasType[1] && t.hasType[2] && !pidSensitive || this.hasType[3] && t.hasType[3] || this.hasType[4] && t.hasType[4];
    }

    public boolean isSubtype(Type t) {
        if (t instanceof BoolType & this.hasType[0]) {
            return true;
        }
        if (!(t instanceof NumericType)) {
            return false;
        }
        if (t instanceof UnsignedNumericType) {
            return this.isSubtype(((UnsignedNumericType)t).downCast());
        }
        if (!(!this.hasType[0] || ((NumericType)t).hasType[2] && pidSensitive)) {
            return true;
        }
        if (!(!this.hasType[1] || ((NumericType)t).hasType[0] || pidSensitive && ((NumericType)t).hasType[2])) {
            return true;
        }
        if (this.hasType[2] && pidSensitive && ((NumericType)t).hasType[2]) {
            return true;
        }
        if (this.hasType[2] && !pidSensitive && !((NumericType)t).hasType[0]) {
            return true;
        }
        if (this.hasType[3] && !((NumericType)t).hasType[0] && !((NumericType)t).hasType[1] && !((NumericType)t).hasType[2]) {
            return true;
        }
        return this.hasType[4] && !((NumericType)t).hasType[0] && !((NumericType)t).hasType[1] && !((NumericType)t).hasType[2] && !((NumericType)t).hasType[3];
    }

    public boolean equal(Type t) {
        if (!(t instanceof NumericType)) {
            return false;
        }
        int i = 0;
        while (i < 5) {
            if (this.hasType[i] != ((NumericType)t).hasType[i] && (pidSensitive || i != 1 && i != 2 || this.hasType[1] != ((NumericType)t).hasType[2] && (!this.hasType[2] || !((NumericType)t).hasType[1]))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String name() {
        int min = -1;
        int max = -1;
        int i = 0;
        while (i < 5) {
            if (this.hasType[i]) {
                if (min == -1) {
                    min = i;
                }
                max = i;
            }
            ++i;
        }
        if (max != min) {
            return String.valueOf(this.typeName(min)) + ".." + this.typeName(max);
        }
        return this.typeName(min);
    }

    private String typeName(int i) {
        switch (i) {
            case 0: {
                return "bit";
            }
            case 1: {
                return "byte";
            }
            case 2: {
                return "pid";
            }
            case 3: {
                return "short";
            }
        }
        return "int";
    }

    public boolean isDistinguishableFrom(Type t) {
        return !(t instanceof NumericType) || !this.isCompatible((NumericType)t);
    }

    public boolean isByteType() {
        return this.hasType[1];
    }
}

