/*
 * Decompiled with CFR 0.152.
 */
package promela.types;

import promela.types.BoolType;
import promela.types.MtypeType;
import promela.types.NumericType;
import promela.types.Type;
import promela.types.TypeTest;
import promela.types.UnsignedNumericType;

public class NumericTypeTest
extends TypeTest {
    public void testEqual() throws Exception {
        NumericType t1 = new NumericType(1);
        NumericType t2 = new NumericType(2);
        NumericTypeTest.assertTrue(((Type)t1).equal(t2));
        NumericType.setPidSensitive(true);
        NumericTypeTest.assertFalse(((Type)t1).equal(t2));
        t1 = new NumericType(0);
        t2 = new NumericType(3);
        NumericTypeTest.assertFalse(((Type)t1).equal(t2));
    }

    public void testName() throws Exception {
        NumericType t = new NumericType(1);
        NumericTypeTest.assertTrue(t.name().equals("byte"));
        t = NumericType.typeOfNumericLiteral(1L);
        NumericTypeTest.assertTrue(t.name().equals("bit..int"));
        t = NumericType.typeOfNumericLiteral(-10L);
        NumericTypeTest.assertTrue(t.name().equals("short..int"));
        NumericType.setPidSensitive(true);
        t = new NumericType(2);
        NumericTypeTest.assertTrue(t.name().equals("pid"));
    }

    public void testIsSubtype() throws Exception {
        NumericTypeTest.assertTrue(this.createBit().isSubtype(new BoolType()));
        NumericTypeTest.assertTrue(this.createLiteralType(4).isSubtype(this.createLiteralType(500)));
        NumericTypeTest.assertTrue(this.createLiteralType(200).isSubtype(this.createLiteralType(-1)));
        NumericTypeTest.assertTrue(this.createBit().isSubtype(new UnsignedNumericType(1)));
        NumericTypeTest.assertTrue(this.createByte().isSubtype(new UnsignedNumericType(8)));
        NumericTypeTest.assertTrue(this.createPid().isSubtype(new UnsignedNumericType(8)));
        NumericType.setPidSensitive(true);
        NumericTypeTest.assertFalse(this.createPid().isSubtype(new UnsignedNumericType(8)));
        NumericTypeTest.assertFalse(this.createLiteralType(304050203).isSubtype(this.createLiteralType(-1)));
        NumericTypeTest.assertFalse(this.createByte().isSubtype(new MtypeType()));
    }
}

