/*
 * Decompiled with CFR 0.152.
 */
package promela.types;

import java.util.List;
import promela.error.ErrorTable;
import promela.types.Type;
import promela.types.TypeVariableType;
import promela.unifier.ConstraintSet;
import promela.unifier.EqualityConstraint;

public class RecType
extends Type {
    private TypeVariableType boundVariable;
    private Type expression;

    public RecType(TypeVariableType boundVariable, Type expression) {
        this.boundVariable = boundVariable;
        this.expression = expression;
    }

    public Type getBody() {
        return this.expression;
    }

    public TypeVariableType getBoundVariable() {
        return this.boundVariable;
    }

    public String name() {
        return "rec " + this.boundVariable.name() + " . " + this.expression.name();
    }

    public boolean equal(Type t) {
        if (t instanceof RecType) {
            ConstraintSet cs = new ConstraintSet();
            cs.add(new EqualityConstraint(this.getBoundVariable(), this.getBody(), 0));
            cs.add(new EqualityConstraint(((RecType)t).getBoundVariable(), ((RecType)t).getBody(), 0));
            cs.add(new EqualityConstraint(this.getBoundVariable(), ((RecType)t).getBoundVariable(), 0));
            ErrorTable et = new ErrorTable();
            cs.unify(et);
            return !et.hasErrors();
        }
        return false;
    }

    public boolean isSubtype(Type t) {
        return t.equal(this);
    }

    public Type findRecTypeConstructor(TypeVariableType tv) {
        if (this.getBoundVariable().equals(tv)) {
            return this;
        }
        return null;
    }

    public Type skipRecursion(Type outer) {
        return this.getBody().skipRecursion(outer);
    }

    public boolean isDistinguishableFrom(Type t, Type outer, List numbering, boolean[][] distinguishable) {
        return false;
    }

    public boolean isDistinguishableFrom(Type t) {
        return false;
    }
}

