/*
 * Decompiled with CFR 0.152.
 */
package promela.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import promela.types.Type;

public class RecordType
extends Type {
    private String name;
    private List fieldNames;
    private List fieldTypes;

    public RecordType(String name, List fieldNames, List fieldTypes) {
        Assert.assertEquals(fieldNames.size(), fieldTypes.size());
        this.name = name;
        this.fieldNames = new ArrayList();
        this.fieldTypes = new ArrayList();
        int i = 0;
        while (i < fieldNames.size()) {
            Assert.assertTrue(fieldNames.get(i) instanceof String);
            Assert.assertTrue(fieldTypes.get(i) instanceof Type);
            this.fieldNames.add(fieldNames.get(i));
            this.fieldTypes.add(fieldTypes.get(i));
            ++i;
        }
    }

    public Type getFieldType(String fieldName) {
        Assert.assertTrue(this.fieldNames.contains(fieldName));
        return (Type)this.fieldTypes.get(this.fieldNames.indexOf(fieldName));
    }

    public String name() {
        String result = "typedef " + this.name + "{ ";
        int i = 0;
        while (i < this.fieldNames.size()) {
            result = String.valueOf(result) + this.getFieldType((String)this.fieldNames.get(i)).name() + " " + this.fieldNames.get(i);
            if (i < this.fieldNames.size() - 1) {
                result = String.valueOf(result) + "; ";
            }
            ++i;
        }
        return String.valueOf(result) + " }";
    }

    public boolean equal(Type t) {
        return t instanceof RecordType && t.name().equals(this.name());
    }

    public String getRecordName() {
        return this.name;
    }

    public List getFieldNames() {
        return Collections.unmodifiableList(this.fieldNames);
    }
}

